/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.consumer.cas2iob.application;

import de.julielab.jcore.consumer.cas2iob.application.ExtensionFileFilter;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.impl.XmiCasDeserializer;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.util.CasCreationUtils;
import org.apache.uima.util.XMLInputSource;
import org.apache.uima.util.XMLParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMIToIOBApplication {
    private static final Logger LOGGER = LoggerFactory.getLogger(XMIToIOBApplication.class);

    public static void main(String[] args) throws Exception {
        Path iobPath;
        File iobDir;
        if (args.length != 3) {
            System.out.println("Usage: XMIToIOBApplication <XMI directory> <TS descriptor> <consumer descriptor>");
            System.exit(0);
        }
        File xmiDir = new File(args[0]);
        String tsDescriptorName = args[1];
        String consumerDescriptorName = args[2];
        if (!xmiDir.exists() || !xmiDir.isDirectory()) {
            LOGGER.error("specified XMI dir does not exist or is not a directory: " + xmiDir);
            System.exit(-1);
        }
        LOGGER.info("Reading XMI file...");
        File[] xmis = xmiDir.listFiles(new ExtensionFileFilter("xmi"));
        if (xmis.length < 1) {
            LOGGER.error("specified directory contains no xmi files");
        }
        if (!(iobDir = new File((iobPath = Paths.get(xmiDir.getAbsolutePath(), "iob/")).toString())).exists()) {
            iobDir.mkdir();
        }
        XMLParser xmlParser = UIMAFramework.getXMLParser();
        TypeSystemDescription tsDesc = xmlParser.parseTypeSystemDescription(new XMLInputSource(tsDescriptorName));
        ResourceSpecifier spec = UIMAFramework.getXMLParser().parseResourceSpecifier(new XMLInputSource(consumerDescriptorName));
        AnalysisEngine toIOBConsumer = UIMAFramework.produceAnalysisEngine((ResourceSpecifier)spec);
        for (int i = 0; i < xmis.length; ++i) {
            File myXMI = xmis[i];
            System.out.println("Processing file " + myXMI.getAbsolutePath() + ".");
            FileInputStream inStream = new FileInputStream(myXMI);
            CAS myCAS = CasCreationUtils.createCas((TypeSystemDescription)tsDesc, null, null);
            XmiCasDeserializer.deserialize((InputStream)inStream, (CAS)myCAS);
            String outFile = Paths.get(iobPath.toString(), myXMI.getName()).toString() + ".iob";
            toIOBConsumer.setConfigParameterValue("outFileName", (Object)outFile);
            toIOBConsumer.reconfigure();
            LOGGER.debug("will write file to: " + outFile);
            toIOBConsumer.processCas(myCAS);
        }
    }
}

