/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.consumer.cas2iob.utils;

import java.util.ArrayList;
import java.util.List;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;

public class UIMAUtils {
    private static FSIterator initializeWindowCursor(JCas jCas, Annotation windowAnnotation) {
        FSIterator cursor = jCas.getAnnotationIndex().iterator();
        cursor.moveTo((FeatureStructure)windowAnnotation);
        while (cursor.isValid() && ((Annotation)cursor.get()).getBegin() >= windowAnnotation.getBegin()) {
            cursor.moveToPrevious();
        }
        if (cursor.isValid()) {
            cursor.moveToNext();
        } else {
            cursor.moveToFirst();
        }
        return cursor;
    }

    public static <T extends Annotation> List<T> getAnnotations(JCas jCas, Annotation windowAnnotation, Class<T> cls) {
        FSIterator cursor = UIMAUtils.initializeWindowCursor(jCas, windowAnnotation);
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        while (cursor.isValid() && ((Annotation)cursor.get()).getBegin() <= windowAnnotation.getEnd()) {
            Annotation annotation = (Annotation)cursor.get();
            if (cls.isInstance(annotation) && annotation.getEnd() <= windowAnnotation.getEnd()) {
                annotations.add((Annotation)cls.cast(annotation));
            }
            cursor.moveToNext();
        }
        return annotations;
    }

    public static <T extends Annotation> List<T> getExactAnnotations(JCas jCas, Annotation windowAnnotation, Class<T> cls) {
        List<Annotation> tmp = UIMAUtils.getAnnotations(jCas, windowAnnotation, cls);
        ArrayList<Annotation> finalList = new ArrayList<Annotation>();
        for (Annotation anno : tmp) {
            if (!UIMAUtils.hasSameOffset(windowAnnotation, anno)) continue;
            finalList.add(anno);
        }
        return finalList;
    }

    public static boolean hasSameOffset(Annotation a, Annotation b) {
        return a.getBegin() == b.getBegin() && a.getEnd() == b.getEnd();
    }
}

