/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.ae.jnet.utils;

import de.julielab.jcore.ae.jnet.utils.Utils;
import java.io.File;
import java.util.ArrayList;

public class IOBCheckerCleaner {
    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("usage: java IOBCheckerCleaner <iobFile in> <iobFile out>");
            System.exit(-1);
        }
        File inFile = new File(args[0]);
        File outFile = new File(args[1]);
        ArrayList<String> iobData = Utils.readFile(inFile);
        ArrayList<String> outData = new ArrayList<String>();
        String lastLine = "";
        int pos = 0;
        for (String line : iobData) {
            line = line.trim();
            line = line.replaceAll("[\\s]+", "\t");
            if (pos > 0 && lastLine.equals("") && line.equals("")) {
                System.err.println("consecutive empty lines in line: " + pos);
                System.exit(-1);
            }
            if (!line.equals("") && line.split("\t").length != 2) {
                System.err.println("incorrect line: " + line);
                System.exit(-1);
            }
            lastLine = line;
            ++pos;
            outData.add(line);
        }
        System.out.println("file OK... writing to: " + outFile);
        Utils.writeFile(outFile, outData);
    }
}

