/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.ae.likelihooddetection;

import de.julielab.java.utilities.FileUtilities;
import de.julielab.jcore.types.Lemma;
import de.julielab.jcore.types.LikelihoodIndicator;
import de.julielab.jcore.types.Token;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.descriptor.ResourceMetaData;
import org.apache.uima.fit.descriptor.TypeCapability;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ResourceMetaData(name="JCoRe Likelihood Detection AE", description="Analysis Engine to detect epistemic modal expressions and assign the appropriate likelihood category.")
@TypeCapability(inputs={"de.julielab.jcore.types.Token", "de.julielab.jcore.types.Lemma"}, outputs={"de.julielab.jcore.types.LikelihoodIndicator"})
public class LikelihoodDetectionAnnotator
extends JCasAnnotator_ImplBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(LikelihoodDetectionAnnotator.class);
    public static final String PARAM_LIKELIHOOD_DICT_PATH = "LikelihoodDict";
    private HashMap<String, String> likelihoodDictSimple = new HashMap();
    private ArrayList<Pair<String[], String>> likelihoodDictComplex = new ArrayList();
    @ConfigurationParameter(name="LikelihoodDict", description="String parameter indicating path to likelihood dictionary (One entry per line; Entries consist of tab-separated lemmatized likelihood indicators and assigned likelihood category)")
    private String dictFile;

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        this.dictFile = (String)aContext.getConfigParameterValue(PARAM_LIKELIHOOD_DICT_PATH);
        try {
            this.loadLikelihoodDict(this.dictFile);
        }
        catch (IOException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    public void process(JCas aJCas) throws AnalysisEngineProcessException {
        this.detectLikelihood(aJCas);
    }

    private void loadLikelihoodDict(String dictFilePath) throws IOException {
        InputStream resource = FileUtilities.findResource((String)dictFilePath);
        if (resource == null) {
            LOGGER.error("ERR: Could not find likelihood dictionary file (path: " + dictFilePath + ")");
            throw new IllegalArgumentException("Could not find likelihood dictionary at " + dictFilePath);
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(resource));){
            String line = "";
            while ((line = reader.readLine()) != null) {
                String[] entry = line.split("\t");
                if (entry.length != 2) {
                    LOGGER.error("ERR: Likelihood dictionary file not in expected format. Critical line: " + line);
                    throw new IllegalArgumentException("Likelihood dictionary has the wrong format (expected: two tab-separated columns). Critical line: " + line);
                }
                String indicator = entry[0].trim();
                String category = entry[1].trim();
                if (!indicator.contains(" ")) {
                    this.likelihoodDictSimple.put(indicator, category);
                    continue;
                }
                String[] indicatorArray = indicator.split(" ");
                this.likelihoodDictComplex.add((Pair<String[], String>)Pair.of((Object)indicatorArray, (Object)category));
            }
            reader.close();
            LOGGER.info("Done loading likelihood dictionary.");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void detectLikelihood(JCas aJCas) {
        FSIterator tokenIterator = aJCas.getAnnotationIndex(Token.type).iterator();
        while (tokenIterator.hasNext()) {
            Token token = (Token)tokenIterator.next();
            Lemma lemma = token.getLemma();
            if (null == lemma) continue;
            String lemmaStr = lemma.getValue();
            LOGGER.debug("Current lemma: " + lemmaStr);
            boolean isIndicator = false;
            int begin = 0;
            int end = 0;
            String category = "";
            if (this.likelihoodDictSimple.get(lemmaStr) != null) {
                isIndicator = true;
                LOGGER.debug("Exact match: " + lemmaStr);
                begin = token.getBegin();
                end = token.getEnd();
                category = this.likelihoodDictSimple.get(lemmaStr);
            } else {
                for (Pair<String[], String> entry : this.likelihoodDictComplex) {
                    String[] entryLemmas = (String[])entry.getLeft();
                    if (!entryLemmas[0].equals(lemmaStr)) continue;
                    isIndicator = true;
                    LOGGER.debug("First partial match: " + entryLemmas[0]);
                    begin = token.getBegin();
                    category = (String)entry.getRight();
                    int numNextTokens = 0;
                    for (int i = 1; i < entryLemmas.length && tokenIterator.isValid(); ++i) {
                        Token nextToken = (Token)tokenIterator.get();
                        if (nextToken.getLemma() == null) continue;
                        String nextLemmaStr = nextToken.getLemma().getValue();
                        if (entryLemmas[i].equals(nextLemmaStr)) {
                            end = nextToken.getEnd();
                            LOGGER.debug("Next partial match: " + entryLemmas[i]);
                            tokenIterator.moveToNext();
                            ++numNextTokens;
                            continue;
                        }
                        isIndicator = false;
                        LOGGER.debug("Matching aborted at: " + nextLemmaStr + " (Expected: " + entryLemmas[i] + ")");
                        for (int j = 0; j < numNextTokens; ++j) {
                            tokenIterator.moveToPrevious();
                        }
                        break;
                    }
                    if (!isIndicator) continue;
                    break;
                }
            }
            if (!isIndicator) continue;
            LikelihoodIndicator indicator = new LikelihoodIndicator(aJCas);
            indicator.setBegin(begin);
            indicator.setEnd(end);
            indicator.setLikelihood(category);
            indicator.setComponentId(((Object)((Object)this)).getClass().getName());
            indicator.addToIndexes(aJCas);
        }
    }
}

