/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.pipeline.runner.cpe;

import de.julielab.jcore.pipeline.builder.base.exceptions.PipelineIOException;
import de.julielab.jcore.pipeline.runner.cpe.StatusCallbackListener;
import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.uima.UIMAFramework;
import org.apache.uima.collection.CollectionProcessingEngine;
import org.apache.uima.collection.metadata.CpeDescription;
import org.apache.uima.collection.metadata.CpeDescriptorException;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CPERunner {
    protected String descriptorPath;
    protected CpeDescription cpeDescription;
    protected Options options = new Options();
    protected CollectionProcessingEngine cpe;
    protected StatusCallbackListener statusCallbackListener;
    protected Integer processingUnitThreadCount;
    protected Integer casPoolSize;
    protected Integer numbersOfDocuments;
    protected Integer batchSize;
    protected boolean error;
    private static final Logger LOGGER = LoggerFactory.getLogger(CPERunner.class);

    public static void main(String[] args) {
        CPERunner runner = new CPERunner();
        runner.process(args);
    }

    public CPERunner() {
        this.options.addOption("d", true, "JCoRe Pipeline Path");
        this.options.addOption("n", true, "numbers of documents to process (optional)");
        this.options.addOption("t", true, "processing unit thread count (optional)");
        this.options.addOption("a", true, "CAS pool size (optional)");
        this.options.addOption("b", true, "batch size (optional)");
    }

    public void parseArguments(String[] args) {
        String batchSizeString;
        String casPoolSizeString;
        String processingUnitThreadCountString;
        String numbersOfDocumentsString;
        CommandLine cmd;
        DefaultParser parser = new DefaultParser();
        try {
            cmd = parser.parse(this.options, args);
        }
        catch (ParseException e) {
            LOGGER.error("Can't parse arguments:", (Throwable)e);
            return;
        }
        this.descriptorPath = cmd.getOptionValue("d");
        if (this.descriptorPath == null) {
            System.err.println("-d option is missed");
            this.error = true;
        }
        if ((numbersOfDocumentsString = cmd.getOptionValue("n")) != null) {
            this.numbersOfDocuments = new Integer(numbersOfDocumentsString);
        }
        if ((processingUnitThreadCountString = cmd.getOptionValue("t")) != null) {
            this.processingUnitThreadCount = new Integer(processingUnitThreadCountString);
        }
        if ((casPoolSizeString = cmd.getOptionValue("a")) != null) {
            this.casPoolSize = new Integer(casPoolSizeString);
        }
        if ((batchSizeString = cmd.getOptionValue("b")) != null) {
            this.batchSize = new Integer(batchSizeString);
        }
    }

    public void createCPEDescription() throws InvalidXMLException, IOException, CpeDescriptorException, PipelineIOException {
        LOGGER.info("Creating CPE description from " + this.descriptorPath);
        this.cpeDescription = UIMAFramework.getXMLParser().parseCpeDescription(new XMLInputSource(this.descriptorPath));
        if (this.processingUnitThreadCount != null) {
            LOGGER.info("Setting processing unit thread count to " + this.processingUnitThreadCount);
            this.cpeDescription.setProcessingUnitThreadCount(this.processingUnitThreadCount.intValue());
        }
        if (this.casPoolSize != null) {
            LOGGER.info("Setting cas pool size to " + this.casPoolSize);
            this.cpeDescription.getCpeCasProcessors().setPoolSize(this.casPoolSize.intValue());
        }
        if (this.numbersOfDocuments != null) {
            LOGGER.info("Setting number of documents to process to " + this.numbersOfDocuments);
            this.cpeDescription.setNumToProcess((long)this.numbersOfDocuments.intValue());
        }
        if (this.batchSize != null) {
            LOGGER.info("Setting CPE checkpoint batch size to " + this.batchSize);
        } else {
            int descBatchSize = this.cpeDescription.getCpeConfiguration().getCheckpoint().getBatchSize();
            if (descBatchSize != 0) {
                LOGGER.info("Setting CPE checkpoint batch size to " + descBatchSize);
                this.batchSize = descBatchSize;
            } else {
                LOGGER.info("CPE Checkpoint batch size not set in CPE descriptor. Setting batch size to 2000");
                this.batchSize = 2000;
            }
        }
    }

    public void createCPE() throws InvalidXMLException, IOException, ResourceInitializationException, CpeDescriptorException {
        LOGGER.info("Creating CPE... ");
        this.cpe = UIMAFramework.produceCollectionProcessingEngine((CpeDescription)this.cpeDescription);
        this.statusCallbackListener = new StatusCallbackListener(this.cpe, this.batchSize);
        this.cpe.addStatusCallbackListener((org.apache.uima.collection.StatusCallbackListener)this.statusCallbackListener);
    }

    public boolean isError() {
        return this.error;
    }

    public void setError(boolean error) {
        this.error = error;
    }

    public void showHelpText() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("CPERunner", this.options);
    }

    public void run() throws ResourceInitializationException {
        LOGGER.info("Start processing ..");
        this.cpe.process();
    }

    public void process(String[] args) {
        this.parseArguments(args);
        if (this.isError()) {
            this.showHelpText();
            System.exit(1);
        }
        this.runCPE();
    }

    protected void runCPE() {
        try {
            this.createCPEDescription();
        }
        catch (Throwable e) {
            LOGGER.error("Error while creating the CPE description:", e);
            System.err.println("Can't create CPE description: " + e);
            System.exit(1);
        }
        try {
            this.createCPE();
        }
        catch (Throwable e) {
            LOGGER.error("Error while creating the CPE:", e);
            System.err.println("Can't create CPE: " + e);
            System.exit(1);
        }
        try {
            this.run();
        }
        catch (Throwable e) {
            LOGGER.error("Exception during processing:", e);
            System.err.println("Exception during processing: " + e);
            System.exit(1);
        }
    }

    public String getDescriptorPath() {
        return this.descriptorPath;
    }

    public CpeDescription getCpeDescription() {
        return this.cpeDescription;
    }

    public Options getOptions() {
        return this.options;
    }

    public CollectionProcessingEngine getCpe() {
        return this.cpe;
    }

    public StatusCallbackListener getStatusCallbackListener() {
        return this.statusCallbackListener;
    }

    public Integer getProcessingUnitThreadCount() {
        return this.processingUnitThreadCount;
    }

    public Integer getCasPoolSize() {
        return this.casPoolSize;
    }

    public Integer getNumbersOfDocuments() {
        return this.numbersOfDocuments;
    }
}

