/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.pipeline.runner.cpe;

import de.julielab.jcore.types.Header;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.collection.CollectionProcessingEngine;
import org.apache.uima.collection.EntityProcessStatus;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusCallbackListener
implements org.apache.uima.collection.StatusCallbackListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(StatusCallbackListener.class);
    int entityCount = 0;
    private CollectionProcessingEngine cpe;
    private ArrayList<byte[][]> processed = new ArrayList();
    private ArrayList<byte[][]> exceptions = new ArrayList();
    private HashMap<byte[][], String> logException = new HashMap();
    private long mInitCompleteTime;
    private long mBatchTime;
    private Integer batchSize;

    public StatusCallbackListener(CollectionProcessingEngine cpe, Integer batchSize) {
        this.cpe = cpe;
        this.batchSize = batchSize;
    }

    public void initializationComplete() {
        LOGGER.info("CPE Initialization complete");
        this.mInitCompleteTime = System.currentTimeMillis();
        this.mBatchTime = System.currentTimeMillis();
    }

    public synchronized void batchProcessComplete() {
        this.processed.clear();
        LOGGER.info("Completed " + this.entityCount + " documents");
    }

    public synchronized void collectionProcessComplete() {
        long time = System.currentTimeMillis();
        LOGGER.info("Completed " + this.entityCount + " documents");
        long processingTime = time - this.mInitCompleteTime;
        LOGGER.info("Processing Time: " + processingTime + " ms");
        LOGGER.info("\n\n ------------------ PERFORMANCE REPORT ------------------\n");
        LOGGER.info(this.cpe.getPerformanceReport().toString());
        System.exit(0);
    }

    public void paused() {
        LOGGER.info("Paused");
    }

    public void resumed() {
        LOGGER.info("Resumed");
    }

    public void aborted() {
        LOGGER.info("The CPE has been aborted by the framework. The JVM ist forcibly quit to avoid the application getting stuck on some threads that could not be stopped.");
        System.exit(1);
    }

    public synchronized void entityProcessComplete(CAS aCas, EntityProcessStatus aStatus) {
        block19: {
            try {
                JCas jCas = aCas.getJCas();
                String docId = "<unknown>";
                try {
                    Header header = (Header)JCasUtil.selectSingle((JCas)jCas, Header.class);
                    docId = header.getDocId();
                }
                catch (IllegalArgumentException e) {
                    LOGGER.debug("Document occurred that did not have Header annotation.");
                }
                if (!aStatus.isException()) {
                    LOGGER.debug("Document with ID {} finished processing.", (Object)docId);
                    break block19;
                }
                String filename = "pipeline-error-" + docId;
                LOGGER.debug("Exception occurred while processing document with ID {}. Writing error message to {}", new Object[]{docId, aStatus.getExceptions(), filename});
                String log = this.createLog(aStatus);
                try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(log), StandardCharsets.UTF_8));){
                    bw.write(log);
                    bw.newLine();
                }
            }
            catch (CASException e) {
                e.printStackTrace();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        ++this.entityCount;
    }

    public String createLog(EntityProcessStatus status) {
        StringBuilder builder = new StringBuilder();
        builder.append("Error happened on: " + new Date());
        builder.append("-------------- Failed Components -------------- \n");
        List componentNames = status.getFailedComponentNames();
        for (int i = 0; i < componentNames.size(); ++i) {
            builder.append(i + 1 + ". " + componentNames.get(i) + "\n");
        }
        builder.append("-------------- Stack Traces -------------- \n");
        List exceptions = status.getExceptions();
        for (int i = 0; i < exceptions.size(); ++i) {
            Throwable throwable = (Throwable)exceptions.get(i);
            StringWriter writer = new StringWriter();
            throwable.printStackTrace(new PrintWriter(writer));
            builder.append(writer.toString());
        }
        return builder.toString();
    }

    public CollectionProcessingEngine getCpe() {
        return this.cpe;
    }
}

