/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.reader.xmlmapper.genericTypes;

import de.julielab.jcore.reader.xmlmapper.genericTypes.TypeTemplate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class FeatureTemplate
extends TypeTemplate {
    private boolean type;
    private Map<String, String> valueMap = new HashMap<String, String>();
    private String tsName;

    public void addVauleMapping(String xmlElement, String value) {
        if (this.valueMap == null) {
            this.valueMap = new HashMap<String, String>();
        }
        this.valueMap.put(xmlElement, value);
    }

    public void setValueMap(HashMap<String, String> valueMapping) {
        this.valueMap = valueMapping;
    }

    public Map<String, String> getValueMap() {
        return this.valueMap;
    }

    public String getMappedValue(String xmlElement) {
        if (this.valueMap == null) {
            return xmlElement;
        }
        String mappedValue = this.valueMap.get(xmlElement);
        if (mappedValue == null && (mappedValue = this.valueMap.get("defaultValueMapping")) == null) {
            mappedValue = xmlElement;
        }
        return mappedValue;
    }

    public void setType(boolean type) {
        this.type = type;
    }

    public boolean isType() {
        return this.type;
    }

    @Override
    public String toString() {
        if (this.isType()) {
            return super.toString();
        }
        String out = "[FeatureTemplate] " + this.getFullClassName() + ":" + "at: " + Arrays.toString(this.xPaths.toArray());
        if (this.valueMap != null) {
            out = String.valueOf(out) + "\n  ValueMapping:";
            for (String key : this.valueMap.keySet()) {
                out = String.valueOf(out) + "\n" + key + " = " + this.valueMap.get(key);
            }
        }
        return out;
    }

    public String getTsName() {
        return this.tsName;
    }

    public void setTsName(String tsName) {
        this.tsName = tsName;
    }

    @Override
    public FeatureTemplate clone() {
        FeatureTemplate template = new FeatureTemplate();
        template.fullClassName = new String(this.fullClassName == null ? "" : this.fullClassName);
        template.features = new ArrayList();
        for (FeatureTemplate feature : this.features) {
            template.features.add(feature.clone());
        }
        template.parser = this.parser;
        template.xPaths = new ArrayList();
        for (String path : this.xPaths) {
            template.addXPath(new String(path));
        }
        template.externalParser = this.externalParser;
        template.additionalData = new HashMap();
        for (Integer id : this.additionalData.keySet()) {
            template.additionalData.put(id, (String)this.additionalData.get(id));
        }
        template.partOfDocuments = new ArrayList();
        for (Integer id : this.partOfDocuments) {
            template.partOfDocuments.add(id);
        }
        template.type = this.type;
        template.tsName = new String(this.tsName == null ? "" : this.tsName);
        template.valueMap = new HashMap<String, String>();
        for (String key : this.valueMap.keySet()) {
            template.valueMap.put(key, new String(this.valueMap.get(key)));
        }
        template.multipleInstances = this.multipleInstances;
        template.inlineAnnotation = this.inlineAnnotation;
        return template;
    }
}

