/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.reader.xmlmapper.genericTypes;

import de.julielab.jcore.reader.xmlmapper.genericTypes.FeatureTemplate;
import de.julielab.jcore.reader.xmlmapper.genericTypes.TypeTemplate;
import de.julielab.jcore.reader.xmlmapper.mapper.DocumentTextHandler;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.XMLEvent;
import org.apache.uima.collection.CollectionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeFactory {
    private static final String DEFAULT_VALUE_MAPPING = "default";
    private static final String ROOT = "mappings";
    private static final String DOCUMENT_TEXT = "documentText";
    private static final String PART_OF_DOCUMENT_TEXT = "partOfDocumentText";
    private static final String IS_TYPE = "isType";
    private static final String TS_FEATURE_NAME = "tsFeatureName";
    private static final String XML_ELEMENT = "xmlElement";
    private static final String FULL_CLASS_NAME = "tsFullClassName";
    private static final String TS_TYPE = "tsType";
    private static final String TS_FEATURE = "tsFeature";
    private static final String VALUE_X_PATH = "xPath";
    private static final String VALUE_MAPPING = "valueMapping";
    private static final String VALUE = "value";
    private static final String EXTERNAL_PARSER = "externalParser";
    private static final String ADDITIONAL_DATA = "additionalData";
    private static final String OFFSET = "offset";
    private static final String MULTI_INSTANCE = "multipleInstances";
    private static final String INLINE = "inline";
    private static final String ID = "id";
    Logger LOGGER = LoggerFactory.getLogger(TypeFactory.class);
    private List<TypeTemplate> types;
    private byte[] mappingFileData;
    private DocumentTextHandler documentTextParser;

    public TypeFactory(byte[] mappingFileData) {
        this.mappingFileData = mappingFileData;
        this.types = new ArrayList<TypeTemplate>();
        this.documentTextParser = new DocumentTextHandler();
    }

    public List<TypeTemplate> createTemplates() throws CollectionException {
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        ByteArrayInputStream in = null;
        in = new ByteArrayInputStream(this.mappingFileData);
        XMLEventReader reader = null;
        try {
            reader = inputFactory.createXMLEventReader(in);
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        while (reader.hasNext()) {
            XMLEvent event = null;
            try {
                event = reader.nextEvent();
            }
            catch (XMLStreamException e) {
                e.printStackTrace();
            }
            if (!event.isStartElement()) continue;
            String nodeName = event.asStartElement().getName().toString();
            if (nodeName.equals(TS_TYPE)) {
                TypeTemplate type = null;
                try {
                    Attribute multiAttribute;
                    type = this.parseType(reader);
                    Attribute inlineAttribute = event.asStartElement().getAttributeByName(new QName(INLINE));
                    if (inlineAttribute != null) {
                        type.setInlineAnnotation(Boolean.parseBoolean(inlineAttribute.getValue()));
                    }
                    if ((multiAttribute = event.asStartElement().getAttributeByName(new QName(MULTI_INSTANCE))) != null) {
                        type.setMultipleInstances(Boolean.parseBoolean(multiAttribute.getValue()));
                    }
                    this.types.add(type);
                }
                catch (XMLStreamException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (nodeName.equals(DOCUMENT_TEXT)) {
                try {
                    this.fillDocumentParser(reader);
                }
                catch (XMLStreamException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (nodeName.equals(ROOT)) continue;
            this.LOGGER.warn("unknown tag in mapping file: " + nodeName + "!!");
        }
        return this.types;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void fillDocumentParser(XMLEventReader reader) throws XMLStreamException, CollectionException {
        this.documentTextParser = new DocumentTextHandler();
        XMLEvent event = reader.nextEvent();
        int id = -1;
        while (!event.isEndElement() || !event.asEndElement().getName().toString().equals(DOCUMENT_TEXT)) {
            if (event.isStartElement()) {
                String nodeName = event.asStartElement().getName().toString();
                if (nodeName.equals(PART_OF_DOCUMENT_TEXT)) {
                    Iterator<Attribute> attributes = event.asStartElement().getAttributes();
                    if (!attributes.hasNext()) {
                        this.LOGGER.error("no id for partOfDocumentText");
                        throw new RuntimeException();
                    }
                    Attribute next = attributes.next();
                    if (next.getName().getLocalPart().equals(ID)) {
                        id = Integer.parseInt(next.getValue());
                        this.documentTextParser.addPartOfDocumentTextXPath(id);
                    }
                } else if (nodeName.equals(VALUE_X_PATH)) {
                    event = reader.nextEvent();
                    String xpath = "";
                    if (event.isCharacters()) {
                        xpath = event.asCharacters().getData();
                    }
                    if (xpath.length() > 0 && id >= 0) {
                        this.documentTextParser.setXPathForPartOfDocumentText(id, xpath);
                    } else {
                        this.LOGGER.error("Unkown data in documentText/xPath tag ");
                    }
                } else if (nodeName.equals(EXTERNAL_PARSER)) {
                    event = reader.nextEvent();
                    String externalParserClassName = "";
                    if (event.isCharacters()) {
                        externalParserClassName = event.asCharacters().getData();
                    }
                    if (externalParserClassName.length() > 0 && id >= 0) {
                        this.documentTextParser.setExternalParserForPartOfDocument(id, externalParserClassName);
                    } else {
                        this.LOGGER.error("Unkown data in documentText/xPath tag ");
                    }
                } else {
                    this.LOGGER.error("Unknown element in mapping file: " + nodeName);
                }
            }
            event = reader.nextEvent();
        }
    }

    private TypeTemplate parseType(XMLEventReader reader) throws XMLStreamException, CollectionException {
        TypeTemplate type = new TypeTemplate();
        XMLEvent event = reader.nextEvent();
        while (!event.isEndElement() || !event.asEndElement().getName().toString().equals(TS_TYPE)) {
            if (event.isStartElement()) {
                String nodeName = event.asStartElement().getName().toString();
                if (nodeName.equals(TS_FEATURE)) {
                    Attribute inlineAttribute = event.asStartElement().getAttributeByName(new QName(INLINE));
                    boolean parseBoolean = false;
                    if (inlineAttribute != null) {
                        parseBoolean = Boolean.parseBoolean(inlineAttribute.getValue());
                    }
                    Attribute multiAttribute = event.asStartElement().getAttributeByName(new QName(MULTI_INSTANCE));
                    boolean parseBoolean2 = false;
                    if (multiAttribute != null) {
                        parseBoolean2 = Boolean.parseBoolean(multiAttribute.getValue());
                    }
                    FeatureTemplate feature = this.parseFeature(reader);
                    feature.setInlineAnnotation(parseBoolean);
                    feature.setMultipleInstances(parseBoolean2);
                    type.addFeature(feature);
                } else if (nodeName.equals(OFFSET)) {
                    this.parseOffset(type, reader);
                } else if (nodeName.equals(FULL_CLASS_NAME)) {
                    event = reader.nextEvent();
                    type.setFullClassName(event.asCharacters().getData().trim());
                } else if (nodeName.equals(VALUE_X_PATH)) {
                    event = reader.nextEvent();
                    type.addXPath(event.asCharacters().getData().trim());
                } else if (nodeName.equals(EXTERNAL_PARSER)) {
                    event = reader.nextEvent();
                    type.setParser(event.asCharacters().getData().trim());
                } else if (nodeName.equals(ADDITIONAL_DATA)) {
                    Attribute next;
                    int index = -1;
                    Iterator<Attribute> attributes = event.asStartElement().getAttributes();
                    if (attributes.hasNext() && (next = attributes.next()).getName().getLocalPart().equals(ID)) {
                        index = Integer.parseInt(next.getValue());
                    }
                    if (index >= 0) {
                        event = reader.nextEvent();
                        type.addAdditionalData(event.asCharacters().getData().trim(), index);
                    }
                } else {
                    this.LOGGER.warn("unknown tag in mapping file: " + nodeName + "!!");
                }
            }
            event = reader.nextEvent();
        }
        return type;
    }

    private void parseOffset(TypeTemplate type, XMLEventReader reader) throws XMLStreamException {
        XMLEvent event = reader.nextEvent();
        while (!event.isEndElement() || !event.asEndElement().getName().toString().equals(OFFSET)) {
            if (event.isStartElement() && event.isStartElement()) {
                String nodeName = event.asStartElement().getName().toString();
                if (nodeName.equals(PART_OF_DOCUMENT_TEXT)) {
                    while (!event.isEndElement() || !event.asEndElement().getName().toString().equals(PART_OF_DOCUMENT_TEXT)) {
                        event = reader.nextEvent();
                        if (!event.isStartElement() || !event.asStartElement().getName().toString().equals(ID)) continue;
                        event = reader.nextEvent();
                        if (event.isCharacters()) {
                            type.addPartOfDocumentText(Integer.valueOf(event.asCharacters().getData()));
                            continue;
                        }
                        this.LOGGER.error("corrupt offsetdata in mappingfile");
                    }
                } else {
                    this.LOGGER.error("Unknown element in mapping file: " + nodeName);
                }
            }
            event = reader.nextEvent();
        }
    }

    private FeatureTemplate parseFeature(XMLEventReader reader) throws XMLStreamException, CollectionException {
        FeatureTemplate feature = new FeatureTemplate();
        XMLEvent event = reader.nextEvent();
        boolean externalParser = false;
        boolean isType = false;
        while (!event.isEndElement() || !event.asEndElement().getName().toString().equals(TS_FEATURE)) {
            if (event.isStartElement()) {
                String nodeName = event.asStartElement().getName().toString();
                if (nodeName.equals(FULL_CLASS_NAME)) {
                    event = reader.nextEvent();
                    feature.setFullClassName(event.asCharacters().getData().trim());
                } else if (nodeName.equals(VALUE_X_PATH)) {
                    event = reader.nextEvent();
                    feature.addXPath(event.asCharacters().getData().trim());
                } else if (nodeName.equals(TS_FEATURE_NAME)) {
                    event = reader.nextEvent();
                    feature.setTsName(event.asCharacters().getData().trim());
                } else if (nodeName.equals(VALUE_MAPPING)) {
                    event = reader.nextEvent();
                    this.parseValueMapping(reader, feature);
                } else if (nodeName.equals(EXTERNAL_PARSER)) {
                    externalParser = true;
                    event = reader.nextEvent();
                    feature.setParser(event.asCharacters().getData().trim());
                } else if (nodeName.equals(IS_TYPE)) {
                    event = reader.nextEvent();
                    isType = Boolean.parseBoolean(event.asCharacters().getData().trim());
                    feature.setType(isType);
                } else if (nodeName.equals(TS_FEATURE)) {
                    isType = true;
                    feature.setType(isType);
                    FeatureTemplate newFeature = this.parseFeature(reader);
                    feature.addFeature(newFeature);
                } else {
                    this.LOGGER.warn("unknown tag in mapping file: " + nodeName + "!!");
                }
            }
            event = reader.nextEvent();
        }
        if (!externalParser && !isType) {
            feature.setParser(null);
        }
        return feature;
    }

    private void parseValueMapping(XMLEventReader reader, FeatureTemplate feature) throws XMLStreamException {
        XMLEvent event = reader.nextEvent();
        String value = null;
        String xmlElement = null;
        while (!event.isEndElement() || !event.asEndElement().getName().toString().equals(VALUE_MAPPING)) {
            if (event.isStartElement()) {
                String nodeName = event.asStartElement().getName().toString();
                if (nodeName.equals(XML_ELEMENT)) {
                    event = reader.nextEvent();
                    xmlElement = event.asCharacters().getData().trim();
                } else if (nodeName.equals(VALUE)) {
                    event = reader.nextEvent();
                    value = event.asCharacters().getData().trim();
                } else if (nodeName.equals(DEFAULT_VALUE_MAPPING)) {
                    event = reader.nextEvent();
                    xmlElement = "defaultValueMapping";
                    value = event.asCharacters().getData().trim();
                }
            }
            event = reader.nextEvent();
        }
        if (xmlElement != null) {
            if (value == null) {
                value = xmlElement;
            }
            feature.addVauleMapping(xmlElement, value);
        }
    }

    public DocumentTextHandler getDocumentTextParser() {
        return this.documentTextParser;
    }
}

