/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.reader.xmlmapper.mapper;

import com.ximpleware.AutoPilot;
import com.ximpleware.NavException;
import com.ximpleware.VTDException;
import com.ximpleware.VTDNav;
import com.ximpleware.XPathEvalException;
import com.ximpleware.XPathParseException;
import de.julielab.jcore.reader.xmlmapper.mapper.DocumentTextData;
import de.julielab.jcore.reader.xmlmapper.mapper.DocumentTextPartParser;
import de.julielab.jcore.reader.xmlmapper.mapper.MapperUtils;
import de.julielab.jcore.reader.xmlmapper.mapper.PartOfDocument;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.jcas.JCas;
import org.fest.reflect.core.Reflection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentTextHandler {
    Logger LOGGER = LoggerFactory.getLogger(DocumentTextHandler.class);
    private DocumentTextData docTextData = new DocumentTextData();

    public void addPartOfDocumentTextXPath(int id) {
        this.docTextData.put(id, new PartOfDocument(id));
    }

    public DocumentTextData parseAndAddToCas(VTDNav vn, JCas jcas, byte[] identifier) throws VTDException {
        ArrayList<String> textPartList = new ArrayList<String>(this.docTextData.size());
        int offset = 0;
        int i = 0;
        while (i < this.docTextData.size()) {
            PartOfDocument docTextPart = this.docTextData.get(i);
            if (docTextPart == null) {
                this.LOGGER.error("corrupted DocumentText Data in MappingFile! Not all Ids are set.");
            } else {
                List<String> textPartStrs = docTextPart.getParser() == null ? this.getTextPart(vn, docTextPart, identifier) : docTextPart.getParser().parseDocumentPart(vn, docTextPart, textPartList.isEmpty() ? offset : offset + 1, jcas, identifier);
                docTextPart.setText(textPartStrs.toArray(new String[textPartStrs.size()]));
                int[] beginOffsets = new int[textPartStrs.size()];
                int[] endOffsets = new int[textPartStrs.size()];
                int j = 0;
                while (j < textPartStrs.size()) {
                    String textPartStr = textPartStrs.get(j);
                    if (textPartStr.length() > 0) {
                        if (!textPartList.isEmpty()) {
                            // empty if block
                        }
                        textPartList.add(textPartStr);
                        beginOffsets[j] = ++offset;
                        endOffsets[j] = offset += textPartStr.length();
                    }
                    ++j;
                }
                if (textPartStrs.isEmpty()) {
                    endOffsets = new int[]{offset};
                    beginOffsets = endOffsets;
                }
                docTextPart.setBeginOffsets(beginOffsets);
                docTextPart.setEndOffsets(endOffsets);
            }
            ++i;
        }
        String docTextStr = StringUtils.join(textPartList, (String)"\n");
        this.docTextData.setText(docTextStr);
        jcas.setDocumentText(docTextStr);
        return this.docTextData;
    }

    private List<String> getTextPart(VTDNav vn, PartOfDocument part, byte[] identifier) throws XPathParseException, XPathEvalException, NavException {
        ArrayList<String> textParts = new ArrayList<String>();
        vn.cloneNav();
        AutoPilot ap = new AutoPilot(vn);
        if (StringUtils.isBlank((String)part.getXPath())) {
            throw new IllegalStateException("Document text part with ID " + part.getId() + " has no XPath specified.");
        }
        ap.selectXPath(part.getXPath());
        int i = ap.evalXPath();
        while (i != -1) {
            String textPart = MapperUtils.getElementText(vn).trim();
            textParts.add(textPart);
            i = ap.evalXPath();
        }
        return textParts;
    }

    public void setXPathForPartOfDocumentText(int id, String xpath) {
        this.docTextData.get(id).setxPath(xpath);
    }

    public void setExternalParserForPartOfDocument(int id, String externalParserClassName) throws CollectionException {
        if (externalParserClassName != null) {
            Class<?> externalParserClass;
            try {
                externalParserClass = Class.forName(externalParserClassName.trim());
            }
            catch (ClassNotFoundException e) {
                this.LOGGER.error("ExternalParser " + externalParserClassName + " for document text part " + id + " returns a ClassNotFoundException", (Throwable)e);
                throw new CollectionException((Throwable)e);
            }
            DocumentTextPartParser parser = (DocumentTextPartParser)Reflection.constructor().in(externalParserClass).newInstance(new Object[0]);
            this.docTextData.get(id).setParser(parser);
        }
    }
}

