/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.reader.xmlmapper.mapper;

import com.ximpleware.EOFException;
import com.ximpleware.EncodingException;
import com.ximpleware.EntityException;
import com.ximpleware.ParseException;
import com.ximpleware.VTDGen;
import com.ximpleware.VTDNav;
import de.julielab.jcore.reader.xmlmapper.genericTypes.ConcreteType;
import de.julielab.jcore.reader.xmlmapper.genericTypes.TypeFactory;
import de.julielab.jcore.reader.xmlmapper.genericTypes.TypeTemplate;
import de.julielab.jcore.reader.xmlmapper.mapper.DocumentTextData;
import de.julielab.jcore.reader.xmlmapper.mapper.DocumentTextHandler;
import de.julielab.jcore.reader.xmlmapper.typeBuilder.TypeBuilder;
import de.julielab.jcore.reader.xmlmapper.typeParser.NoDocumentTextCoveredException;
import de.julielab.xml.JulieXMLTools;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.jcas.JCas;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLMapper {
    private static final Logger LOG = LoggerFactory.getLogger(XMLMapper.class);
    private List<TypeTemplate> genericTemplates;
    private DocumentTextHandler documentTextHandler;

    public XMLMapper(byte[] mappingFileData) {
        this.readMappingFile(mappingFileData);
    }

    public XMLMapper(InputStream mappingFileDateStream) throws IOException {
        this.readMappingFile(JulieXMLTools.readStream((InputStream)mappingFileDateStream, (int)1000));
    }

    private void readMappingFile(byte[] mappingFileData) {
        assert (mappingFileData != null);
        TypeFactory tf = new TypeFactory(mappingFileData);
        try {
            this.genericTemplates = tf.createTemplates();
            this.documentTextHandler = tf.getDocumentTextParser();
        }
        catch (CollectionException e) {
            e.printStackTrace();
        }
    }

    public void parse(byte[] data, byte[] identifier, JCas jcas) {
        try {
            VTDGen vg = new VTDGen();
            vg.enableIgnoredWhiteSpace(true);
            vg.setDoc(data);
            vg.parse(true);
            VTDNav vn = vg.getNav();
            this.buildTypes(identifier, jcas, vn);
        }
        catch (EncodingException e) {
            e.printStackTrace();
        }
        catch (EOFException e) {
            e.printStackTrace();
        }
        catch (EntityException e) {
            LOG.error(String.format("Document %s could not be parsed due to an EntityError. Document text is:\n%s", new String(identifier), new String(data)), (Throwable)e);
        }
        catch (CollectionException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            LOG.error(String.format("Document %s could not be parsed due to a general parsing error. Document text is:\n%s", new String(identifier), new String(data)), (Throwable)e);
        }
    }

    public void parse(File file, JCas jcas) throws Throwable {
        FileInputStream is = new FileInputStream(file);
        byte[] b = JulieXMLTools.readStream((InputStream)is, (int)1000);
        this.parse(b, file.getAbsolutePath().getBytes(), jcas);
    }

    private void buildTypes(byte[] identifier, JCas jcas, VTDNav vn) throws CollectionException {
        try {
            DocumentTextData docText = this.documentTextHandler.parseAndAddToCas(vn, jcas, identifier);
            for (TypeTemplate typeTemplate : this.genericTemplates) {
                ConcreteType concreteType = new ConcreteType(typeTemplate);
                try {
                    concreteType.getTypeTemplate().getParser().parseType(concreteType, vn, jcas, identifier, docText);
                }
                catch (NoDocumentTextCoveredException e) {
                    continue;
                }
                TypeBuilder builder = typeTemplate.getParser().getTypeBuilder();
                if (builder == null) {
                    throw new RuntimeException("Your TypeParser is not associated with a TypeBuilder. To fix this, return a TypeBuilder in the implementation of the method getTypeBuilder of your TypeParser.");
                }
                builder.buildType(concreteType, jcas);
            }
        }
        catch (Exception e) {
            LOG.error("", (Throwable)e);
        }
    }
}

