/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.reader.xmlmapper.typeParser;

import com.ximpleware.AutoPilot;
import com.ximpleware.VTDNav;
import de.julielab.jcore.reader.xmlmapper.genericTypes.ConcreteFeature;
import de.julielab.jcore.reader.xmlmapper.genericTypes.ConcreteType;
import de.julielab.jcore.reader.xmlmapper.genericTypes.FeatureTemplate;
import de.julielab.jcore.reader.xmlmapper.mapper.DocumentTextData;
import de.julielab.jcore.reader.xmlmapper.typeBuilder.StandardTypeBuilder;
import de.julielab.jcore.reader.xmlmapper.typeBuilder.TypeBuilder;
import de.julielab.jcore.reader.xmlmapper.typeParser.TypeParser;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.uima.jcas.JCas;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PubDateParser
implements TypeParser {
    static Pattern p = Pattern.compile("<[^>]+>");
    Logger LOGGER = LoggerFactory.getLogger(PubDateParser.class);
    public static final String ELEMENT_MEDLINE_DATE = "MedlineDate";
    public static final String ELEMENT_DAY = "Day";
    public static final String ELEMENT_MONTH = "Month";
    public static final String ELEMENT_YEAR = "Year";
    static final String[] MONTHS = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    public static final String PATTERN_YEAR = "\\d\\d\\d\\d";
    public static final String PATTERN_MONTH_CONTEXT = "[- ][a-zA-Z][a-zA-Z][a-zA-Z][- ]";
    public static final String PATTERN_MONTH = "[a-zA-Z][a-zA-Z][a-zA-Z]";
    public static final String PATTERN_DAY = "^\\d\\d\\d^\\d";

    @Override
    public void parseType(ConcreteType concreteType, VTDNav nav, JCas jcas, byte[] identifier, DocumentTextData docText) throws Exception {
        Date date = new Date();
        VTDNav vn = nav.cloneNav();
        for (String xPath : concreteType.getTypeTemplate().getXPaths()) {
            AutoPilot ap = new AutoPilot(vn);
            ap.selectXPath(xPath);
            while (ap.evalXPath() != -1) {
                if (vn.toElement(2, "*")) {
                    do {
                        String pubDateContent;
                        int vtIndex = vn.getCurrentIndex();
                        int val = vn.getText();
                        if (val == -1 || (pubDateContent = vn.toString(val)).equals("")) continue;
                        if (vn.compareTokenString(vtIndex, ELEMENT_DAY) == 0) {
                            date.day = pubDateContent;
                        }
                        if (vn.compareTokenString(vtIndex, ELEMENT_MONTH) == 0) {
                            date.month = this.parseMonthFormString(pubDateContent);
                        }
                        if (vn.compareTokenString(vtIndex, ELEMENT_YEAR) == 0) {
                            date.year = pubDateContent;
                        }
                        if (vn.compareTokenString(vtIndex, ELEMENT_MEDLINE_DATE) != 0) continue;
                        date = this.putMedlineDate(pubDateContent);
                        break;
                    } while (vn.toElement(4));
                }
                this.LOGGER.trace("date=" + date);
                for (FeatureTemplate featureTemplate : concreteType.getTypeTemplate().getFeatures()) {
                    ConcreteFeature concreteFeature = new ConcreteFeature(featureTemplate);
                    if (featureTemplate.getTsName().toLowerCase().equals("day")) {
                        this.LOGGER.trace("setting day=" + date.day);
                        concreteFeature.setValue(date.day);
                    } else if (featureTemplate.getTsName().toLowerCase().equals("month")) {
                        this.LOGGER.trace("setting month=" + date.month);
                        concreteFeature.setValue(date.month);
                    } else if (featureTemplate.getTsName().toLowerCase().equals("year")) {
                        this.LOGGER.trace("setting year=" + date.year);
                        concreteFeature.setValue(date.year);
                    }
                    concreteType.addFeature(concreteFeature);
                }
            }
        }
    }

    private String parseMonthFormString(String abbreviation) {
        int i = 0;
        while (i < MONTHS.length) {
            if (MONTHS[i].equals(abbreviation)) {
                return String.valueOf(i + 1);
            }
            ++i;
        }
        return "0";
    }

    private Date putMedlineDate(String content) {
        Date date = new Date();
        ArrayList<Integer> years = new ArrayList<Integer>();
        ArrayList<String> days = new ArrayList<String>();
        ArrayList<String> months = new ArrayList<String>();
        Pattern yearPattern = Pattern.compile(PATTERN_YEAR);
        Pattern monthContextPattern = Pattern.compile(PATTERN_MONTH_CONTEXT);
        Pattern dayPattern = Pattern.compile(PATTERN_DAY);
        Matcher yearMatcher = yearPattern.matcher(content);
        Matcher dayMatcher = dayPattern.matcher(content);
        int maxYear = 0;
        while (yearMatcher.find()) {
            years.add(Integer.parseInt(yearMatcher.group()));
            maxYear = this.getMax(years);
        }
        if (maxYear > 0) {
            date.year = String.valueOf(maxYear);
        }
        if (years.size() == 2 && this.hasExactlyOneMinus(content)) {
            monthContextPattern = this.getMonthContextPattern(content, monthContextPattern, maxYear);
        }
        Matcher monthMatcher = monthContextPattern.matcher(content);
        while (monthMatcher.find()) {
            Pattern monthPattern = Pattern.compile(PATTERN_MONTH);
            Matcher monMatcher = monthPattern.matcher(monthMatcher.group());
            if (!monMatcher.find()) continue;
            months.add(monMatcher.group());
        }
        if (months.size() == 1) {
            date.month = this.parseMonthFormString((String)months.get(0));
        }
        while (dayMatcher.find()) {
            days.add(dayMatcher.group());
        }
        if (days.size() == 1) {
            date.day = (String)days.get(0);
        }
        return date;
    }

    private Pattern getMonthContextPattern(String content, Pattern monthContextPattern, int maxYear) {
        Matcher leftYearMatcher = Pattern.compile("\\d\\d\\d\\d.*-").matcher(content);
        if (leftYearMatcher.find()) {
            String leftYearContext = leftYearMatcher.group();
            Matcher matcher = Pattern.compile(PATTERN_YEAR).matcher(leftYearContext);
            if (matcher.find()) {
                String leftYearStr = matcher.group();
                int leftYear = Integer.parseInt(leftYearStr);
                monthContextPattern = leftYear == maxYear ? Pattern.compile("[a-zA-Z][a-zA-Z][a-zA-Z].*-") : Pattern.compile("-.*[a-zA-Z][a-zA-Z][a-zA-Z]");
            }
        }
        return monthContextPattern;
    }

    private boolean hasExactlyOneMinus(String content) {
        Matcher minusMatcher = Pattern.compile("-").matcher(content);
        int countMinus = 0;
        while (minusMatcher.find()) {
            ++countMinus;
        }
        return countMinus == 1;
    }

    private int getMax(ArrayList<Integer> values) {
        int max = Integer.MIN_VALUE;
        int i = 0;
        while (i < values.size()) {
            if (values.get(i) > max) {
                max = values.get(i);
            }
            ++i;
        }
        return max;
    }

    @Override
    public TypeBuilder getTypeBuilder() {
        return new StandardTypeBuilder();
    }

    private class Date {
        String day = null;
        String month = null;
        String year = null;

        private Date() {
        }

        public String toString() {
            return "[Date] year=" + this.year + ", month=" + this.month + ", day=" + this.day;
        }
    }
}

