/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.reader.xmlmapper.typeParser;

import com.ximpleware.AutoPilot;
import com.ximpleware.NavException;
import com.ximpleware.VTDNav;
import com.ximpleware.XPathEvalException;
import com.ximpleware.XPathParseException;
import de.julielab.jcore.reader.xmlmapper.genericTypes.ConcreteFeature;
import de.julielab.jcore.reader.xmlmapper.genericTypes.ConcreteType;
import de.julielab.jcore.reader.xmlmapper.genericTypes.FeatureTemplate;
import de.julielab.jcore.reader.xmlmapper.mapper.DocumentTextData;
import de.julielab.jcore.reader.xmlmapper.mapper.MapperUtils;
import de.julielab.jcore.reader.xmlmapper.typeBuilder.StandardTypeBuilder;
import de.julielab.jcore.reader.xmlmapper.typeBuilder.TypeBuilder;
import de.julielab.jcore.reader.xmlmapper.typeParser.NoDocumentTextCoveredException;
import de.julielab.jcore.reader.xmlmapper.typeParser.TypeParser;
import de.julielab.xml.JulieXMLTools;
import org.apache.uima.jcas.JCas;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardTypeParser
implements TypeParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(StandardTypeParser.class);

    @Override
    public void parseType(ConcreteType concreteType, VTDNav nav, JCas jcas, byte[] identifier, DocumentTextData docText) throws Exception {
        VTDNav vn = nav.cloneNav();
        boolean inline = concreteType.getTypeTemplate().isInlineAnnotation();
        if (concreteType.getTypeTemplate().isMultipleInstances() || inline) {
            if (concreteType.getTypeTemplate().getXPaths().size() > 0) {
                int inlinePosition = 0;
                String text = docText.getText();
                for (String xPath : concreteType.getTypeTemplate().getXPaths()) {
                    AutoPilot ap = new AutoPilot(vn);
                    ap.selectXPath(xPath);
                    while (ap.evalXPath() != -1) {
                        int begin = 0;
                        int end = 0;
                        if (inline) {
                            String inlineText = JulieXMLTools.getElementText((VTDNav)vn);
                            begin = text.indexOf(inlineText, inlinePosition);
                            end = begin + inlineText.length();
                            if (begin == -1) {
                                throw new IllegalStateException("Inline annotation text \"" + inlineText + "\" was not found in the document text after position " + inlinePosition + ".\nDocument identifier is: " + new String(identifier) + ".\nDocument text is: \"" + text + "\"");
                            }
                        }
                        if (begin < 0) continue;
                        ConcreteFeature realType = new ConcreteFeature(concreteType.getTypeTemplate());
                        realType.getTypeTemplate().setMultipleInstances(false);
                        realType.getTypeTemplate().setInlineAnnotation(false);
                        realType.setBegin(begin);
                        realType.setEnd(end);
                        this.parseSingleType(realType, vn, jcas, identifier, docText);
                        concreteType.addFeature(realType);
                        inlinePosition = end;
                    }
                }
            } else {
                LOGGER.warn("type is marked as Multiple Instance withoutxPath. parsing only one Instance insted");
                concreteType.getTypeTemplate().setMultipleInstances(false);
                this.parseSingleType(concreteType, vn, jcas, identifier, docText);
            }
        } else {
            this.parseSingleType(concreteType, vn, jcas, identifier, docText);
        }
    }

    protected void parseSingleType(ConcreteType concreteType, VTDNav nav, JCas jcas, byte[] identifier, DocumentTextData docText) throws Exception, XPathParseException, XPathEvalException, NavException {
        VTDNav vn = nav.cloneNav();
        for (FeatureTemplate featureTemplate : concreteType.getTypeTemplate().getFeatures()) {
            ConcreteFeature concreteFeature = new ConcreteFeature(featureTemplate);
            if (featureTemplate.isType()) {
                featureTemplate.getParser().parseType(concreteFeature, vn, jcas, identifier, docText);
                if (concreteFeature.getConcreteFeatures() == null) continue;
                concreteType.addFeature(concreteFeature);
                continue;
            }
            if (featureTemplate.getParser() != null) {
                featureTemplate.getParser().parseType(concreteFeature, vn, jcas, identifier, docText);
                concreteType.addFeature(concreteFeature);
                continue;
            }
            if (featureTemplate.getValueMap() != null && featureTemplate.getValueMap().size() == 1) {
                this.directValueFromDefaultMapping(concreteType, featureTemplate, concreteFeature);
                continue;
            }
            StandardTypeParser.parseStandardFeature(concreteType, vn, featureTemplate, concreteFeature);
        }
        int[] ids = concreteType.getTypeTemplate().getOffsetPartIDs();
        if (ids != null) {
            int begin = docText.get(ids[0]).getBegin();
            int end = docText.get(ids[1]).getEnd();
            if (end - begin <= 0) {
                throw new NoDocumentTextCoveredException();
            }
            concreteType.setBegin(begin);
            concreteType.setEnd(end);
        }
    }

    public static void parseStandardFeature(ConcreteType concreteType, VTDNav nav, FeatureTemplate featureTemplate, ConcreteFeature concreteFeature) throws XPathParseException, XPathEvalException, NavException {
        VTDNav vn = nav.cloneNav();
        for (String xpath : featureTemplate.getXPaths()) {
            AutoPilot ap = new AutoPilot(vn);
            ap.selectXPath(xpath);
            int i = ap.evalXPath();
            while (i != -1) {
                String value = vn.getTokenType(i) == 2 ? vn.toString(i + 1) : MapperUtils.getElementText(vn);
                String mappedValue = featureTemplate.getMappedValue(value);
                concreteFeature.setValue(mappedValue);
                concreteType.addFeature(concreteFeature);
                concreteFeature = new ConcreteFeature(featureTemplate);
                i = ap.evalXPath();
            }
        }
    }

    private void directValueFromDefaultMapping(ConcreteType concreteType, FeatureTemplate featureTemplate, ConcreteFeature concreteFeature) {
        concreteFeature.setValue(featureTemplate.getMappedValue(""));
        concreteType.addFeature(concreteFeature);
    }

    public boolean equals(Object obj) {
        return this.getClass().getCanonicalName().equals(obj.getClass().getCanonicalName());
    }

    @Override
    public TypeBuilder getTypeBuilder() {
        return new StandardTypeBuilder();
    }
}

