/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.reader.xmlmapper.genericTypes;

import de.julielab.jcore.reader.xmlmapper.genericTypes.FeatureTemplate;
import de.julielab.jcore.reader.xmlmapper.typeParser.FSArrayParser;
import de.julielab.jcore.reader.xmlmapper.typeParser.StandardTypeParser;
import de.julielab.jcore.reader.xmlmapper.typeParser.StringArrayParser;
import de.julielab.jcore.reader.xmlmapper.typeParser.TypeParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.uima.collection.CollectionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeTemplate {
    private static final Logger LOGGER = LoggerFactory.getLogger(TypeTemplate.class);
    protected String fullClassName;
    protected List<FeatureTemplate> features = new ArrayList<FeatureTemplate>();
    protected TypeParser parser = new StandardTypeParser();
    protected List<String> xPaths = new ArrayList<String>();
    protected boolean externalParser = false;
    protected Map<Integer, String> additionalData;
    protected List<Integer> partOfDocuments = new ArrayList<Integer>();
    protected boolean multipleInstances;
    protected boolean inlineAnnotation;

    public void addFeature(FeatureTemplate feature) {
        this.features.add(feature);
    }

    public List<FeatureTemplate> getFeatures() {
        return this.features;
    }

    public void setFeatures(List<FeatureTemplate> features) {
        this.features = features;
    }

    public TypeTemplate() {
        this.additionalData = new HashMap<Integer, String>();
    }

    public String toString() {
        String out = "[TypeTemplate] " + this.fullClassName + "\n";
        for (TypeTemplate typeTemplate : this.features) {
            out = out + typeTemplate.toString() + "\n";
        }
        return out;
    }

    public String getFullClassName() {
        return this.fullClassName;
    }

    public void setFullClassName(String fullClassName) {
        if (fullClassName.equals("org.apache.uima.jcas.cas.FSArray") && !this.externalParser) {
            this.parser = new FSArrayParser();
        } else if (fullClassName.equals("org.apache.uima.jcas.cas.StringArray") && !this.externalParser) {
            this.parser = new StringArrayParser();
        }
        this.fullClassName = fullClassName;
    }

    public void setParser(String trim) throws CollectionException {
        if (trim != null) {
            this.externalParser = true;
            Class<?> externalParserClass = null;
            try {
                externalParserClass = Class.forName(trim);
                this.parser = (TypeParser)externalParserClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException e) {
                LOGGER.error("ExternalParser " + trim + " for type or feature " + this.fullClassName + " returns a ClassNotFoundException", (Throwable)e);
                throw new CollectionException((Throwable)e);
            }
            catch (Exception e) {
                LOGGER.error("Could not create instance of class {}: ", externalParserClass, (Object)e);
                throw new CollectionException((Throwable)e);
            }
        } else {
            this.parser = null;
        }
    }

    public TypeParser getParser() {
        return this.parser;
    }

    public List<String> getXPaths() {
        return this.xPaths;
    }

    public void addAdditionalData(String value, int index) {
        if (this.additionalData == null) {
            this.additionalData = new TreeMap<Integer, String>();
        }
        this.additionalData.put(index, value);
    }

    public String[] getAdditionalData() {
        if (this.additionalData != null) {
            return this.additionalData.values().toArray(new String[this.additionalData.size()]);
        }
        return new String[0];
    }

    public void addPartOfDocumentText(int partOfDocumentId) {
        this.partOfDocuments.add(partOfDocumentId);
        Collections.sort(this.partOfDocuments);
    }

    public int[] getOffsetPartIDs() {
        if (this.partOfDocuments != null && this.partOfDocuments.size() > 0) {
            return new int[]{this.partOfDocuments.get(0), this.partOfDocuments.get(this.partOfDocuments.size() - 1)};
        }
        return null;
    }

    public void addXPath(String xpath) {
        this.xPaths.add(xpath);
    }

    protected TypeTemplate clone() {
        TypeTemplate typeTemplate = new TypeTemplate();
        typeTemplate.fullClassName = new String(this.fullClassName);
        typeTemplate.features = new ArrayList<FeatureTemplate>();
        for (FeatureTemplate feature : this.features) {
            typeTemplate.features.add(feature.clone());
        }
        typeTemplate.parser = this.parser;
        typeTemplate.xPaths = new ArrayList<String>();
        for (String path : this.xPaths) {
            typeTemplate.addXPath(new String(path));
        }
        typeTemplate.externalParser = this.externalParser;
        typeTemplate.additionalData = new HashMap<Integer, String>();
        for (Integer id : this.additionalData.keySet()) {
            typeTemplate.additionalData.put(id, this.additionalData.get(id));
        }
        typeTemplate.partOfDocuments = new ArrayList<Integer>();
        for (Integer id : this.partOfDocuments) {
            typeTemplate.partOfDocuments.add(id);
        }
        typeTemplate.multipleInstances = this.multipleInstances;
        typeTemplate.inlineAnnotation = this.inlineAnnotation;
        return typeTemplate;
    }

    public boolean isMultipleInstances() {
        return this.multipleInstances;
    }

    public boolean isInlineAnnotation() {
        return this.inlineAnnotation;
    }

    public void setMultipleInstances(boolean b) {
        this.multipleInstances = b;
    }

    public void setInlineAnnotation(boolean inlineAnnotation) {
        this.inlineAnnotation = inlineAnnotation;
    }
}

