/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.reader.xmlmapper.mapper;

import com.ximpleware.AutoPilot;
import com.ximpleware.NavException;
import com.ximpleware.VTDException;
import com.ximpleware.VTDNav;
import com.ximpleware.XPathEvalException;
import com.ximpleware.XPathParseException;
import de.julielab.jcore.reader.xmlmapper.mapper.DocumentTextData;
import de.julielab.jcore.reader.xmlmapper.mapper.DocumentTextPartParser;
import de.julielab.jcore.reader.xmlmapper.mapper.MapperUtils;
import de.julielab.jcore.reader.xmlmapper.mapper.PartOfDocument;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.jcas.JCas;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentTextHandler {
    private static Map<String, Integer> numNoDocTextFound = new ConcurrentHashMap<String, Integer>();
    Logger LOGGER = LoggerFactory.getLogger(DocumentTextHandler.class);
    private DocumentTextData docTextData = new DocumentTextData();

    public void addPartOfDocumentTextXPath(int id) {
        this.docTextData.put(id, new PartOfDocument(id));
    }

    public DocumentTextData parseAndAddToCas(VTDNav vn, JCas jcas, byte[] identifier) throws VTDException {
        ArrayList<String> textPartList = new ArrayList<String>(this.docTextData.size());
        int offset = 0;
        for (int i = 0; i < this.docTextData.size(); ++i) {
            PartOfDocument docTextPart = this.docTextData.get(i);
            if (docTextPart == null) {
                this.LOGGER.error("corrupted DocumentText Data in MappingFile! Not all Ids are set.");
                continue;
            }
            List<String> textPartStrs = docTextPart.getParser() == null ? this.getTextPart(vn, docTextPart, identifier) : docTextPart.getParser().parseDocumentPart(vn, docTextPart, textPartList.isEmpty() ? offset : offset + 1, jcas, identifier);
            docTextPart.setText(textPartStrs.toArray(new String[textPartStrs.size()]));
            int[] beginOffsets = new int[textPartStrs.size()];
            int[] endOffsets = new int[textPartStrs.size()];
            for (int j = 0; j < textPartStrs.size(); ++j) {
                String textPartStr = textPartStrs.get(j);
                if (textPartStr.length() <= 0) continue;
                if (!textPartList.isEmpty()) {
                    // empty if block
                }
                textPartList.add(textPartStr);
                beginOffsets[j] = ++offset;
                endOffsets[j] = offset += textPartStr.length();
            }
            if (textPartStrs.isEmpty()) {
                endOffsets = new int[]{offset};
                beginOffsets = endOffsets;
            }
            docTextPart.setBeginOffsets(beginOffsets);
            docTextPart.setEndOffsets(endOffsets);
        }
        String docTextStr = StringUtils.join(textPartList, (String)"\n");
        this.docTextData.setText(docTextStr);
        jcas.setDocumentText(docTextStr);
        return this.docTextData;
    }

    private List<String> getTextPart(VTDNav vn, PartOfDocument part, byte[] identifier) throws XPathParseException, XPathEvalException, NavException {
        ArrayList<String> textParts = new ArrayList<String>();
        vn.cloneNav();
        AutoPilot ap = new AutoPilot(vn);
        if (StringUtils.isBlank((String)part.getXPath())) {
            throw new IllegalStateException("Document text part with ID " + part.getId() + " has no XPath specified.");
        }
        ap.selectXPath(part.getXPath());
        int i = ap.evalXPath();
        if (i < 0 && numNoDocTextFound.compute(part.getXPath(), (k, v) -> v != null ? v + 1 : 1) < 10) {
            this.LOGGER.debug("no match for xPath " + part.getXPath() + " in document with identifier " + new String(identifier));
        } else if (numNoDocTextFound.getOrDefault(part.getXPath(), 0) == 10) {
            this.LOGGER.warn("No match for xPath " + part.getXPath() + " in document with identifier " + new String(identifier) + ". This has happened 10 times already (logged on debug level). This message is only displayed once to avoid scrolling.");
        }
        while (i != -1) {
            String textPart = MapperUtils.getElementText(vn).trim();
            textParts.add(textPart);
            i = ap.evalXPath();
        }
        return textParts;
    }

    public void setXPathForPartOfDocumentText(int id, String xpath) {
        this.docTextData.get(id).setxPath(xpath);
    }

    public void setExternalParserForPartOfDocument(int id, String externalParserClassName) throws CollectionException {
        if (externalParserClassName != null) {
            DocumentTextPartParser parser;
            Class<?> externalParserClass = null;
            try {
                externalParserClass = Class.forName(externalParserClassName.trim());
                parser = (DocumentTextPartParser)externalParserClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException e) {
                this.LOGGER.error("ExternalParser " + externalParserClassName + " for document text part " + id + " returns a ClassNotFoundException", (Throwable)e);
                throw new CollectionException((Throwable)e);
            }
            catch (Exception e) {
                this.LOGGER.error("Could not create instance of {}: ", externalParserClass, (Object)e);
                throw new CollectionException((Throwable)e);
            }
            this.docTextData.get(id).setParser(parser);
        }
    }
}

