/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.reader.xmlmapper.typeBuilder;

import de.julielab.jcore.reader.xmlmapper.genericTypes.ConcreteFeature;
import de.julielab.jcore.reader.xmlmapper.genericTypes.ConcreteType;
import de.julielab.jcore.reader.xmlmapper.typeBuilder.TypeBuilder;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.jcas.tcas.Annotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardTypeBuilder
implements TypeBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(StandardTypeBuilder.class);
    private HashMap<String, Class<?>> standardJavaTypesMap;

    public StandardTypeBuilder() {
        this.initStandardTypes();
    }

    private void initStandardTypes() {
        this.standardJavaTypesMap = new HashMap();
        this.standardJavaTypesMap.put("char", Character.TYPE);
        this.standardJavaTypesMap.put("int", Integer.TYPE);
        this.standardJavaTypesMap.put("boolean", Boolean.TYPE);
        this.standardJavaTypesMap.put("float", Float.TYPE);
        this.standardJavaTypesMap.put("long", Long.TYPE);
        this.standardJavaTypesMap.put("double", Double.TYPE);
        this.standardJavaTypesMap.put("byte", Byte.TYPE);
    }

    public Annotation buildType(ConcreteType concreteType, JCas jcas) throws CollectionException {
        if (concreteType.getTypeTemplate().isMultipleInstances() || concreteType.getTypeTemplate().isInlineAnnotation()) {
            for (ConcreteFeature concreteFeature : concreteType.getConcreteFeatures()) {
                this.buildType(concreteFeature, jcas);
            }
            return null;
        }
        return this.buildSingleInstance(concreteType, jcas);
    }

    private Annotation buildSingleInstance(ConcreteType concreteType, JCas jcas) throws CollectionException {
        if (concreteType.getFullClassName() == null) {
            concreteType.getTypeTemplate().getParser().getTypeBuilder().buildType(concreteType, jcas);
            return null;
        }
        Class<?> typeClass = null;
        Annotation type = null;
        try {
            typeClass = Class.forName(concreteType.getFullClassName());
        }
        catch (ClassNotFoundException e) {
            throw new CollectionException((Throwable)e);
        }
        if (concreteType.getConcreteFeatures() != null) {
            try {
                type = (Annotation)typeClass.getConstructor(JCas.class).newInstance(jcas);
            }
            catch (Exception e) {
                throw new CollectionException((Throwable)e);
            }
            for (ConcreteFeature concreteFeature : concreteType.getConcreteFeatures()) {
                if ((concreteFeature.getValue() == null || concreteFeature.getValue().equals("")) && !concreteFeature.isType()) continue;
                try {
                    Class<?> featureClass;
                    String methodName = "set" + concreteFeature.getTsName().substring(0, 1).toUpperCase() + concreteFeature.getTsName().substring(1);
                    if (this.standardJavaTypesMap.get(concreteFeature.getFullClassName()) != null) {
                        featureClass = this.standardJavaTypesMap.get(concreteFeature.getFullClassName());
                        type.getClass().getMethod(methodName, featureClass).invoke((Object)type, this.parseValueStringToValueType(concreteFeature.getValue(), concreteFeature.getFullClassName()));
                        continue;
                    }
                    if (concreteFeature.getFullClassName().equals("String") || concreteFeature.getFullClassName().equals("java.lang.String")) {
                        featureClass = Class.forName(concreteFeature.getFullClassName());
                        typeClass.getMethod(methodName, featureClass).invoke((Object)type, concreteFeature.getValue());
                        continue;
                    }
                    String featureClassName = concreteFeature.getFullClassName();
                    if (StringUtils.isBlank((CharSequence)featureClassName)) {
                        throw new IllegalStateException("For the feature \"" + concreteFeature.getTsName() + "\" of the type \"" + concreteType.getFullClassName() + "\" the feature value class (e.g. String, Integer, another type...) was not defined in the mapping file.");
                    }
                    featureClass = Class.forName(featureClassName);
                    TOP top = concreteFeature.getTypeTemplate().getParser().getTypeBuilder().buildType(concreteFeature, jcas);
                    type.getClass().getMethod(methodName, featureClass).invoke((Object)type, top);
                }
                catch (Throwable e) {
                    LOGGER.error("Wrong Feature Type: " + concreteFeature.getFullClassName(), e);
                    throw new CollectionException("org.apache.uima.UIMAException_Messages", null);
                }
            }
            type.setBegin(concreteType.getBegin());
            type.setEnd(concreteType.getEnd());
            type.addToIndexes();
        } else {
            LOGGER.warn("Type " + concreteType.getFullClassName() + " does not define any features and is omitted.");
        }
        return type;
    }

    private Object parseValueStringToValueType(String value, String type) {
        if (type.equals("boolean")) {
            return Boolean.parseBoolean(value);
        }
        if (type.equals("int")) {
            return Integer.parseInt(value);
        }
        if (type.equals("long")) {
            return Long.parseLong(value);
        }
        if (type.equals("float")) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (type.equals("double")) {
            return Double.parseDouble(value);
        }
        if (type.equals("byte")) {
            return Byte.parseByte(value);
        }
        if (type.equals("char")) {
            return Character.valueOf(value.charAt(0));
        }
        return null;
    }
}

