/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.reader.xmlmapper.typeParser;

import com.ximpleware.AutoPilot;
import com.ximpleware.VTDNav;
import de.julielab.jcore.reader.xmlmapper.genericTypes.ConcreteType;
import de.julielab.jcore.reader.xmlmapper.mapper.DocumentTextData;
import de.julielab.jcore.reader.xmlmapper.typeBuilder.MedlineTextSentenceBuilder;
import de.julielab.jcore.reader.xmlmapper.typeBuilder.TypeBuilder;
import de.julielab.jcore.reader.xmlmapper.typeParser.TypeParser;
import de.julielab.jcore.types.EntityMention;
import de.julielab.xml.JulieXMLTools;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.uima.jcas.JCas;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityParser
implements TypeParser {
    private Logger LOGGER = LoggerFactory.getLogger(EntityParser.class);

    @Override
    public TypeBuilder getTypeBuilder() {
        return new MedlineTextSentenceBuilder();
    }

    @Override
    public void parseType(ConcreteType concreteType, VTDNav nav, JCas jcas, byte[] identifier, DocumentTextData docText) throws Exception {
        try {
            String text = docText.getText();
            int kontextPosition = 0;
            int entityPosition = 0;
            int lastPostTextPosition = -1;
            int lastEntityStartIndex = -1;
            for (String xPath : concreteType.getTypeTemplate().getXPaths()) {
                ArrayList fields = new ArrayList();
                HashMap<String, String> field = new HashMap<String, String>();
                field.put("name", "entity");
                field.put("xpath", ".");
                fields.add(field);
                field = new HashMap();
                field.put("name", "entityId");
                field.put("xpath", "@id");
                fields.add(field);
                field = new HashMap();
                field.put("name", "words");
                field.put("forEach", "w");
                field.put("xpath", ".");
                field.put("returnValuesAsArray", "true");
                fields.add(field);
                field = new HashMap();
                field.put("name", "wordIds");
                field.put("forEach", "w");
                field.put("xpath", "@id");
                field.put("returnValuesAsArray", "true");
                fields.add(field);
                Iterator entityIt = JulieXMLTools.constructRowIterator((VTDNav)nav.cloneNav(), (String)xPath, fields, (String)new String(identifier));
                nav = nav.cloneNav();
                AutoPilot pilot = new AutoPilot(nav);
                pilot.selectXPath(xPath);
                while (entityIt.hasNext()) {
                    Map entityRow = (Map)entityIt.next();
                    String entityText = (String)entityRow.get("entity");
                    String[] words = (String[])entityRow.get("words");
                    String[] wordIds = (String[])entityRow.get("wordIds");
                    String entityIdStr = (String)entityRow.get("entityId");
                    pilot.evalXPath();
                    String preText = "";
                    int preIndex = nav.getCurrentIndex() - 1;
                    if (preIndex < 0) {
                        preIndex = 0;
                    }
                    if (nav.getTokenType(preIndex) == 5) {
                        preText = nav.toString(preIndex);
                    }
                    nav.toElement(2);
                    int i = nav.getCurrentIndex();
                    boolean entityStringSkipped = false;
                    boolean tokenTypeIsCharData = nav.getTokenType(i) == 5;
                    boolean postTextAvailable = true;
                    while (!tokenTypeIsCharData || !entityStringSkipped) {
                        ++i;
                        if (tokenTypeIsCharData) {
                            entityStringSkipped = true;
                        }
                        if (entityStringSkipped && nav.getTokenType(i) == 0 && "e".equals(nav.toString(i))) {
                            postTextAvailable = false;
                            break;
                        }
                        tokenTypeIsCharData = nav.getTokenType(i) == 5;
                    }
                    String postText = "";
                    if (postTextAvailable) {
                        postText = nav.toString(i);
                    }
                    String kontext = preText + entityText + postText;
                    kontextPosition = text.indexOf(kontext, kontextPosition);
                    entityPosition = Math.max(kontextPosition, entityPosition);
                    if (preIndex != lastPostTextPosition && preText.length() > 0 && preIndex != lastEntityStartIndex) {
                        entityPosition += preText.length();
                    }
                    lastEntityStartIndex = nav.getText();
                    if (postTextAvailable) {
                        lastPostTextPosition = i;
                    }
                    int entityPosStart = text.indexOf(entityText, entityPosition);
                    int entityPosEnd = entityPosStart + entityText.length();
                    HashMap<String, String> wordMap = null;
                    if (words != null) {
                        wordMap = this.buildWordMap(words, wordIds, entityPosition, text);
                    }
                    if (entityPosStart >= 0) {
                        if (entityIdStr != null) {
                            String[] entityIds = entityIdStr.split("\\|");
                            Pattern wordPosP = Pattern.compile(":[0-9,]+$");
                            for (String entityId : entityIds) {
                                Matcher wordPosM = wordPosP.matcher(entityId);
                                if (entityId.split(":").length >= 3 && wordPosM.find()) {
                                    String match = wordPosM.group();
                                    String[] wordIdsForEntity = match.substring(1).split(",");
                                    int start = Integer.parseInt(wordMap.get(wordIdsForEntity[0]).split("-")[0]);
                                    int end = Integer.parseInt(wordMap.get(wordIdsForEntity[wordIdsForEntity.length - 1]).split("-")[1]);
                                    String specType = entityId;
                                    this.addEntity(jcas, start, end, specType);
                                    continue;
                                }
                                this.addEntity(jcas, entityPosStart, entityPosEnd, entityId);
                            }
                        } else {
                            this.LOGGER.warn("entity[begin=" + entityPosStart + ",end=" + entityPosEnd + "] without id attribute found, setting idText to null");
                            this.addEntity(jcas, entityPosStart, entityPosEnd, "null");
                        }
                        entityPosition = entityPosEnd;
                        if (!postTextAvailable) continue;
                        entityPosition += postText.length();
                        continue;
                    }
                    throw new IllegalStateException("Entity \"" + entityText + "\" is not part of the document " + new String(identifier) + ". Document text is:\n" + docText.getText());
                }
            }
        }
        catch (Exception e) {
            this.LOGGER.error("Error while parsing entity", (Throwable)e);
        }
    }

    private HashMap<String, String> buildWordMap(String[] words, String[] wordIds, int entityPosition, String text) {
        HashMap<String, String> wordMap = new HashMap<String, String>();
        int wordEnd = entityPosition;
        for (int i = 0; i < words.length; ++i) {
            String word = words[i];
            String wordId = wordIds[i];
            int wordStart = text.indexOf(word, wordEnd);
            wordEnd = wordStart + word.length();
            wordMap.put(wordId, wordStart + "-" + wordEnd);
        }
        return wordMap;
    }

    private void addEntity(JCas jcas, int entityPosStart, int entityPosEnd, String entityId) {
        EntityMention entityAnno = new EntityMention(jcas, entityPosStart, entityPosEnd);
        entityAnno.setSpecificType(entityId);
        entityAnno.addToIndexes();
    }
}

