/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jssf.conceptdb.services;

import de.julielab.jssf.commons.services.IJSSFModule;
import de.julielab.jssf.conceptdb.services.ConceptDBSetupService;
import de.julielab.jssf.conceptdb.services.IConceptDBSetupService;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ConfigurationUtils;
import org.apache.commons.configuration2.XMLConfiguration;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.builder.fluent.XMLBuilderParameters;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.io.FileBased;
import org.apache.commons.configuration2.io.FileHandler;
import org.apache.commons.configuration2.tree.ExpressionEngine;
import org.apache.commons.configuration2.tree.xpath.XPathExpressionEngine;
import org.apache.tapestry5.ioc.ServiceBinder;

public class ConceptDBModule
implements IJSSFModule {
    private boolean managedByJSSF;

    public boolean managedByJSSF() {
        return this.managedByJSSF;
    }

    public String getName() {
        return "concept-database";
    }

    public String getDescription() {
        return "A Neo4j graph database storing the concept graph. The concepts serve as domain knowledge for the application the database is integrated into.";
    }

    public void bind(ServiceBinder binder) {
        binder.bind(IConceptDBSetupService.class, ConceptDBSetupService.class).withSimpleId();
    }

    public static void main(String[] args) throws IOException, ConfigurationException {
        Parameters params = new Parameters();
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(XMLConfiguration.class).configure(new BuilderParameters[]{(BuilderParameters)((XMLBuilderParameters)params.xml().setExpressionEngine((ExpressionEngine)new XPathExpressionEngine())).setEncoding(StandardCharsets.UTF_8.name())});
        XMLConfiguration c = (XMLConfiguration)builder.getConfiguration();
        c.addProperty("imports/import", (Object)"");
        c.addProperty("imports/import", (Object)"");
        c.addProperty("imports/import[last()] concepts", (Object)"hallo");
        c.addProperty("imports/import[last()] facet", (Object)"meins");
        System.out.println(ConfigurationUtils.toString((Configuration)c));
        FileHandler fh = new FileHandler((FileBased)c);
        fh.save("mytestconf.xml");
    }
}

