/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jssf.conceptdb.services;

import de.julielab.java.utilities.ConfigurationUtilities;
import de.julielab.jssf.commons.services.IModuleSetup;
import de.julielab.jssf.commons.util.ResourceAccessException;
import de.julielab.jssf.conceptdb.services.IConceptDBSetupService;
import de.julielab.jssf.conceptdb.util.ConceptDBInstallationException;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.lang3.StringUtils;

public class ConceptDBModuleSetup
implements IModuleSetup {
    public static final String CONFKEY_NEO4J_ARCHIVE_URI = "neo4jarchive.uri";
    public static final String CONFKEY_DELETE_ARCHIVE_AFTER_DOWNLOAD = "neo4jarchive.deleteafterdownload";
    public static final String CONFKEY_STORAGE_DIR = "storagedirectory";
    public static final String CONFKEY_CONCEPT_DB_CONFIG = "configuration";
    private IConceptDBSetupService conceptDBSetupService;

    public ConceptDBModuleSetup(IConceptDBSetupService conceptDBSetupService) {
        this.conceptDBSetupService = conceptDBSetupService;
    }

    public void setup(HierarchicalConfiguration<ImmutableNode> configuration) throws ConceptDBInstallationException, de.julielab.jssf.commons.util.ConfigurationException {
        String fixedArchiveUri = configuration.getString(CONFKEY_NEO4J_ARCHIVE_URI);
        try {
            File neo4jStorageDestination = new File((String)ConfigurationUtilities.requirePresent((String)CONFKEY_STORAGE_DIR, arg_0 -> configuration.getString(arg_0)));
            boolean deleteArchive = configuration.getBoolean(CONFKEY_DELETE_ARCHIVE_AFTER_DOWNLOAD, true);
            if (!StringUtils.isBlank((CharSequence)fixedArchiveUri)) {
                this.conceptDBSetupService.installNeo4j(new URI(fixedArchiveUri), neo4jStorageDestination, deleteArchive);
            } else {
                this.conceptDBSetupService.installNeo4j(neo4jStorageDestination, deleteArchive);
            }
        }
        catch (ResourceAccessException | URISyntaxException e) {
            throw new ConceptDBInstallationException(e);
        }
        catch (ConfigurationException e) {
            throw new de.julielab.jssf.commons.util.ConfigurationException((Throwable)e);
        }
    }

    public void exposeParameters(String basePath, HierarchicalConfiguration<ImmutableNode> template) {
        template.setProperty(ConfigurationUtilities.dot((String[])new String[]{basePath, CONFKEY_NEO4J_ARCHIVE_URI}), (Object)"");
        template.setProperty(ConfigurationUtilities.dot((String[])new String[]{basePath, CONFKEY_DELETE_ARCHIVE_AFTER_DOWNLOAD}), (Object)false);
        template.setProperty(ConfigurationUtilities.dot((String[])new String[]{basePath, CONFKEY_STORAGE_DIR}), (Object)"jssf-concept-db");
    }
}

