/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jssf.conceptdb.services;

import de.julielab.java.utilities.CompressionUtilities;
import de.julielab.jssf.commons.FileOperations;
import de.julielab.jssf.commons.services.IDownloadService;
import de.julielab.jssf.commons.services.IExternalToolService;
import de.julielab.jssf.commons.util.ResourceAccessException;
import de.julielab.jssf.conceptdb.services.IConceptDBSetupService;
import de.julielab.jssf.conceptdb.util.ConceptDBPopulationException;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConceptDBSetupService
implements IConceptDBSetupService {
    private static final Logger log = LoggerFactory.getLogger(ConceptDBSetupService.class);
    private static final String DOWNLOAD_NEO4J_URL_FMT = "https://neo4j.com/artifact.php?name=neo4j-community-%s-unix.tar.gz";
    private static final String DOWNLOAD_CONCEPT_PLUGIN_URL_FMT = "https://oss.sonatype.org/content/repositories/public/de/julielab/julielab-neo4j-plugins-concepts/%s/julielab-neo4j-plugins-concepts-%s-assembly.jar";
    private static final String NEO4J_PLUGIN_DIR = "plugins";
    private IDownloadService downloadService;
    private IExternalToolService externalToolService;

    public ConceptDBSetupService(IDownloadService downloadService, IExternalToolService externalToolService) {
        this.downloadService = downloadService;
        this.externalToolService = externalToolService;
    }

    @Override
    public File installNeo4j(File destination) throws ResourceAccessException {
        return this.installNeo4j(destination, true);
    }

    @Override
    public File installNeo4j(File destination, boolean deleteArchive) throws ResourceAccessException {
        String version = this.externalToolService.getRequiredVersion("neo4j");
        try {
            URI uri = new URI(String.format(DOWNLOAD_NEO4J_URL_FMT, version));
            return this.installNeo4j(uri, destination, deleteArchive);
        }
        catch (URISyntaxException e) {
            throw new ResourceAccessException("Could not build a valid URI with the URI template https://neo4j.com/artifact.php?name=neo4j-community-%s-unix.tar.gz and the given version " + version + ".");
        }
    }

    @Override
    public File installNeo4j(URI address, File destination) throws ResourceAccessException {
        return this.installNeo4j(address, destination, true);
    }

    @Override
    public File installNeo4j(URI address, File destination, boolean deleteArchive) throws ResourceAccessException {
        File neo4jDir;
        File neo4jArchive = this.downloadService.store(address, destination, "Neo4j");
        try {
            neo4jDir = CompressionUtilities.extract((File)neo4jArchive, (File)destination, (boolean)deleteArchive);
            FileOperations.checkDirectory((File)neo4jDir);
            String conceptsPluginVersion = this.externalToolService.getRequiredVersion("neo4j-plugin-concepts");
            URI pluginUri = new URI(String.format(DOWNLOAD_CONCEPT_PLUGIN_URL_FMT, conceptsPluginVersion, conceptsPluginVersion));
            File pluginPath = new File(neo4jDir.getAbsolutePath() + File.separator + NEO4J_PLUGIN_DIR);
            if (!pluginPath.exists()) {
                pluginPath.mkdir();
            }
            this.downloadService.store(pluginUri, pluginPath, "Neo4j Concepts Plugin");
        }
        catch (URISyntaxException e) {
            throw new ResourceAccessException((Throwable)e);
        }
        catch (IOException e) {
            throw new ResourceAccessException((Throwable)e);
        }
        return neo4jDir;
    }

    @Override
    public void populateDatabase(String neo4jRoot, HierarchicalConfiguration<ImmutableNode> dbConfig) throws ConceptDBPopulationException {
    }
}

