/*
 * Decompiled with CFR 0.152.
 */
package GNormPluslib;

import GNormPluslib.GNormPlus;
import com.pengyifan.bioc.BioCAnnotation;
import com.pengyifan.bioc.BioCCollection;
import com.pengyifan.bioc.BioCDocument;
import com.pengyifan.bioc.BioCLocation;
import com.pengyifan.bioc.BioCPassage;
import com.pengyifan.bioc.io.BioCCollectionReader;
import com.pengyifan.bioc.io.BioCCollectionWriter;
import com.pengyifan.bioc.io.BioCDocumentWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.invoke.CallSite;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;

public class BioCDoc {
    public ArrayList<String> PMIDs = new ArrayList();
    public ArrayList<ArrayList<String>> PassageNames = new ArrayList();
    public ArrayList<ArrayList<Integer>> PassageOffsets = new ArrayList();
    public ArrayList<ArrayList<String>> PassageContexts = new ArrayList();
    public ArrayList<ArrayList<ArrayList<String>>> Annotations = new ArrayList();

    public String BioCFormatCheck(String InputFile) throws IOException {
        try (BioCCollectionReader bioCCollectionReader = new BioCCollectionReader((Reader)new InputStreamReader((InputStream)new FileInputStream(InputFile), "UTF-8"));){
            BioCCollection bioCCollection = bioCCollectionReader.readCollection();
        }
        catch (FileNotFoundException | UnsupportedEncodingException | XMLStreamException e) {
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(InputFile), "UTF-8"));
            String line = "";
            String status = "";
            String Pmid = "";
            boolean tiabs = false;
            Pattern patt = Pattern.compile("^([^\\|\\t]+)\\|([^\\|\\t]+)\\|(.*)$");
            while ((line = br.readLine()) != null) {
                Matcher mat = patt.matcher(line);
                if (mat.find()) {
                    if (Pmid.equals("")) {
                        Pmid = mat.group(1);
                    } else if (!Pmid.equals(mat.group(1))) {
                        return "[Error]: " + InputFile + " - A blank is needed between " + Pmid + " and " + mat.group(1) + ".";
                    }
                    status = "tiabs";
                    tiabs = true;
                    continue;
                }
                if (line.contains("\t") || line.length() != 0) continue;
                if (status.equals("")) {
                    if (Pmid.equals("")) {
                        return "[Error]: " + InputFile + " - It's neither BioC nor PubTator format. PMID is empty.";
                    }
                    return "[Error]: " + InputFile + " - A redundant blank is after " + Pmid + ".";
                }
                Pmid = "";
                status = "";
            }
            br.close();
            if (!tiabs) {
                return "[Error]: " + InputFile + " - It's neither BioC nor PubTator format.";
            }
            if (status.equals("")) {
                return "PubTator";
            }
            return "[Error]: " + InputFile + " - The last column missed a blank.";
        }
        return "BioC";
    }

    public void PubTator2BioC(String input, String output) throws IOException, XMLStreamException {
        String line;
        BioCCollectionWriter bioCCollectionWriter = new BioCCollectionWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(output), "UTF-8"));
        BioCCollection biocCollection = new BioCCollection();
        ZoneId zonedId = ZoneId.of("America/Montreal");
        LocalDate today = LocalDate.now(zonedId);
        biocCollection.setDate(today.toString());
        biocCollection.setKey("BioC.key");
        biocCollection.setSource("GNormPlus");
        BufferedReader inputfile = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(input), "UTF-8"));
        ArrayList<String> ParagraphType = new ArrayList<String>();
        ArrayList<String> ParagraphContent = new ArrayList<String>();
        ArrayList<CallSite> annotations = new ArrayList<CallSite>();
        String Pmid = "";
        while ((line = inputfile.readLine()) != null) {
            if (line.contains("|") && !line.contains("\t")) {
                String[] str = line.split("\\|", -1);
                Pmid = str[0];
                if (str[1].equals("t")) {
                    str[1] = "title";
                }
                if (str[1].equals("a")) {
                    str[1] = "abstract";
                }
                ParagraphType.add(str[1]);
                if (str.length == 3) {
                    String txt = str[2];
                    txt = txt.replaceAll("\u03c9", "w");
                    txt = txt.replaceAll("\u03bc", "u");
                    txt = txt.replaceAll("\u03ba", "k");
                    txt = txt.replaceAll("\u03b1", "a");
                    txt = txt.replaceAll("\u03b3", "g");
                    txt = txt.replaceAll("\u0263", "g");
                    txt = txt.replaceAll("\u03b2", "b");
                    txt = txt.replaceAll("\u00d7", "x");
                    txt = txt.replaceAll("\u2011", "-");
                    txt = txt.replaceAll("\u00b9", "1");
                    txt = txt.replaceAll("\u00b2", "2");
                    txt = txt.replaceAll("\u00b0", "o");
                    txt = txt.replaceAll("\u00f6", "o");
                    txt = txt.replaceAll("\u00e9", "e");
                    txt = txt.replaceAll("\u00e0", "a");
                    txt = txt.replaceAll("\u00c1", "A");
                    txt = txt.replaceAll("\u03b5", "e");
                    txt = txt.replaceAll("\u03b8", "O");
                    txt = txt.replaceAll("\u2022", ".");
                    txt = txt.replaceAll("\u00b5", "u");
                    txt = txt.replaceAll("\u03bb", "r");
                    txt = txt.replaceAll("\u207a", "+");
                    txt = txt.replaceAll("\u03bd", "v");
                    txt = txt.replaceAll("\u00ef", "i");
                    txt = txt.replaceAll("\u00e3", "a");
                    txt = txt.replaceAll("\u2261", "=");
                    txt = txt.replaceAll("\u00f3", "o");
                    txt = txt.replaceAll("\u00b3", "3");
                    txt = txt.replaceAll("\u3016", "[");
                    txt = txt.replaceAll("\u3017", "]");
                    txt = txt.replaceAll("\u00c5", "A");
                    txt = txt.replaceAll("\u03c1", "p");
                    txt = txt.replaceAll("\u00fc", "u");
                    txt = txt.replaceAll("\u025b", "e");
                    txt = txt.replaceAll("\u010d", "c");
                    txt = txt.replaceAll("\u0161", "s");
                    txt = txt.replaceAll("\u00df", "b");
                    txt = txt.replaceAll("\u2550", "=");
                    txt = txt.replaceAll("\u00a3", "L");
                    txt = txt.replaceAll("\u0141", "L");
                    txt = txt.replaceAll("\u0192", "f");
                    txt = txt.replaceAll("\u00e4", "a");
                    txt = txt.replaceAll("\u2013", "-");
                    txt = txt.replaceAll("\u207b", "-");
                    txt = txt.replaceAll("\u3008", "<");
                    txt = txt.replaceAll("\u3009", ">");
                    txt = txt.replaceAll("\u03c7", "X");
                    txt = txt.replaceAll("\u0110", "D");
                    txt = txt.replaceAll("\u2030", "%");
                    txt = txt.replaceAll("\u00b7", ".");
                    txt = txt.replaceAll("\u2192", ">");
                    txt = txt.replaceAll("\u2190", "<");
                    txt = txt.replaceAll("\u03b6", "z");
                    txt = txt.replaceAll("\u03c0", "p");
                    txt = txt.replaceAll("\u03c4", "t");
                    txt = txt.replaceAll("\u03be", "X");
                    txt = txt.replaceAll("\u03b7", "h");
                    txt = txt.replaceAll("\u00f8", "0");
                    txt = txt.replaceAll("\u0394", "D");
                    txt = txt.replaceAll("\u2206", "D");
                    txt = txt.replaceAll("\u2211", "S");
                    txt = txt.replaceAll("\u03a9", "O");
                    txt = txt.replaceAll("\u03b4", "d");
                    txt = txt.replaceAll("\u03c3", "s");
                    txt = txt.replaceAll("\u03a6", "F");
                    txt = txt.replaceAll("[^\\~\\!\\@\\#\\$\\%\\^\\&\\*\\(\\)\\_\\+\\{\\}\\|\\:\"\\<\\>\\?\\`\\-\\=\\[\\]\\;\\'\\,\\.\\/\\r\\n0-9a-zA-Z ]", " ");
                    ParagraphContent.add(txt);
                    continue;
                }
                ParagraphContent.add("- No text -");
                continue;
            }
            if (line.contains("\t")) {
                String[] anno = line.split("\t");
                if (anno.length == 6) {
                    annotations.add((CallSite)((Object)(anno[1] + "\t" + anno[2] + "\t" + anno[3] + "\t" + anno[4] + "\t" + anno[5])));
                    continue;
                }
                if (anno.length != 5) continue;
                annotations.add((CallSite)((Object)(anno[1] + "\t" + anno[2] + "\t" + anno[3] + "\t" + anno[4])));
                continue;
            }
            if (line.length() != 0) continue;
            BioCDocument biocDocument = new BioCDocument();
            biocDocument.setID(Pmid);
            int startoffset = 0;
            for (int i = 0; i < ParagraphType.size(); ++i) {
                BioCPassage biocPassage = new BioCPassage();
                HashMap<String, String> Infons = new HashMap<String, String>();
                Infons.put("type", (String)ParagraphType.get(i));
                biocPassage.setInfons(Infons);
                biocPassage.setText((String)ParagraphContent.get(i));
                biocPassage.setOffset(startoffset);
                startoffset = startoffset + ((String)ParagraphContent.get(i)).length() + 1;
                for (int j = 0; j < annotations.size(); ++j) {
                    String[] anno = ((String)annotations.get(j)).split("\t");
                    if (Integer.parseInt(anno[0]) >= startoffset || Integer.parseInt(anno[0]) < startoffset - ((String)ParagraphContent.get(i)).length() - 1) continue;
                    BioCAnnotation biocAnnotation = new BioCAnnotation();
                    HashMap<String, String> AnnoInfons = new HashMap<String, String>();
                    if (anno.length == 5) {
                        AnnoInfons.put("Identifier", anno[4]);
                    }
                    AnnoInfons.put("type", anno[3]);
                    biocAnnotation.setInfons(AnnoInfons);
                    BioCLocation location = new BioCLocation(Integer.parseInt(anno[0]), Integer.parseInt(anno[1]) - Integer.parseInt(anno[0]));
                    biocAnnotation.setLocations(Set.of(location));
                    biocAnnotation.setText(anno[2]);
                    biocPassage.addAnnotation(biocAnnotation);
                }
                biocDocument.addPassage(biocPassage);
            }
            biocCollection.addDocument(biocDocument);
            ParagraphType.clear();
            ParagraphContent.clear();
            annotations.clear();
        }
        bioCCollectionWriter.writeCollection(biocCollection);
        bioCCollectionWriter.close();
        inputfile.close();
    }

    public void BioC2PubTator(String input, String output) throws IOException, XMLStreamException {
        HashMap<String, String> pmidlist = new HashMap<String, String>();
        boolean duplicate = false;
        BufferedWriter PubTatorOutputFormat = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(output), "UTF-8"));
        BioCCollection collection = new BioCCollection();
        BioCCollectionReader bioCCollectionReader = new BioCCollectionReader((Reader)new InputStreamReader((InputStream)new FileInputStream(input), "UTF-8"));
        Iterator docIt = bioCCollectionReader.readCollection().documentIterator();
        while (docIt.hasNext()) {
            BioCDocument document = (BioCDocument)docIt.next();
            String PMID = document.getID();
            if (pmidlist.containsKey(PMID)) {
                System.out.println("\nError: duplicate pmid-" + PMID);
                duplicate = true;
            } else {
                pmidlist.put(PMID, "");
            }
            Object Anno = "";
            for (BioCPassage passage : document.getPassages()) {
                if (((String)passage.getInfon("type").get()).equals("title")) {
                    PubTatorOutputFormat.write(PMID + "|t|" + (String)passage.getText().get() + "\n");
                } else if (((String)passage.getInfon("type").get()).equals("abstract")) {
                    PubTatorOutputFormat.write(PMID + "|a|" + (String)passage.getText().get() + "\n");
                } else {
                    PubTatorOutputFormat.write(PMID + "|" + (String)passage.getInfon("type").get() + "|" + (String)passage.getText().get() + "\n");
                }
                for (BioCAnnotation annotation : passage.getAnnotations()) {
                    String Annotype = (String)annotation.getInfon("type").get();
                    Object Annoid = "";
                    String Proteinid = "";
                    if (Annotype.matches("(Gene|FamilyName|DomainMotif)")) {
                        if (annotation.getInfons().containsKey("NCBI Gene")) {
                            Annoid = (String)annotation.getInfon("NCBI Gene").get();
                            String[] Annoidlist = ((String)Annoid).split(";");
                            Annoid = "";
                            for (int x = 0; x < Annoidlist.length; ++x) {
                                String proteinid = "";
                                String homoid = "";
                                if (GNormPlus.Normalization2Protein_hash.containsKey(Annoidlist[x])) {
                                    proteinid = GNormPlus.Normalization2Protein_hash.get(Annoidlist[x]);
                                }
                                if (GNormPlus.HomologeneID_hash.containsKey(Annoidlist[x])) {
                                    homoid = GNormPlus.HomologeneID_hash.get(Annoidlist[x]);
                                }
                                if (!proteinid.equals("") || !homoid.equals("")) {
                                    if (((String)Annoid).equals("")) {
                                        Annoid = Annoidlist[x] + "(";
                                        if (!proteinid.equals("")) {
                                            Annoid = (String)Annoid + "UniProt:" + proteinid;
                                        }
                                        if (!homoid.equals("")) {
                                            if (!proteinid.equals("")) {
                                                Annoid = (String)Annoid + ";";
                                            }
                                            Annoid = (String)Annoid + "Homoid:" + homoid;
                                        }
                                        Annoid = (String)Annoid + ")";
                                        continue;
                                    }
                                    Annoid = (String)Annoid + ";" + Annoidlist[x] + "(";
                                    if (!proteinid.equals("")) {
                                        Annoid = (String)Annoid + "UniProt:" + proteinid;
                                    }
                                    if (!homoid.equals("")) {
                                        if (!proteinid.equals("")) {
                                            Annoid = (String)Annoid + ";";
                                        }
                                        Annoid = (String)Annoid + "Homoid:" + homoid;
                                    }
                                    Annoid = (String)Annoid + ")";
                                    continue;
                                }
                                Annoid = ((String)Annoid).equals("") ? Annoidlist[x] : (String)Annoid + ";" + Annoidlist[x];
                            }
                        } else {
                            Annoid = annotation.getInfon("Identifier").orElse(null);
                        }
                    } else {
                        Annoid = Annotype.equals("Species") || Annotype.equals("Genus") || Annotype.equals("Strain") ? (annotation.getInfons().containsKey("NCBI Taxonomy") ? (String)annotation.getInfon("NCBI Taxonomy").get() : (String)annotation.getInfon("Identifier").get()) : (Annotype.equals("CellLine") ? (annotation.getInfons().containsKey("NCBI Taxonomy") ? (String)annotation.getInfon("NCBI Taxonomy").get() : (String)annotation.getInfon("Identifier").get()) : (String)annotation.getInfon("Identifier").get());
                    }
                    int start = annotation.getTotalLocation().getOffset();
                    int last = start + annotation.getTotalLocation().getLength();
                    String AnnoMention = (String)annotation.getText().get();
                    Anno = (String)Anno + PMID + "\t" + start + "\t" + last + "\t" + AnnoMention + "\t" + Annotype + "\t" + (String)Annoid + "\n";
                }
            }
            PubTatorOutputFormat.write((String)Anno + "\n");
        }
        PubTatorOutputFormat.close();
        if (duplicate) {
            System.exit(0);
        }
    }

    public void BioC2PubTator(String original_input, String input, String output) throws IOException, XMLStreamException {
        String line;
        BufferedReader inputfile = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(original_input), "UTF-8"));
        HashMap<CallSite, String> ParagraphContent = new HashMap<CallSite, String>();
        HashMap<String, CallSite> annotations = new HashMap<String, CallSite>();
        String Pmid = "";
        int count_paragraph = 0;
        while ((line = inputfile.readLine()) != null) {
            if (line.contains("|") && !line.contains("\t")) {
                String[] str = line.split("\\|", -1);
                Pmid = str[0];
                ParagraphContent.put((CallSite)((Object)(Pmid + "\t" + str[1])), str[2]);
                ++count_paragraph;
                continue;
            }
            if (line.contains("\t")) {
                annotations.put(Pmid, (CallSite)((Object)((String)annotations.get(Pmid) + line)));
                continue;
            }
            if (line.length() != 0) continue;
            count_paragraph = 0;
        }
        inputfile.close();
        HashMap<String, String> pmidlist = new HashMap<String, String>();
        boolean duplicate = false;
        BufferedWriter PubTatorOutputFormat = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(output), "UTF-8"));
        BioCCollection collection = new BioCCollection();
        BioCCollectionReader bioCCollectionReader = new BioCCollectionReader((Reader)new InputStreamReader((InputStream)new FileInputStream(input), "UTF-8"));
        Iterator docIt = bioCCollectionReader.readCollection().documentIterator();
        while (docIt.hasNext()) {
            BioCDocument document = (BioCDocument)docIt.next();
            String PMID = document.getID();
            if (pmidlist.containsKey(PMID)) {
                System.out.println("\nError: duplicate pmid-" + PMID);
                duplicate = true;
            } else {
                pmidlist.put(PMID, "");
            }
            Object Anno = "";
            for (BioCPassage passage : document.getPassages()) {
                if (((String)passage.getInfon("type").get()).equals("title") || ((String)passage.getInfon("type").get()).equals("t")) {
                    PubTatorOutputFormat.write(PMID + "|t|" + (String)ParagraphContent.get(PMID + "\tt") + "\n");
                } else if (((String)passage.getInfon("type").get()).equals("abstract") || ((String)passage.getInfon("type").get()).equals("a")) {
                    PubTatorOutputFormat.write(PMID + "|a|" + (String)ParagraphContent.get(PMID + "\ta") + "\n");
                } else {
                    PubTatorOutputFormat.write(PMID + "|" + (String)passage.getInfon("type").get() + "|" + (String)passage.getText().get() + "\n");
                }
                for (BioCAnnotation annotation : passage.getAnnotations()) {
                    String Annotype = (String)annotation.getInfon("type").get();
                    Object Annoid = "";
                    String Proteinid = "";
                    if (Annotype.matches("(Gene|FamilyName|DomainMotif)")) {
                        if (annotation.getInfons().containsKey("NCBI Gene")) {
                            Annoid = (String)annotation.getInfon("NCBI Gene").get();
                            String[] Annoidlist = ((String)Annoid).split(";");
                            Annoid = "";
                            for (int x = 0; x < Annoidlist.length; ++x) {
                                String proteinid = "";
                                String homoid = "";
                                if (GNormPlus.Normalization2Protein_hash.containsKey(Annoidlist[x])) {
                                    proteinid = GNormPlus.Normalization2Protein_hash.get(Annoidlist[x]);
                                }
                                if (GNormPlus.HomologeneID_hash.containsKey(Annoidlist[x])) {
                                    homoid = GNormPlus.HomologeneID_hash.get(Annoidlist[x]);
                                }
                                if (!proteinid.equals("") || !homoid.equals("")) {
                                    if (((String)Annoid).equals("")) {
                                        Annoid = Annoidlist[x] + "(";
                                        if (!proteinid.equals("")) {
                                            Annoid = (String)Annoid + "UniProt:" + proteinid;
                                        }
                                        if (!homoid.equals("")) {
                                            if (!proteinid.equals("")) {
                                                Annoid = (String)Annoid + ";";
                                            }
                                            Annoid = (String)Annoid + "Homoid:" + homoid;
                                        }
                                        Annoid = (String)Annoid + ")";
                                        continue;
                                    }
                                    Annoid = (String)Annoid + ";" + Annoidlist[x] + "(";
                                    if (!proteinid.equals("")) {
                                        Annoid = (String)Annoid + "UniProt:" + proteinid;
                                    }
                                    if (!homoid.equals("")) {
                                        if (!proteinid.equals("")) {
                                            Annoid = (String)Annoid + ";";
                                        }
                                        Annoid = (String)Annoid + "Homoid:" + homoid;
                                    }
                                    Annoid = (String)Annoid + ")";
                                    continue;
                                }
                                Annoid = ((String)Annoid).equals("") ? Annoidlist[x] : (String)Annoid + ";" + Annoidlist[x];
                            }
                        } else {
                            Annoid = (String)annotation.getInfon("Identifier").get();
                        }
                    } else {
                        Annoid = Annotype.equals("Species") || Annotype.equals("Genus") || Annotype.equals("Strain") ? (annotation.getInfons().containsKey("NCBI Taxonomy") ? (String)annotation.getInfon("NCBI Taxonomy").get() : (String)annotation.getInfon("Identifier").get()) : (Annotype.equals("CellLine") ? (annotation.getInfons().containsKey("NCBI Taxonomy") ? (String)annotation.getInfon("NCBI Taxonomy").get() : (String)annotation.getInfon("Identifier").get()) : (annotation.getInfons().containsKey("Identifier") ? (String)annotation.getInfon("Identifier").get() : ""));
                    }
                    int start = annotation.getTotalLocation().getOffset();
                    int last = start + annotation.getTotalLocation().getLength();
                    String AnnoMention = (String)annotation.getText().get();
                    if (Annoid != null && !((String)Annoid).equals(null)) {
                        Anno = (String)Anno + PMID + "\t" + start + "\t" + last + "\t" + AnnoMention + "\t" + Annotype + "\t" + (String)Annoid + "\n";
                        continue;
                    }
                    Anno = (String)Anno + PMID + "\t" + start + "\t" + last + "\t" + AnnoMention + "\t" + Annotype + "\n";
                }
            }
            PubTatorOutputFormat.write((String)Anno + "\n");
        }
        PubTatorOutputFormat.close();
        if (duplicate) {
            System.exit(0);
        }
    }

    public void BioCReader(String input) throws IOException, XMLStreamException {
        BioCCollection collection = new BioCCollection();
        BioCCollectionReader bioCCollectionReader = new BioCCollectionReader((Reader)new InputStreamReader((InputStream)new FileInputStream(input), "UTF-8"));
        Iterator docIt = bioCCollectionReader.readCollection().documentIterator();
        while (docIt.hasNext()) {
            BioCDocument document = (BioCDocument)docIt.next();
            this.PMIDs.add(document.getID());
            ArrayList<String> PassageName = new ArrayList<String>();
            ArrayList<Integer> PassageOffset = new ArrayList<Integer>();
            ArrayList<String> PassageContext = new ArrayList<String>();
            ArrayList AnnotationInPMID = new ArrayList();
            for (BioCPassage passage : document.getPassages()) {
                PassageName.add((String)passage.getInfon("type").get());
                String txt = (String)passage.getText().get();
                if (txt.matches("[\t ]+")) {
                    txt = txt.replaceAll(".", "@");
                } else {
                    txt = txt.replaceAll("\u03c9", "w");
                    txt = txt.replaceAll("\u03bc", "u");
                    txt = txt.replaceAll("\u03ba", "k");
                    txt = txt.replaceAll("\u03b1", "a");
                    txt = txt.replaceAll("\u03b3", "g");
                    txt = txt.replaceAll("\u0263", "g");
                    txt = txt.replaceAll("\u03b2", "b");
                    txt = txt.replaceAll("\u00d7", "x");
                    txt = txt.replaceAll("\u2011", "-");
                    txt = txt.replaceAll("\u00b9", "1");
                    txt = txt.replaceAll("\u00b2", "2");
                    txt = txt.replaceAll("\u00b0", "o");
                    txt = txt.replaceAll("\u00f6", "o");
                    txt = txt.replaceAll("\u00e9", "e");
                    txt = txt.replaceAll("\u00e0", "a");
                    txt = txt.replaceAll("\u00c1", "A");
                    txt = txt.replaceAll("\u03b5", "e");
                    txt = txt.replaceAll("\u03b8", "O");
                    txt = txt.replaceAll("\u2022", ".");
                    txt = txt.replaceAll("\u00b5", "u");
                    txt = txt.replaceAll("\u03bb", "r");
                    txt = txt.replaceAll("\u207a", "+");
                    txt = txt.replaceAll("\u03bd", "v");
                    txt = txt.replaceAll("\u00ef", "i");
                    txt = txt.replaceAll("\u00e3", "a");
                    txt = txt.replaceAll("\u2261", "=");
                    txt = txt.replaceAll("\u00f3", "o");
                    txt = txt.replaceAll("\u00b3", "3");
                    txt = txt.replaceAll("\u3016", "[");
                    txt = txt.replaceAll("\u3017", "]");
                    txt = txt.replaceAll("\u00c5", "A");
                    txt = txt.replaceAll("\u03c1", "p");
                    txt = txt.replaceAll("\u00fc", "u");
                    txt = txt.replaceAll("\u025b", "e");
                    txt = txt.replaceAll("\u010d", "c");
                    txt = txt.replaceAll("\u0161", "s");
                    txt = txt.replaceAll("\u00df", "b");
                    txt = txt.replaceAll("\u2550", "=");
                    txt = txt.replaceAll("\u00a3", "L");
                    txt = txt.replaceAll("\u0141", "L");
                    txt = txt.replaceAll("\u0192", "f");
                    txt = txt.replaceAll("\u00e4", "a");
                    txt = txt.replaceAll("\u2013", "-");
                    txt = txt.replaceAll("\u207b", "-");
                    txt = txt.replaceAll("\u3008", "<");
                    txt = txt.replaceAll("\u3009", ">");
                    txt = txt.replaceAll("\u03c7", "X");
                    txt = txt.replaceAll("\u0110", "D");
                    txt = txt.replaceAll("\u2030", "%");
                    txt = txt.replaceAll("\u00b7", ".");
                    txt = txt.replaceAll("\u2192", ">");
                    txt = txt.replaceAll("\u2190", "<");
                    txt = txt.replaceAll("\u03b6", "z");
                    txt = txt.replaceAll("\u03c0", "p");
                    txt = txt.replaceAll("\u03c4", "t");
                    txt = txt.replaceAll("\u03be", "X");
                    txt = txt.replaceAll("\u03b7", "h");
                    txt = txt.replaceAll("\u00f8", "0");
                    txt = txt.replaceAll("\u0394", "D");
                    txt = txt.replaceAll("\u2206", "D");
                    txt = txt.replaceAll("\u2211", "S");
                    txt = txt.replaceAll("\u03a9", "O");
                    txt = txt.replaceAll("\u03b4", "d");
                    txt = txt.replaceAll("\u03c3", "s");
                    txt = txt.replaceAll("\u03a6", "F");
                }
                if (((String)passage.getText().get()).equals("") || ((String)passage.getText().get()).matches("[ ]+")) {
                    PassageContext.add("-notext-");
                } else {
                    PassageContext.add(txt);
                }
                PassageOffset.add(passage.getOffset());
                ArrayList AnnotationInPassage = new ArrayList();
                AnnotationInPMID.add(AnnotationInPassage);
            }
            this.PassageNames.add(PassageName);
            this.PassageContexts.add(PassageContext);
            this.PassageOffsets.add(PassageOffset);
            this.Annotations.add(AnnotationInPMID);
        }
    }

    public void BioCReaderWithAnnotation(String input) throws IOException, XMLStreamException {
        BioCCollection collection = new BioCCollection();
        BioCCollectionReader bioCCollectionReader = new BioCCollectionReader((Reader)new InputStreamReader((InputStream)new FileInputStream(input), "UTF-8"));
        Iterator docIt = bioCCollectionReader.readCollection().documentIterator();
        while (docIt.hasNext()) {
            BioCDocument document = (BioCDocument)docIt.next();
            this.PMIDs.add(document.getID());
            ArrayList<String> PassageName = new ArrayList<String>();
            ArrayList<Integer> PassageOffset = new ArrayList<Integer>();
            ArrayList<String> PassageContext = new ArrayList<String>();
            ArrayList AnnotationInPMID = new ArrayList();
            for (BioCPassage passage : document.getPassages()) {
                PassageName.add((String)passage.getInfon("type").get());
                String txt = (String)passage.getText().get();
                if (txt.matches("[\t ]+")) {
                    txt = txt.replaceAll(".", "@");
                } else {
                    txt = txt.replaceAll("\u03c9", "w");
                    txt = txt.replaceAll("\u03bc", "u");
                    txt = txt.replaceAll("\u03ba", "k");
                    txt = txt.replaceAll("\u03b1", "a");
                    txt = txt.replaceAll("\u03b3", "g");
                    txt = txt.replaceAll("\u0263", "g");
                    txt = txt.replaceAll("\u03b2", "b");
                    txt = txt.replaceAll("\u00d7", "x");
                    txt = txt.replaceAll("\u2011", "-");
                    txt = txt.replaceAll("\u00b9", "1");
                    txt = txt.replaceAll("\u00b2", "2");
                    txt = txt.replaceAll("\u00b0", "o");
                    txt = txt.replaceAll("\u00f6", "o");
                    txt = txt.replaceAll("\u00e9", "e");
                    txt = txt.replaceAll("\u00e0", "a");
                    txt = txt.replaceAll("\u00c1", "A");
                    txt = txt.replaceAll("\u03b5", "e");
                    txt = txt.replaceAll("\u03b8", "O");
                    txt = txt.replaceAll("\u2022", ".");
                    txt = txt.replaceAll("\u00b5", "u");
                    txt = txt.replaceAll("\u03bb", "r");
                    txt = txt.replaceAll("\u207a", "+");
                    txt = txt.replaceAll("\u03bd", "v");
                    txt = txt.replaceAll("\u00ef", "i");
                    txt = txt.replaceAll("\u00e3", "a");
                    txt = txt.replaceAll("\u2261", "=");
                    txt = txt.replaceAll("\u00f3", "o");
                    txt = txt.replaceAll("\u00b3", "3");
                    txt = txt.replaceAll("\u3016", "[");
                    txt = txt.replaceAll("\u3017", "]");
                    txt = txt.replaceAll("\u00c5", "A");
                    txt = txt.replaceAll("\u03c1", "p");
                    txt = txt.replaceAll("\u00fc", "u");
                    txt = txt.replaceAll("\u025b", "e");
                    txt = txt.replaceAll("\u010d", "c");
                    txt = txt.replaceAll("\u0161", "s");
                    txt = txt.replaceAll("\u00df", "b");
                    txt = txt.replaceAll("\u2550", "=");
                    txt = txt.replaceAll("\u00a3", "L");
                    txt = txt.replaceAll("\u0141", "L");
                    txt = txt.replaceAll("\u0192", "f");
                    txt = txt.replaceAll("\u00e4", "a");
                    txt = txt.replaceAll("\u2013", "-");
                    txt = txt.replaceAll("\u207b", "-");
                    txt = txt.replaceAll("\u3008", "<");
                    txt = txt.replaceAll("\u3009", ">");
                    txt = txt.replaceAll("\u03c7", "X");
                    txt = txt.replaceAll("\u0110", "D");
                    txt = txt.replaceAll("\u2030", "%");
                    txt = txt.replaceAll("\u00b7", ".");
                    txt = txt.replaceAll("\u2192", ">");
                    txt = txt.replaceAll("\u2190", "<");
                    txt = txt.replaceAll("\u03b6", "z");
                    txt = txt.replaceAll("\u03c0", "p");
                    txt = txt.replaceAll("\u03c4", "t");
                    txt = txt.replaceAll("\u03be", "X");
                    txt = txt.replaceAll("\u03b7", "h");
                    txt = txt.replaceAll("\u00f8", "0");
                    txt = txt.replaceAll("\u0394", "D");
                    txt = txt.replaceAll("\u2206", "D");
                    txt = txt.replaceAll("\u2211", "S");
                    txt = txt.replaceAll("\u03a9", "O");
                    txt = txt.replaceAll("\u03b4", "d");
                    txt = txt.replaceAll("\u03c3", "s");
                    txt = txt.replaceAll("\u03a6", "F");
                }
                if (((String)passage.getText().get()).equals("") || ((String)passage.getText().get()).matches("[ ]+")) {
                    PassageContext.add("-notext-");
                } else {
                    PassageContext.add(txt);
                }
                PassageOffset.add(passage.getOffset());
                ArrayList<CallSite> AnnotationInPassage = new ArrayList<CallSite>();
                for (BioCAnnotation Anno : passage.getAnnotations()) {
                    int start = Anno.getTotalLocation().getOffset() - passage.getOffset();
                    int last = start + Anno.getTotalLocation().getLength();
                    String AnnoMention = (String)Anno.getText().get();
                    String Annotype = (String)Anno.getInfon("type").get();
                    String Annoid = Anno.getInfon("Identifier").orElse(null);
                    if (Annoid == null) {
                        Annoid = Anno.getInfon("Identifier").orElse(null);
                    }
                    if (Annoid == null || Annoid.equals("null")) {
                        AnnotationInPassage.add((CallSite)((Object)(start + "\t" + last + "\t" + AnnoMention + "\t" + Annotype)));
                        continue;
                    }
                    AnnotationInPassage.add((CallSite)((Object)(start + "\t" + last + "\t" + AnnoMention + "\t" + Annotype + "\t" + Annoid)));
                }
                AnnotationInPMID.add(AnnotationInPassage);
            }
            this.PassageNames.add(PassageName);
            this.PassageContexts.add(PassageContext);
            this.PassageOffsets.add(PassageOffset);
            this.Annotations.add(AnnotationInPMID);
        }
    }

    public void BioCOutput(String input, String output, ArrayList<ArrayList<ArrayList<String>>> Annotations, boolean Final, boolean RemovePreviousAnno) throws IOException, XMLStreamException {
        boolean ShowUnNormalizedMention = false;
        if (GNormPlus.setup_hash.containsKey("ShowUnNormalizedMention") && GNormPlus.setup_hash.get("ShowUnNormalizedMention").equals("True")) {
            ShowUnNormalizedMention = true;
        }
        BioCDocumentWriter BioCOutputFormat = new BioCDocumentWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(output), "UTF-8"));
        BioCCollection biocCollection_input = new BioCCollection();
        BioCCollection biocCollection_output = new BioCCollection();
        biocCollection_input = new BioCCollectionReader((Reader)new InputStreamReader((InputStream)new FileInputStream(input), "UTF-8")).readCollection();
        BioCOutputFormat.writeBeginCollectionInfo(biocCollection_input);
        int i = 0;
        Iterator docIt = biocCollection_input.documentIterator();
        while (docIt.hasNext()) {
            BioCDocument document_output = new BioCDocument();
            BioCDocument document_input = (BioCDocument)docIt.next();
            String PMID = document_input.getID();
            document_output.setID(PMID);
            int annotation_count = 0;
            int j = 0;
            Iterator iterator = document_input.getPassages().iterator();
            while (iterator.hasNext()) {
                String mention;
                int last;
                Object[] Anno;
                int a;
                BioCPassage passage_input;
                BioCPassage passage_output = passage_input = (BioCPassage)iterator.next();
                if (RemovePreviousAnno) {
                    passage_output.clearAnnotations();
                } else {
                    for (BioCAnnotation annotation : passage_output.getAnnotations()) {
                        annotation.setID("" + annotation_count);
                        ++annotation_count;
                    }
                }
                int passage_Offset = passage_input.getOffset();
                String passage_Text = (String)passage_input.getText().get();
                ArrayList<Object> AnnotationInPassage = new ArrayList<Object>();
                if (Annotations.size() > i && Annotations.get(i).size() > j) {
                    for (a = 0; a < Annotations.get(i).get(j).size(); ++a) {
                        Anno = Annotations.get(i).get(j).get(a).split("\\t");
                        int start = Integer.parseInt(Anno[0]);
                        last = Integer.parseInt(Anno[1]);
                        boolean found = false;
                        if (passage_Text.length() > last) {
                            mention = Anno[2];
                            if (Final && passage_Text.length() >= last) {
                                mention = passage_Text.substring(start, last);
                            }
                            if (mention.matches(".*\t.*")) {
                                Anno[3] = Anno[4];
                                if (Anno.length >= 6) {
                                    Anno[4] = Anno[5];
                                }
                            }
                            Object type = Anno[3];
                            Object id = "";
                            if (Anno.length >= 5) {
                                id = Anno[4];
                            }
                            if (Final) {
                                for (int b = 0; b < AnnotationInPassage.size(); ++b) {
                                    String[] Annob = ((String)AnnotationInPassage.get(b)).split("\\t");
                                    int startb = Integer.parseInt(Annob[0]);
                                    int lastb = Integer.parseInt(Annob[1]);
                                    String mentionb = Annob[2];
                                    if (Final && passage_Text.length() >= lastb) {
                                        mentionb = passage_Text.substring(startb, lastb);
                                    }
                                    if (mentionb.matches(".*\t.*")) {
                                        Annob[3] = Annob[4];
                                        if (Annob.length >= 6) {
                                            Annob[4] = Annob[5];
                                        }
                                    }
                                    String typeb = Annob[3];
                                    String idb = "";
                                    if (Annob.length >= 5) {
                                        idb = Annob[4];
                                    }
                                    if (start != startb || last != lastb || !((String)type).equals(typeb)) continue;
                                    found = true;
                                    if (((String)id).matches("(Focus|Right|Left|Prefix|GeneID|Tax):[0-9]+") && !idb.equals("")) break;
                                    if (idb.matches("(Focus|Right|Left|Prefix|GeneID|Tax):[0-9]+") && !((String)id).matches("(Focus|Right|Left|Prefix|GeneID|Tax):[0-9]+") && !((String)id).equals("")) {
                                        AnnotationInPassage.set(b, start + "\t" + last + "\t" + mention + "\t" + (String)type + "\t" + (String)id);
                                        break;
                                    }
                                    if (((String)id).equals("")) break;
                                    AnnotationInPassage.set(b, start + "\t" + last + "\t" + mention + "\t" + (String)type + "\t" + idb + ";" + (String)id);
                                    break;
                                }
                            }
                        }
                        if (found) continue;
                        AnnotationInPassage.add(Annotations.get(i).get(j).get(a));
                    }
                }
                for (a = 0; a < AnnotationInPassage.size(); ++a) {
                    Anno = ((String)AnnotationInPassage.get(a)).split("\\t");
                    HashMap<String, String> id_hash = new HashMap<String, String>();
                    if (Anno.length < 5) continue;
                    int start = Integer.parseInt(Anno[0]);
                    int last2 = Integer.parseInt(Anno[1]);
                    mention = Anno[2];
                    if (Final && passage_Text.length() >= last2) {
                        mention = passage_Text.substring(start, last2);
                    }
                    if (mention.matches(".*\t.*")) {
                        Anno[3] = Anno[4];
                        if (Anno.length >= 6) {
                            Anno[4] = Anno[5];
                        }
                    }
                    Object ids = Anno[4];
                    String[] idlist = ((String)ids).split(",");
                    for (int b = 0; b < idlist.length; ++b) {
                        id_hash.put(idlist[b], "");
                    }
                    ids = "";
                    for (String id : id_hash.keySet()) {
                        if (((String)ids).equals("")) {
                            ids = id;
                            continue;
                        }
                        ids = (String)ids + ";" + id;
                    }
                    AnnotationInPassage.set(a, (String)Anno[0] + "\t" + (String)Anno[1] + "\t" + (String)Anno[2] + "\t" + (String)Anno[3] + "\t" + (String)ids);
                }
                for (a = 0; a < AnnotationInPassage.size(); ++a) {
                    Anno = ((String)AnnotationInPassage.get(a)).split("\\t");
                    int start = Integer.parseInt(Anno[0]);
                    last = Integer.parseInt(Anno[1]);
                    if (passage_Text.length() <= last) continue;
                    String mention2 = Anno[2];
                    if (Final && passage_Text.length() >= last) {
                        mention2 = passage_Text.substring(start, last);
                    }
                    if (mention2.matches(".*\t.*")) {
                        Anno[3] = Anno[4];
                        if (Anno.length >= 6) {
                            Anno[4] = Anno[5];
                        }
                    }
                    if (Anno.length < 4) {
                        throw new IllegalStateException("Document with ID " + PMID + " has annotation \"" + Arrays.toString(Anno) + "\" which is too short: A minimal length of 4 is expected.");
                    }
                    String type = Anno[3];
                    if (type.equals("GeneID")) {
                        type = "Gene";
                    }
                    BioCAnnotation biocAnnotation = new BioCAnnotation();
                    HashMap<String, Object> AnnoInfons = new HashMap<String, Object>();
                    AnnoInfons.put("type", type);
                    if (Anno.length >= 5) {
                        Object identifier = Anno[4];
                        if (Final && !ShowUnNormalizedMention) {
                            if (type.matches("(FamilyName|Domain|Gene)")) {
                                String NCBIGeneID;
                                String TaxonomyID;
                                String Method_SA;
                                Pattern ptmp0 = Pattern.compile("^(Focus|Right|Left|Prefix|GeneID|Tax)\\:([0-9]+)\\|([0-9\\;]+)$");
                                Matcher mtmp0 = ptmp0.matcher((CharSequence)identifier);
                                Pattern ptmp1 = Pattern.compile("^(Focus|Right|Left|Prefix|GeneID|Tax)\\:([0-9]+)\\|([0-9]+)\\-([0-9]+)$");
                                Matcher mtmp1 = ptmp1.matcher((CharSequence)identifier);
                                Pattern ptmp2 = Pattern.compile("^(Focus|Right|Left|Prefix|GeneID|Tax)\\:([0-9]+)$");
                                Matcher mtmp2 = ptmp2.matcher((CharSequence)identifier);
                                Pattern ptmp3 = Pattern.compile("^Homo\\:([0-9]+)$");
                                Matcher mtmp3 = ptmp3.matcher((CharSequence)identifier);
                                if (mtmp0.find()) {
                                    Method_SA = mtmp0.group(1);
                                    TaxonomyID = mtmp0.group(2);
                                    NCBIGeneID = mtmp0.group(3);
                                    if (GNormPlus.Normalization2Protein_hash.containsKey(NCBIGeneID)) {
                                        AnnoInfons.put("UniProt", GNormPlus.Normalization2Protein_hash.get(NCBIGeneID));
                                    }
                                    if (GNormPlus.HomologeneID_hash.containsKey(NCBIGeneID)) {
                                        AnnoInfons.put("NCBI Homologene", GNormPlus.HomologeneID_hash.get(NCBIGeneID));
                                    }
                                    AnnoInfons.put("NCBI Gene", NCBIGeneID);
                                } else if (mtmp1.find()) {
                                    Method_SA = mtmp1.group(1);
                                    TaxonomyID = mtmp1.group(2);
                                    NCBIGeneID = mtmp1.group(3);
                                    String HomoID = mtmp1.group(4);
                                    if (GNormPlus.Normalization2Protein_hash.containsKey(NCBIGeneID)) {
                                        AnnoInfons.put("UniProt", GNormPlus.Normalization2Protein_hash.get(NCBIGeneID));
                                    }
                                    if (GNormPlus.HomologeneID_hash.containsKey(NCBIGeneID)) {
                                        AnnoInfons.put("NCBI Homologene", GNormPlus.HomologeneID_hash.get(NCBIGeneID));
                                    }
                                    AnnoInfons.put("NCBI Gene", NCBIGeneID);
                                } else if (mtmp2.find()) {
                                    Method_SA = mtmp2.group(1);
                                    TaxonomyID = mtmp2.group(2);
                                    AnnoInfons.put("FocusSpecies", "NCBITaxonomyID:" + TaxonomyID);
                                } else if (mtmp3.find()) {
                                    Method_SA = mtmp3.group(1);
                                    String HomoID = mtmp3.group(2);
                                    AnnoInfons.put("NCBI Homologene", HomoID);
                                } else {
                                    String[] identifiers = ((String)identifier).split(";");
                                    if (identifiers.length > 1) {
                                        ArrayList<String> identifierSTR = new ArrayList<String>();
                                        ArrayList<String> ProteinidSTR = new ArrayList<String>();
                                        ArrayList<String> HomoidSTR = new ArrayList<String>();
                                        for (int idi = 0; idi < identifiers.length; ++idi) {
                                            String NCBIGeneID2;
                                            String TaxonomyID2;
                                            String Method_SA2;
                                            Pattern ptmp4 = Pattern.compile("^(Focus|Right|Left|Prefix|GeneID|Tax)\\:([0-9]+)\\|([0-9]+)\\-([0-9]+)$");
                                            Matcher mtmp4 = ptmp4.matcher(identifiers[idi]);
                                            Pattern ptmp5 = Pattern.compile("^(Focus|Right|Left|Prefix|GeneID|Tax)\\:([0-9]+)\\|([0-9\\;]+)$");
                                            Matcher mtmp5 = ptmp5.matcher(identifiers[idi]);
                                            if (mtmp4.find()) {
                                                Method_SA2 = mtmp4.group(1);
                                                TaxonomyID2 = mtmp4.group(2);
                                                NCBIGeneID2 = mtmp4.group(3);
                                                String HomoID = mtmp4.group(4);
                                                if (!identifierSTR.contains(NCBIGeneID2)) {
                                                    identifierSTR.add(NCBIGeneID2);
                                                }
                                                if (GNormPlus.Normalization2Protein_hash.containsKey(NCBIGeneID2) && !ProteinidSTR.contains(GNormPlus.Normalization2Protein_hash.containsKey(NCBIGeneID2))) {
                                                    ProteinidSTR.add(GNormPlus.Normalization2Protein_hash.get(NCBIGeneID2));
                                                }
                                                if (!GNormPlus.HomologeneID_hash.containsKey(NCBIGeneID2) || HomoidSTR.contains(GNormPlus.HomologeneID_hash.containsKey(NCBIGeneID2))) continue;
                                                HomoidSTR.add(GNormPlus.HomologeneID_hash.get(NCBIGeneID2));
                                                continue;
                                            }
                                            if (!mtmp5.find()) continue;
                                            Method_SA2 = mtmp5.group(1);
                                            TaxonomyID2 = mtmp5.group(2);
                                            NCBIGeneID2 = mtmp5.group(3);
                                            if (identifierSTR.contains(NCBIGeneID2)) continue;
                                            identifierSTR.add(NCBIGeneID2);
                                        }
                                        Object idSTR = "";
                                        for (int x = 0; x < identifierSTR.size(); ++x) {
                                            idSTR = ((String)idSTR).equals("") ? (String)identifierSTR.get(x) : (String)idSTR + ";" + (String)identifierSTR.get(x);
                                        }
                                        AnnoInfons.put("NCBI Gene", idSTR);
                                        Object pidSTR = "";
                                        for (int x = 0; x < ProteinidSTR.size(); ++x) {
                                            pidSTR = ((String)pidSTR).equals("") ? (String)ProteinidSTR.get(x) : (String)pidSTR + ";" + (String)ProteinidSTR.get(x);
                                        }
                                        if (!((String)pidSTR).equals("")) {
                                            AnnoInfons.put("UniProt", pidSTR);
                                        }
                                        Object hidSTR = "";
                                        for (int x = 0; x < HomoidSTR.size(); ++x) {
                                            hidSTR = ((String)hidSTR).equals("") ? (String)HomoidSTR.get(x) : (String)hidSTR + ";" + (String)HomoidSTR.get(x);
                                        }
                                        if (!((String)hidSTR).equals("")) {
                                            AnnoInfons.put("NCBI Homologene", hidSTR);
                                        }
                                    }
                                }
                            } else if (type.matches("(Species|Genus|Strain)")) {
                                AnnoInfons.put("type", type);
                                AnnoInfons.put("NCBI Taxonomy", identifier);
                            } else if (type.matches("Cell")) {
                                AnnoInfons.put("type", "CellLine");
                                AnnoInfons.put("NCBI Taxonomy", identifier);
                            } else {
                                AnnoInfons.put("Identifier", identifier);
                            }
                        } else {
                            AnnoInfons.put("Identifier", identifier);
                        }
                    }
                    biocAnnotation.setInfons(AnnoInfons);
                    BioCLocation location = new BioCLocation(start + passage_Offset, last - start);
                    biocAnnotation.setLocations(Set.of(location));
                    biocAnnotation.setText(mention2);
                    biocAnnotation.setID("" + annotation_count);
                    ++annotation_count;
                    if (Final) {
                        if (!AnnoInfons.containsKey("Identifier") && !AnnoInfons.containsKey("NCBI Homologene") && !AnnoInfons.containsKey("NCBI Gene") && !AnnoInfons.containsKey("NCBI Taxonomy") && !type.equals("FamilyName")) continue;
                        passage_output.addAnnotation(biocAnnotation);
                        continue;
                    }
                    passage_output.addAnnotation(biocAnnotation);
                }
                document_output.addPassage(passage_output);
                ++j;
            }
            biocCollection_output.addDocument(document_output);
            BioCOutputFormat.writeDocument(document_output);
            ++i;
        }
        BioCOutputFormat.close();
    }
}

