/*
 * Decompiled with CFR 0.152.
 */
package GNormPluslib;

import GNormPluslib.Tree;
import GNormPluslib.TreeNode;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PrefixTree {
    private Tree Tr = new Tree();
    public static HashMap<String, String> StopWord_hash = new HashMap();

    public void Hash2Tree(HashMap<String, String> ID2Names) {
        for (String ID : ID2Names.keySet()) {
            String[] NameColumn = ID2Names.get(ID).split("\\|");
            for (int i = 0; i < NameColumn.length; ++i) {
                this.Tr.insertMention(NameColumn[i], ID);
            }
        }
    }

    public void Dictionary2Tree_Combine(String Filename, String StopWords, String MentionType) {
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(StopWords), "UTF-8"));
            String line = "";
            while ((line = br.readLine()) != null) {
                StopWord_hash.put(line, "StopWord");
            }
            br.close();
            BufferedReader inputfile = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(Filename), "UTF-8"));
            line = "";
            while ((line = inputfile.readLine()) != null) {
                String[] Column = line.split("\t");
                if (Column.length <= 1) continue;
                Column[0] = Column[0].replace("species:ncbi:", "");
                Column[1] = Column[1].replaceAll(" strain=", " ");
                Column[1] = Column[1].replaceAll("[\\W\\-\\_](str\\.|strain|substr\\.|substrain|var\\.|variant|subsp\\.|subspecies|pv\\.|pathovars|pathovar|br\\.|biovar)[\\W\\-\\_]", " ");
                Column[1] = Column[1].replaceAll("[\\(\\)]", " ");
                String[] SpNameColumn = Column[1].split("\\|");
                for (int i = 0; i < SpNameColumn.length; ++i) {
                    String tmp = SpNameColumn[i];
                    tmp = tmp.replaceAll("[\\W\\-\\_]", "");
                    if (MentionType.equals("Species") && !SpNameColumn[i].substring(0, 1).matches("[\\W\\-\\_]") && !SpNameColumn[i].matches("a[\\W\\-\\_].*") && tmp.length() >= 3) {
                        boolean stopword_boolean = false;
                        for (String stopword_RegEx : StopWord_hash.keySet()) {
                            Pattern ptmp = Pattern.compile("^" + stopword_RegEx + "$");
                            Matcher mtmp = ptmp.matcher(SpNameColumn[i].toLowerCase());
                            if (!mtmp.find()) continue;
                            stopword_boolean = true;
                        }
                        if (stopword_boolean) continue;
                        this.Tr.insertMention(SpNameColumn[i], Column[0]);
                        continue;
                    }
                    if (MentionType.equals("Gene") && !SpNameColumn[i].substring(0, 1).matches("[\\W\\-\\_]") && tmp.length() >= 3) {
                        if (StopWord_hash.containsKey(SpNameColumn[i].toLowerCase())) continue;
                        this.Tr.insertMention(SpNameColumn[i], Column[0]);
                        continue;
                    }
                    if (MentionType.equals("Cell") && !SpNameColumn[i].substring(0, 1).matches("[\\W\\-\\_]") && tmp.length() >= 3) {
                        if (StopWord_hash.containsKey(SpNameColumn[i].toLowerCase())) continue;
                        this.Tr.insertMention(SpNameColumn[i], Column[0]);
                        continue;
                    }
                    if (SpNameColumn[i].substring(0, 1).matches("[\\W\\-\\_]") || tmp.length() < 3 || StopWord_hash.containsKey(SpNameColumn[i].toLowerCase())) continue;
                    this.Tr.insertMention(SpNameColumn[i], Column[0]);
                }
            }
            inputfile.close();
        }
        catch (IOException e1) {
            System.out.println("[Dictionary2Tree_Combine]: Input file is not exist.");
        }
    }

    public void Dictionary2Tree_UniqueGene(String Filename, String StopWords, String Preifx) {
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(StopWords), "UTF-8"));
            String line = "";
            while ((line = br.readLine()) != null) {
                StopWord_hash.put(line, "StopWord");
            }
            br.close();
            BufferedReader inputfile = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(Filename), "UTF-8"));
            line = "";
            while ((line = inputfile.readLine()) != null) {
                String[] Column = line.split("\t");
                if (Column.length <= 1 || StopWord_hash.containsKey(Column[0].toLowerCase())) continue;
                if (Preifx.equals("")) {
                    this.Tr.insertMention(Column[0], Column[1]);
                    continue;
                }
                if (Preifx.equals("Num") && Column[0].matches("[0-9].*")) {
                    this.Tr.insertMention(Column[0], Column[1]);
                    continue;
                }
                if (Preifx.equals("AZNum") && Column[0].matches("[a-z][0-9].*")) {
                    this.Tr.insertMention(Column[0], Column[1]);
                    continue;
                }
                if (Preifx.equals("lo") && Column[0].length() > 2 && Column[0].substring(0, 2).equals(Preifx)) {
                    if (Column[0].matches("loc[0-9]+")) continue;
                    this.Tr.insertMention(Column[0], Column[1]);
                    continue;
                }
                if (Preifx.equals("un") && Column[0].length() > 2 && Column[0].substring(0, 2).equals(Preifx)) {
                    if (Column[0].length() >= 6 && Column[0].substring(0, 6).equals("unchar")) continue;
                    this.Tr.insertMention(Column[0], Column[1]);
                    continue;
                }
                if (Column[0].length() <= 2 || !Column[0].substring(0, 2).equals(Preifx)) continue;
                this.Tr.insertMention(Column[0], Column[1]);
            }
            inputfile.close();
        }
        catch (IOException e1) {
            System.out.println("[Dictionary2Tree_UniqueGene]: Input file is not exist.");
        }
    }

    public void Dictionary2Tree_UniqueSpecies(String Filename, String StopWords, String Preifx) {
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(StopWords), "UTF-8"));
            String line = "";
            while ((line = br.readLine()) != null) {
                StopWord_hash.put(line, "StopWord");
            }
            br.close();
            BufferedReader inputfile = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(Filename), "UTF-8"));
            line = "";
            while ((line = inputfile.readLine()) != null) {
                String mention_tmp;
                String mention_rev;
                String[] Column = line.split("\t");
                if (Column.length <= 1 || StopWord_hash.containsKey(Column[0].toLowerCase())) continue;
                if (Preifx.equals("")) {
                    if (Column[0].matches(".*[\\W\\-\\_](str\\.|strain|substr\\.|substrain|var\\.|variety|variant|subsp\\.|subspecies|pv\\.|pathovars|pathovar|br\\.|biovar)[\\W\\-\\_].*")) {
                        mention_rev = Column[0].replaceAll("[\\W\\-\\_](str\\.|strain|substr\\.|substrain|var\\.|variety|variant|subsp\\.|subspecies|pv\\.|pathovars|pathovar|br\\.|biovar)[\\W\\-\\_]", " ");
                        mention_tmp = mention_rev.replaceAll("[\\W\\-\\_]", "");
                        if (mention_tmp.length() < 10) continue;
                        this.Tr.insertMention(mention_rev, Column[1]);
                        continue;
                    }
                    this.Tr.insertMention(Column[0], Column[1]);
                    continue;
                }
                if (Column[0].matches("[0-9][0-9].*")) {
                    if (!Preifx.equals("Num")) continue;
                    if (Column[0].matches(".*[\\W\\-\\_](str\\.|strain|substr\\.|substrain|var\\.|variety|variant|subsp\\.|subspecies|pv\\.|pathovars|pathovar|br\\.|biovar)[\\W\\-\\_].*")) {
                        mention_rev = Column[0].replaceAll("[\\W\\-\\_](str\\.|strain|substr\\.|substrain|var\\.|variety|variant|subsp\\.|subspecies|pv\\.|pathovars|pathovar|br\\.|biovar)[\\W\\-\\_]", " ");
                        mention_tmp = mention_rev.replaceAll("[\\W\\-\\_]", "");
                        if (mention_tmp.length() < 10) continue;
                        this.Tr.insertMention(mention_rev, Column[1]);
                        continue;
                    }
                    this.Tr.insertMention(Column[0], Column[1]);
                    continue;
                }
                if (Column[0].matches("[a-z][a-z].*")) {
                    if (Column[0].length() <= 2 || !Column[0].substring(0, 2).equals(Preifx)) continue;
                    if (Column[0].matches(".*[\\W\\-\\_](str\\.|strain|substr\\.|substrain|var\\.|variety|variant|subsp\\.|subspecies|pv\\.|pathovars|pathovar|br\\.|biovar)[\\W\\-\\_].*")) {
                        mention_rev = Column[0].replaceAll("[\\W\\-\\_](str\\.|strain|substr\\.|substrain|var\\.|variety|variant|subsp\\.|subspecies|pv\\.|pathovars|pathovar|br\\.|biovar)[\\W\\-\\_]", " ");
                        mention_tmp = mention_rev.replaceAll("[\\W\\-\\_]", "");
                        if (mention_tmp.length() < 10) continue;
                        this.Tr.insertMention(mention_rev, Column[1]);
                        continue;
                    }
                    this.Tr.insertMention(Column[0], Column[1]);
                    continue;
                }
                if (!Preifx.equals("Others")) continue;
                if (Column[0].matches(".*[\\W\\-\\_](str\\.|strain|substr\\.|substrain|var\\.|variety|variant|subsp\\.|subspecies|pv\\.|pathovars|pathovar|br\\.|biovar)[\\W\\-\\_].*")) {
                    mention_rev = Column[0].replaceAll("[\\W\\-\\_](str\\.|strain|substr\\.|substrain|var\\.|variety|variant|subsp\\.|subspecies|pv\\.|pathovars|pathovar|br\\.|biovar)[\\W\\-\\_]", " ");
                    mention_tmp = mention_rev.replaceAll("[\\W\\-\\_]", "");
                    if (mention_tmp.length() < 10) continue;
                    this.Tr.insertMention(mention_rev, Column[1]);
                    continue;
                }
                this.Tr.insertMention(Column[0], Column[1]);
            }
            inputfile.close();
        }
        catch (IOException e1) {
            System.out.println("[Dictionary2Tree_UniqueGene]: Input file is not exist.");
        }
    }

    public void TreeFile2Tree(String Filename) {
        try {
            BufferedReader inputfile = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(Filename), "UTF-8"));
            String line = "";
            int count = 0;
            while ((line = inputfile.readLine()) != null) {
                String[] Anno = line.split("\t");
                if (Anno.length < 2) {
                    System.out.println(count + "\t" + line);
                }
                String LocationInTree = Anno[0];
                String token = Anno[1];
                String identifier = "";
                if (Anno.length == 3) {
                    identifier = Anno[2];
                }
                String[] LocationsInTree = LocationInTree.split("-");
                TreeNode tmp = this.Tr.root;
                for (int i = 0; i < LocationsInTree.length - 1; ++i) {
                    tmp = tmp.links.get(Integer.parseInt(LocationsInTree[i]) - 1);
                }
                tmp.InsertToken(token, identifier);
                ++count;
            }
            inputfile.close();
        }
        catch (IOException e1) {
            System.out.println("[TreeFile2Tee]: Input file: " + Filename + " is not exist.");
        }
    }

    public String MentionMatch(String Mentions) {
        ArrayList location = new ArrayList();
        int m = 0;
        String[] Menlist = Mentions.split("\\|");
        if (m < Menlist.length) {
            int i;
            String Mention = Menlist[m];
            String Mention_lc = Mention.toLowerCase();
            Mention_lc = Mention_lc.replaceAll("[\\W\\-\\_]+", "");
            Mention_lc = Mention_lc.replaceAll("([0-9])([a-z])", "$1 $2");
            Mention_lc = Mention_lc.replaceAll("([a-z])([0-9])", "$1 $2");
            String[] Tkns = Mention_lc.split(" ");
            int PrefixTranslation = 0;
            boolean find = false;
            TreeNode tmp = this.Tr.root;
            for (i = 0; i < Tkns.length && tmp.CheckChild(Tkns[i], PrefixTranslation) >= 0; ++i) {
                if (i == Tkns.length - 1) {
                    PrefixTranslation = 1;
                }
                tmp = tmp.links.get(tmp.CheckChild(Tkns[i], PrefixTranslation));
                find = true;
            }
            if (find) {
                if (i == Tkns.length) {
                    if (!tmp.Concept.equals("")) {
                        return tmp.Concept;
                    }
                    return "-1";
                }
                return "-2";
            }
            return "-3";
        }
        return "-3";
    }

    public String MentionMatch_species(String Mentions) {
        ArrayList location = new ArrayList();
        int m = 0;
        String[] Menlist = Mentions.split("\\|");
        if (m < Menlist.length) {
            int i;
            String Mention = Menlist[m];
            String Mention_lc = Mention.toLowerCase();
            Mention_lc = Mention_lc.replaceAll("[\\W\\-\\_]+", " ");
            Mention_lc = Mention_lc.replaceAll("([0-9])([a-z])", "$1 $2");
            Mention_lc = Mention_lc.replaceAll("([a-z])([0-9])", "$1 $2");
            Mention_lc = Mention_lc.replaceAll("^[ ]+", "");
            Mention_lc = Mention_lc.replaceAll("[ ]+$", "");
            String[] Tkns = Mention_lc.split(" ");
            int PrefixTranslation = 0;
            boolean find = false;
            TreeNode tmp = this.Tr.root;
            for (i = 0; i < Tkns.length && tmp.CheckChild(Tkns[i], PrefixTranslation) >= 0; ++i) {
                if (i == Tkns.length - 1) {
                    PrefixTranslation = 1;
                }
                tmp = tmp.links.get(tmp.CheckChild(Tkns[i], PrefixTranslation));
                find = true;
            }
            if (find) {
                if (i == Tkns.length) {
                    if (!tmp.Concept.equals("")) {
                        return tmp.Concept;
                    }
                    return "-1";
                }
                return "-2";
            }
            return "-3";
        }
        return "-3";
    }

    public ArrayList<String> SearchMentionLocation(String Doc, String ConceptType) {
        ArrayList<String> location = new ArrayList<String>();
        Object Doc_org = Doc = (String)Doc + " XXXX XXXX";
        Object Doc_lc = Doc = ((String)Doc).toLowerCase();
        Doc = ((String)Doc).replaceAll("([0-9])([A-Za-z])", "$1 $2");
        Doc = ((String)Doc).replaceAll("([A-Za-z])([0-9])", "$1 $2");
        Doc = ((String)Doc).replaceAll("[\\W^;:,]+", " ");
        String[] DocTkns = ((String)Doc).split(" ");
        int Offset = 0;
        int Start2 = 0;
        int Last = 0;
        int FirstTime = 0;
        while (((String)Doc_lc).length() > 0 && ((String)Doc_lc).substring(0, 1).matches("[\\W]")) {
            Doc_lc = ((String)Doc_lc).substring(1);
            ++Offset;
        }
        for (int i = 0; i < DocTkns.length; ++i) {
            int pre_i = i;
            int pre_Start = Start2;
            int pre_Last = Last;
            Object pre_Doc_lc = Doc_lc;
            int pre_Offset = Offset;
            TreeNode tmp = this.Tr.root;
            boolean find = false;
            int PrefixTranslation = 2;
            if (ConceptType.equals("Species")) {
                PrefixTranslation = 3;
            }
            int ConceptFound = i;
            Object ConceptFound_STR = "";
            int FirstTime_while = -1;
            while (tmp.CheckChild(DocTkns[i], PrefixTranslation) >= 0) {
                ++FirstTime_while;
                tmp = tmp.links.get(tmp.CheckChild(DocTkns[i], PrefixTranslation));
                if (Start2 == 0 && FirstTime > 0) {
                    Start2 = Offset;
                }
                if (((String)Doc_lc).length() >= DocTkns[i].length() && ((String)Doc_lc).substring(0, DocTkns[i].length()).equals(DocTkns[i]) && DocTkns[i].length() > 0) {
                    Doc_lc = ((String)Doc_lc).substring(DocTkns[i].length());
                    Offset += DocTkns[i].length();
                }
                Last = Offset;
                while (((String)Doc_lc).length() > 0 && ((String)Doc_lc).substring(0, 1).matches("[\\W]")) {
                    Doc_lc = ((String)Doc_lc).substring(1);
                    ++Offset;
                }
                if (ConceptType.equals("Species") && ++i < DocTkns.length - 3 && DocTkns[i].matches("(str|strain|substr|substrain|subspecies|subsp|var|variant|pathovars|pv|biovar|bv)")) {
                    Doc_lc = ((String)Doc_lc).substring(DocTkns[i].length());
                    Last = Offset += DocTkns[i].length();
                    while (((String)Doc_lc).length() > 0 && ((String)Doc_lc).substring(0, 1).matches("[\\W]")) {
                        Doc_lc = ((String)Doc_lc).substring(1);
                        ++Offset;
                    }
                    ++i;
                }
                if (!tmp.Concept.equals("") && Last - Start2 > 0 && Last < ((String)Doc_org).length()) {
                    ConceptFound = i;
                    ConceptFound_STR = Start2 + "\t" + Last + "\t" + ((String)Doc_org).substring(Start2, Last) + "\t" + tmp.Concept;
                }
                find = true;
                if (i >= DocTkns.length) break;
                if (i == DocTkns.length - 1) {
                    PrefixTranslation = 2;
                }
                if (FirstTime_while != 0) continue;
                pre_i = i;
                pre_Start = Start2;
                pre_Last = Last;
                pre_Doc_lc = Doc_lc;
                pre_Offset = Offset;
            }
            if (find) {
                if (!tmp.Concept.equals("")) {
                    if (Last < ((String)Doc_org).length() && Last > Start2) {
                        location.add(Start2 + "\t" + Last + "\t" + ((String)Doc_org).substring(Start2, Last) + "\t" + tmp.Concept);
                    }
                } else {
                    if (!((String)ConceptFound_STR).equals("")) {
                        location.add((String)ConceptFound_STR);
                        i = ConceptFound + 1;
                    }
                    if (FirstTime_while >= 1) {
                        i = pre_i;
                        Start2 = pre_Start;
                        Last = pre_Last;
                        Doc_lc = pre_Doc_lc;
                        Offset = pre_Offset;
                    }
                }
                Start2 = 0;
                Last = 0;
                if (i > 0) {
                    --i;
                }
                ConceptFound = i;
                ConceptFound_STR = "";
            } else {
                if (FirstTime_while >= 1 && tmp.Concept.equals("")) {
                    i = pre_i;
                    Start2 = pre_Start;
                    Last = pre_Last;
                    Doc_lc = pre_Doc_lc;
                    Offset = pre_Offset;
                }
                if (((String)Doc_lc).length() >= DocTkns[i].length() && ((String)Doc_lc).substring(0, DocTkns[i].length()).equals(DocTkns[i]) && DocTkns[i].length() > 0) {
                    Doc_lc = ((String)Doc_lc).substring(DocTkns[i].length());
                    Offset += DocTkns[i].length();
                }
            }
            while (((String)Doc_lc).length() > 0 && ((String)Doc_lc).substring(0, 1).matches("[\\W]")) {
                Doc_lc = ((String)Doc_lc).substring(1);
                ++Offset;
            }
            ++FirstTime;
        }
        return location;
    }

    public String PrintTree() {
        return this.Tr.PrintTree_preorder(this.Tr.root, "");
    }

    public void SaveTree(String outputfile) throws IOException {
        BufferedWriter fr = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputfile), "UTF-8"));
        this.Tr.SaveTree_preorder(this.Tr.root, "", fr);
        fr.close();
    }

    public void insertMention(String Mention, String Identifier) {
        this.Tr.insertMention(Mention, Identifier);
    }
}

