/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.utilities.aether;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import de.julielab.utilities.aether.IORuntimeException;
import de.julielab.utilities.aether.MavenArtifact;
import de.julielab.utilities.aether.MavenConstants;
import de.julielab.utilities.aether.MavenException;
import de.julielab.utilities.aether.MavenRepositoryUtilities;
import de.julielab.utilities.aether.metadata.MetadataFile;
import de.julielab.utilities.aether.metadata.SnapshotVersion;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.CollectResult;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.internal.impl.Maven2RepositoryLayoutFactory;
import org.eclipse.aether.metadata.DefaultMetadata;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.aether.resolution.MetadataRequest;
import org.eclipse.aether.resolution.MetadataResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.spi.connector.layout.RepositoryLayout;
import org.eclipse.aether.transfer.NoRepositoryLayoutException;
import org.eclipse.aether.version.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AetherUtilities {
    private static final Logger log = LoggerFactory.getLogger(AetherUtilities.class);

    private AetherUtilities() {
    }

    public static Optional<List<Checksum>> getRemoteChecksums(MavenArtifact artifact) throws MavenException {
        try {
            RepositorySystemSession session = MavenRepositoryUtilities.newSession(MavenRepositoryUtilities.newRepositorySystem(), MavenConstants.LOCAL_REPO);
            if (artifact.asAetherArtifact().isSnapshot()) {
                return AetherUtilities.getRemoteChecksumsOfSnapshotArtifact(artifact, session);
            }
            return AetherUtilities.getRemoteChecksumsOfReleaseArtifact(artifact, session);
        }
        catch (SettingsBuildingException | NoRepositoryLayoutException e) {
            throw new MavenException(e);
        }
    }

    private static Optional<List<Checksum>> getRemoteChecksumsOfReleaseArtifact(MavenArtifact artifact, RepositorySystemSession session) throws SettingsBuildingException, NoRepositoryLayoutException, MavenException {
        ArrayList<Checksum> ret = new ArrayList<Checksum>();
        Maven2RepositoryLayoutFactory layoutFactory = new Maven2RepositoryLayoutFactory();
        List<RemoteRepository> repositories = MavenRepositoryUtilities.getEffectiveRepositories(session);
        for (RemoteRepository repository : repositories) {
            RepositoryLayout layout = layoutFactory.newInstance(session, repository);
            List checksums = layout.getChecksums(artifact.asAetherArtifact(), false, layout.getLocation(artifact.asAetherArtifact(), false));
            for (RepositoryLayout.Checksum cs : checksums) {
                URI checksumUri = URI.create(repository.getUrl() + "/" + cs.getLocation().toString());
                try (BufferedReader br = new BufferedReader(new InputStreamReader(checksumUri.toURL().openStream()));){
                    Optional<String> any = br.lines().filter(s -> !s.isEmpty()).findAny();
                    if (!any.isPresent()) {
                        log.warn("Checksum file at {} does not have any content", (Object)checksumUri);
                        continue;
                    }
                    ret.add(new Checksum(any.get(), cs.getAlgorithm(), repository));
                }
                catch (FileNotFoundException e) {
                    log.debug("Checksum file for artifact {} was not found at {}", (Object)artifact, (Object)checksumUri);
                }
                catch (IOException e) {
                    if (e.getMessage().contains("code: 401")) {
                        log.warn("Access for URI {} was denied when trying to retrieve checksum of artifact {}", (Object)checksumUri, (Object)artifact);
                        continue;
                    }
                    throw new MavenException(e);
                }
            }
        }
        return ret.isEmpty() ? Optional.empty() : Optional.of(ret);
    }

    private static Optional<List<Checksum>> getRemoteChecksumsOfSnapshotArtifact(MavenArtifact artifact, RepositorySystemSession session) throws MavenException {
        ArrayList<Checksum> ret = new ArrayList<Checksum>();
        Maven2RepositoryLayoutFactory layoutFactory = new Maven2RepositoryLayoutFactory();
        try {
            List<MetadataResult> metadataResults = AetherUtilities.getRemoteArtifactMetadata(artifact);
            List filteredMetadataResults = metadataResults.stream().filter(result -> !result.isMissing()).collect(Collectors.toList());
            if (filteredMetadataResults.isEmpty()) {
                try {
                    AetherUtilities.getArtifactByAether(artifact, MavenConstants.LOCAL_REPO, false);
                }
                catch (MavenException e) {
                    if (e.getCause() instanceof ArtifactResolutionException) {
                        return Optional.empty();
                    }
                    throw e;
                }
                log.info("No existing meta data could be found for artifact {}, checking if the artifact already existing in any repository", (Object)artifact);
                throw new IllegalStateException("The requested snapshot artifact " + artifact + " has no meta data on any server in " + metadataResults.stream().map(MetadataResult::getRequest).map(MetadataRequest::getRepository).map(RemoteRepository::toString).collect(Collectors.joining(", ")) + ". This case is currently not supported by this code. A workaround needs to be added.");
            }
            XmlMapper xmlMapper = new XmlMapper();
            for (MetadataResult result2 : filteredMetadataResults) {
                Metadata metadata = result2.getMetadata();
                RemoteRepository repository = result2.getRequest().getRepository();
                MetadataFile metadataFile = (MetadataFile)xmlMapper.readValue(metadata.getFile(), MetadataFile.class);
                Optional<SnapshotVersion> svOpt = metadataFile.getVersioning().getSnapshotVersions().stream().filter(sv -> sv.hasExtension(artifact.getPackaging())).findAny();
                if (!svOpt.isPresent()) {
                    throw new IllegalArgumentException("Could not find the artifact metadata for artifact " + artifact + " by extension " + artifact.getPackaging());
                }
                RepositoryLayout layout = layoutFactory.newInstance(session, repository);
                SnapshotVersion snapshotVersion = svOpt.get();
                Artifact a = metadataFile.getCorrespondingSnapshotArtifact(snapshotVersion);
                List checksums = layout.getChecksums(a, false, layout.getLocation(a, false));
                for (RepositoryLayout.Checksum cs : checksums) {
                    URI checksumUri = URI.create(repository.getUrl() + "/" + cs.getLocation().toString());
                    try (BufferedReader br = new BufferedReader(new InputStreamReader(checksumUri.toURL().openStream()));){
                        Optional<String> any = br.lines().filter(s -> !s.isEmpty()).findAny();
                        if (!any.isPresent()) {
                            log.warn("Checksum file at {} does not have any content", (Object)checksumUri);
                            continue;
                        }
                        ret.add(new Checksum(any.get(), cs.getAlgorithm(), repository));
                    }
                }
            }
        }
        catch (NoRepositoryLayoutException e) {
            e.printStackTrace();
        }
        catch (JsonParseException e) {
            e.printStackTrace();
        }
        catch (JsonMappingException e) {
            e.printStackTrace();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return Optional.of(ret);
    }

    public static List<MetadataResult> getRemoteArtifactMetadata(MavenArtifact a) throws MavenException {
        try {
            RepositorySystem repositorySystem = MavenRepositoryUtilities.newRepositorySystem();
            RepositorySystemSession session = MavenRepositoryUtilities.newSession(repositorySystem, MavenConstants.LOCAL_REPO);
            DefaultMetadata requestMetadata = new DefaultMetadata(a.getGroupId(), a.getArtifactId(), a.getVersion(), "maven-metadata.xml", Metadata.Nature.RELEASE_OR_SNAPSHOT);
            List<RemoteRepository> repositories = MavenRepositoryUtilities.getEffectiveRepositories(session);
            ArrayList<MetadataRequest> requests = new ArrayList<MetadataRequest>();
            for (RemoteRepository rr : repositories) {
                requests.add(new MetadataRequest((Metadata)requestMetadata, rr, null));
            }
            List artifactResult = repositorySystem.resolveMetadata(session, requests);
            return artifactResult;
        }
        catch (SettingsBuildingException e) {
            throw new MavenException(e);
        }
    }

    public static MavenArtifact getArtifactByAether(MavenArtifact artifact) throws MavenException {
        return AetherUtilities.getArtifactByAether(artifact, MavenConstants.LOCAL_REPO);
    }

    public static MavenArtifact getArtifactByAether(MavenArtifact a, File localRepository) throws MavenException {
        return AetherUtilities.getArtifactByAether(a, localRepository, true);
    }

    public static MavenArtifact getArtifactByAether(MavenArtifact a, File localRepository, boolean searchLocally) throws MavenException {
        DefaultArtifact artifact;
        try {
            RepositorySystem repositorySystem = MavenRepositoryUtilities.newRepositorySystem();
            RepositorySystemSession session = MavenRepositoryUtilities.newSession(repositorySystem, localRepository);
            artifact = new DefaultArtifact(a.getGroupId(), a.getArtifactId(), a.getClassifier(), a.getPackaging(), a.getVersion());
            ArtifactRequest artifactRequest = new ArtifactRequest();
            artifactRequest.setArtifact((Artifact)artifact);
            List<RemoteRepository> repositories = MavenRepositoryUtilities.getEffectiveRepositories(session);
            artifactRequest.setRepositories(repositories);
            File localArtifactFile = new File(localRepository.getAbsolutePath() + File.separator + session.getLocalRepositoryManager().getPathForLocalArtifact((Artifact)artifact));
            if (searchLocally && localArtifactFile.exists()) {
                MavenArtifact ret = new MavenArtifact((Artifact)artifact);
                ret.setFile(localArtifactFile);
                return ret;
            }
            ArtifactResult artifactResult = repositorySystem.resolveArtifact(session, artifactRequest);
            artifact = artifactResult.getArtifact();
        }
        catch (ArtifactResolutionException e) {
            throw new MavenException(e);
        }
        catch (SettingsBuildingException e) {
            throw new MavenException(e);
        }
        return new MavenArtifact((Artifact)artifact);
    }

    public static void storeArtifactWithDependencies(MavenArtifact requestedArtifact, File libDir) throws MavenException {
        log.trace("Storing artifact {} with all its dependencies to {}", (Object)requestedArtifact, (Object)libDir);
        Stream<Artifact> dependencies = AetherUtilities.getDependencies(requestedArtifact);
        if (!libDir.exists()) {
            libDir.mkdirs();
        }
        Consumer<Artifact> writer = a -> {
            File destination = new File(libDir.getAbsolutePath() + File.separator + a.getFile().getName());
            try {
                log.trace("Now writing: {} to {}", a, (Object)destination);
                Files.copy(a.getFile().toPath(), destination.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        };
        dependencies.forEach(writer);
    }

    public static void storeArtifactsWithDependencies(Stream<MavenArtifact> requestedArtifacts, File libDir) throws MavenException {
        AetherUtilities.storeArtifactsWithDependencies(null, requestedArtifacts, libDir);
    }

    public static void storeArtifactsWithDependencies(MavenArtifact dependencyTreeRoot, Stream<MavenArtifact> requestedArtifacts, File libDir) throws MavenException {
        List artifactList = requestedArtifacts.collect(Collectors.toList());
        log.trace("Storing artifacts {} with all its dependencies to {}", artifactList, (Object)libDir);
        Stream<Artifact> dependencies = AetherUtilities.getDependencies(dependencyTreeRoot, artifactList.stream());
        if (!libDir.exists()) {
            libDir.mkdirs();
        }
        Consumer<Artifact> writer = a -> {
            File destination = new File(libDir.getAbsolutePath() + File.separator + a.getFile().getName());
            try {
                log.trace("Now writing: {} to {}", a, (Object)destination);
                Files.copy(a.getFile().toPath(), destination.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        };
        dependencies.forEach(writer);
    }

    public static Stream<Artifact> getDependencies(MavenArtifact requestedArtifact) throws MavenException {
        return AetherUtilities.getDependencies(requestedArtifact, false);
    }

    public static Stream<String> getVersions(MavenArtifact requestedArtifact) throws MavenException {
        return AetherUtilities.getVersions(requestedArtifact, "0", String.valueOf(Integer.MAX_VALUE), true, true);
    }

    public static void main(String[] args) throws MavenException {
        MavenArtifact ma = new MavenArtifact();
        ma.setArtifactId("jcore-biosem-ae");
        ma.setGroupId("de.julielab");
        AetherUtilities.getVersions(ma).forEach(System.out::println);
    }

    public static Stream<String> getVersions(MavenArtifact requestedArtifact, String lowerBound, String upperBound, boolean lowerInclusive, boolean upperInclusive) throws MavenException {
        RepositorySystemSession session;
        RepositorySystem repositorySystem = MavenRepositoryUtilities.newRepositorySystem();
        try {
            session = MavenRepositoryUtilities.newSession(repositorySystem, MavenConstants.LOCAL_REPO);
        }
        catch (SettingsBuildingException e) {
            throw new MavenException(e);
        }
        String groupId = requestedArtifact.getGroupId();
        String artifactId = requestedArtifact.getArtifactId();
        String classifier = requestedArtifact.getClassifier();
        String version = requestedArtifact.getVersion();
        String packaging = requestedArtifact.getPackaging();
        String lower = lowerInclusive ? "[" : "(";
        String upper = upperInclusive ? "]" : ")";
        String range = lower + lowerBound + ", " + upperBound + upper;
        DefaultArtifact artifact = new DefaultArtifact(groupId, artifactId, classifier, packaging, range);
        try {
            VersionRangeRequest versionRangeRequest = new VersionRangeRequest((Artifact)artifact, MavenRepositoryUtilities.getEffectiveRepositories(session), null);
            VersionRangeResult result = repositorySystem.resolveVersionRange(session, versionRangeRequest);
            return result.getVersions().stream().map(Version::toString);
        }
        catch (SettingsBuildingException e) {
            throw new MavenException(e);
        }
        catch (VersionRangeResolutionException e) {
            e.printStackTrace();
            return Stream.empty();
        }
    }

    public static String getNewestVersion(MavenArtifact requestedArtifact) throws MavenException {
        List versions = AetherUtilities.getVersions(requestedArtifact).collect(Collectors.toList());
        if (!versions.isEmpty()) {
            return (String)versions.get(versions.size() - 1);
        }
        return null;
    }

    public static Stream<Artifact> getDependencies(Stream<MavenArtifact> requestedArtifacts) throws MavenException {
        return AetherUtilities.getDependencies(null, requestedArtifacts);
    }

    public static Stream<Artifact> getDependencies(MavenArtifact dependencyTreeRoot, Stream<MavenArtifact> requestedArtifacts) throws MavenException {
        RepositorySystemSession session;
        RepositorySystem repositorySystem = MavenRepositoryUtilities.newRepositorySystem();
        try {
            session = MavenRepositoryUtilities.newSession(repositorySystem, MavenConstants.LOCAL_REPO);
        }
        catch (SettingsBuildingException e) {
            throw new MavenException(e);
        }
        List components = requestedArtifacts.map(a -> new DefaultArtifact(a.getGroupId(), a.getArtifactId(), a.getClassifier(), a.getPackaging(), a.getVersion())).map(a -> new Dependency((Artifact)a, "compile")).collect(Collectors.toList());
        try {
            Dependency root = dependencyTreeRoot != null ? new Dependency(dependencyTreeRoot.asAetherArtifact(), "compile") : null;
            CollectRequest collectRequest = new CollectRequest(root, components, MavenRepositoryUtilities.getEffectiveRepositories(session));
            CollectResult collectResult = repositorySystem.collectDependencies(session, collectRequest);
            DependencyNode node = collectResult.getRoot();
            DependencyRequest dependencyRequest = new DependencyRequest();
            dependencyRequest.setRoot(node);
            DependencyResult dependencyResult = repositorySystem.resolveDependencies(session, dependencyRequest);
            return dependencyResult.getArtifactResults().stream().map(ArtifactResult::getArtifact);
        }
        catch (SettingsBuildingException e) {
            e.printStackTrace();
        }
        catch (DependencyCollectionException e) {
            e.printStackTrace();
        }
        catch (DependencyResolutionException e) {
            e.printStackTrace();
        }
        return Stream.empty();
    }

    public static Stream<Artifact> getDependencies(MavenArtifact requestedArtifact, boolean recursiveCall) throws MavenException {
        RepositorySystemSession session;
        RepositorySystem repositorySystem = MavenRepositoryUtilities.newRepositorySystem();
        try {
            session = MavenRepositoryUtilities.newSession(repositorySystem, MavenConstants.LOCAL_REPO);
        }
        catch (SettingsBuildingException e) {
            throw new MavenException(e);
        }
        String groupId = requestedArtifact.getGroupId();
        String artifactId = requestedArtifact.getArtifactId();
        String classifier = requestedArtifact.getClassifier();
        String version = requestedArtifact.getVersion();
        String packaging = requestedArtifact.getPackaging();
        DefaultArtifact artifact = new DefaultArtifact(groupId, artifactId, classifier, packaging, version);
        Dependency dependency = new Dependency((Artifact)artifact, "compile");
        DependencyResult dependencyResult = null;
        try {
            CollectRequest collectRequest = new CollectRequest();
            collectRequest.setRoot(dependency);
            collectRequest.setRepositories(MavenRepositoryUtilities.getEffectiveRepositories(session));
            CollectResult collectResult = repositorySystem.collectDependencies(session, collectRequest);
            DependencyNode node = collectResult.getRoot();
            DependencyRequest dependencyRequest = new DependencyRequest();
            dependencyRequest.setRoot(node);
            dependencyResult = repositorySystem.resolveDependencies(session, dependencyRequest);
        }
        catch (SettingsBuildingException | DependencyCollectionException | DependencyResolutionException e) {
            if (!recursiveCall) {
                try {
                    return AetherUtilities.getDependencies(requestedArtifact, true);
                }
                catch (MavenException e1) {
                    throw new MavenException(e);
                }
            }
            throw new MavenException(e);
        }
        return dependencyResult.getArtifactResults().stream().map(ArtifactResult::getArtifact);
    }

    public static class Checksum {
        private String checksum;
        private String algorithm;
        private RemoteRepository repository;

        public Checksum(String checksum, String algorithm, RemoteRepository repository) {
            this.checksum = checksum;
            this.algorithm = algorithm;
            this.repository = repository;
        }

        public String toString() {
            return "Checksum{checksum='" + this.checksum + "', algorithm='" + this.algorithm + "', repository=" + this.repository + "}";
        }

        public RemoteRepository getRepository() {
            return this.repository;
        }

        public void setRepository(RemoteRepository repository) {
            this.repository = repository;
        }

        public String getChecksum() {
            return this.checksum;
        }

        public void setChecksum(String checksum) {
            this.checksum = checksum;
        }

        public String getAlgorithm() {
            return this.algorithm;
        }

        public void setAlgorithm(String algorithm) {
            this.algorithm = algorithm;
        }
    }
}

