/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.utilities.aether;

import de.julielab.utilities.aether.MavenConstants;
import de.julielab.utilities.aether.MavenSettingsUtilities;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.internal.impl.DefaultRemoteRepositoryManager;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.MirrorSelector;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transport.file.FileTransporterFactory;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.eclipse.aether.util.repository.DefaultMirrorSelector;

public class MavenRepositoryUtilities {
    public static final RemoteRepository CENTRAL = new RemoteRepository.Builder("CENTRAL", "default", "https://oss.sonatype.org/content/repositories/public/").setSnapshotPolicy(new RepositoryPolicy(true, "always", "warn")).build();
    public static final RemoteRepository LOCAL = new RemoteRepository.Builder("LOCAL", "default", MavenConstants.LOCAL_REPO.toURI().toString()).build();

    private MavenRepositoryUtilities() {
    }

    public static RepositorySystem newRepositorySystem() {
        return MavenRepositoryUtilities.newRepositorySystem(null);
    }

    public static RepositorySystem newRepositorySystem(DefaultServiceLocator serviceLocator) {
        DefaultServiceLocator locator = serviceLocator != null ? serviceLocator : MavenRepositorySystemUtils.newServiceLocator();
        locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        locator.addService(TransporterFactory.class, FileTransporterFactory.class);
        locator.addService(TransporterFactory.class, HttpTransporterFactory.class);
        return (RepositorySystem)locator.getService(RepositorySystem.class);
    }

    public static RepositorySystemSession newSession(RepositorySystem system, File localRepositoryPath) throws SettingsBuildingException {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        session.setConfigProperty("aether.artifactResolver.snapshotNormalization", (Object)false);
        LocalRepository localRepo = new LocalRepository(localRepositoryPath.getAbsolutePath());
        session.setLocalRepositoryManager(system.newLocalRepositoryManager((RepositorySystemSession)session, localRepo));
        session.setUpdatePolicy("always");
        DefaultMirrorSelector mirrorSelector = new DefaultMirrorSelector();
        Settings mavenSettings = MavenSettingsUtilities.getMavenSettings();
        List mirrors = mavenSettings.getMirrors();
        for (Mirror mirror : mirrors) {
            mirrorSelector.add(mirror.getId(), mirror.getUrl(), null, false, mirror.getMirrorOf(), "");
        }
        session.setMirrorSelector((MirrorSelector)mirrorSelector);
        return session;
    }

    public static List<RemoteRepository> getEffectiveRepositories(RepositorySystemSession session) throws SettingsBuildingException {
        Map<String, Authentication> authenticationMap = MavenSettingsUtilities.getRepositoryAuthenticationsFromMavenSettings();
        DefaultRemoteRepositoryManager remoteRepositoryManager = new DefaultRemoteRepositoryManager();
        List<RemoteRepository> repositories = remoteRepositoryManager.aggregateRepositories(session, Arrays.asList(LOCAL, CENTRAL), MavenSettingsUtilities.getRemoteRepositoriesFromSettings(), true);
        repositories = repositories.stream().map(repo -> {
            if (authenticationMap.containsKey(repo.getId())) {
                return new RemoteRepository.Builder(repo).setAuthentication((Authentication)authenticationMap.get(repo.getId())).build();
            }
            return repo;
        }).collect(Collectors.toList());
        return repositories;
    }
}

