/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.utilities.aether;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Repository;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.DefaultSettingsBuilder;
import org.apache.maven.settings.building.DefaultSettingsBuilderFactory;
import org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.apache.maven.settings.building.SettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingResult;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.util.repository.AuthenticationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenSettingsUtilities {
    private static final Logger log = LoggerFactory.getLogger(MavenSettingsUtilities.class);

    public static Settings getMavenSettings() throws SettingsBuildingException {
        String userHome = System.getProperty("user.home");
        File userMavenConfigurationHome = new File(userHome, ".m2");
        String envM2Home = System.getenv("M2_HOME");
        File DEFAULT_USER_SETTINGS_FILE = new File(userMavenConfigurationHome, "settings.xml");
        File DEFAULT_GLOBAL_SETTINGS_FILE = new File(System.getProperty("maven.home", envM2Home != null ? envM2Home : ""), "conf/settings.xml");
        DefaultSettingsBuildingRequest settingsBuildingRequest = new DefaultSettingsBuildingRequest();
        settingsBuildingRequest.setSystemProperties(System.getProperties());
        settingsBuildingRequest.setUserSettingsFile(DEFAULT_USER_SETTINGS_FILE);
        settingsBuildingRequest.setGlobalSettingsFile(DEFAULT_GLOBAL_SETTINGS_FILE);
        DefaultSettingsBuilderFactory mvnSettingBuilderFactory = new DefaultSettingsBuilderFactory();
        DefaultSettingsBuilder settingsBuilder = mvnSettingBuilderFactory.newInstance();
        SettingsBuildingResult settingsBuildingResult = settingsBuilder.build((SettingsBuildingRequest)settingsBuildingRequest);
        return settingsBuildingResult.getEffectiveSettings();
    }

    public static Map<String, Authentication> getRepositoryAuthenticationsFromMavenSettings() throws SettingsBuildingException {
        HashMap<String, Authentication> authenticationMap = new HashMap<String, Authentication>();
        List servers = MavenSettingsUtilities.getMavenSettings().getServers();
        for (Server server : servers) {
            Authentication auth;
            if (server.getUsername() != null && server.getPassword() != null) {
                auth = new AuthenticationBuilder().addUsername(server.getUsername()).addPassword(server.getPassword()).build();
                authenticationMap.put(server.getId(), auth);
            }
            if (server.getPassphrase() == null || server.getPrivateKey() == null) continue;
            auth = new AuthenticationBuilder().addPrivateKey(server.getPrivateKey(), server.getPassphrase()).build();
            authenticationMap.put(server.getId(), auth);
        }
        return authenticationMap;
    }

    public static List<RemoteRepository> getRemoteRepositoriesFromSettings() throws SettingsBuildingException {
        Settings effectiveSettings = MavenSettingsUtilities.getMavenSettings();
        Map<String, Authentication> authenticationMap = MavenSettingsUtilities.getRepositoryAuthenticationsFromMavenSettings();
        Map profilesMap = effectiveSettings.getProfilesAsMap();
        ArrayList<RemoteRepository> remotes = new ArrayList<RemoteRepository>(20);
        for (String profileName : effectiveSettings.getActiveProfiles()) {
            Profile profile = (Profile)profilesMap.get(profileName);
            if (profile == null) continue;
            List repositories = profile.getRepositories();
            for (Repository repo : repositories) {
                Authentication auth = authenticationMap.get(repo.getId());
                RemoteRepository.Builder repoBuilder = new RemoteRepository.Builder(repo.getId(), "default", repo.getUrl());
                if (auth != null) {
                    repoBuilder.setAuthentication(auth);
                }
                repoBuilder.setSnapshotPolicy(new RepositoryPolicy(true, "always", "warn"));
                RemoteRepository remoteRepo = repoBuilder.build();
                remotes.add(remoteRepo);
            }
        }
        if (log.isTraceEnabled()) {
            remotes.forEach(r -> log.trace("Getting repository from Maven settings: {}", r));
        }
        return remotes;
    }

    private MavenSettingsUtilities() {
    }
}

