/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.utilities.aether.apps;

import de.julielab.utilities.aether.AetherUtilities;
import de.julielab.utilities.aether.MavenArtifact;
import de.julielab.utilities.aether.MavenException;
import java.util.List;
import java.util.Optional;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;

public class FindRemoteChecksum {
    public static void main(String[] args) throws MavenException {
        DefaultArtifact artifact;
        Optional<List<AetherUtilities.Checksum>> checksumsOpt;
        if (args.length != 2) {
            System.err.println("Usage: " + FindRemoteChecksum.class.getSimpleName() + " <groupId>:<artifactId>[:<extension>[:<classifier>]]:<version> <comparison checksum>");
            System.exit(1);
        }
        if (!(checksumsOpt = AetherUtilities.getRemoteChecksums(new MavenArtifact((Artifact)(artifact = new DefaultArtifact(args[0]))))).isPresent()) {
            System.out.println("CHECKSUM FOUND: false");
        } else {
            List<AetherUtilities.Checksum> checksums = checksumsOpt.get();
            boolean found = false;
            for (AetherUtilities.Checksum checksum : checksums) {
                found |= checksum.getChecksum().equals(args[1]);
            }
            System.out.println("CHECKSUM FOUND: " + found);
        }
    }
}

