/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.utilities.aether.apps;

import de.julielab.utilities.aether.AetherUtilities;
import de.julielab.utilities.aether.MavenArtifact;
import de.julielab.utilities.aether.MavenException;
import java.util.List;
import java.util.Optional;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;

public class GetRemoteChecksums {
    public static void main(String[] args) throws MavenException {
        DefaultArtifact artifact;
        Optional<List<AetherUtilities.Checksum>> checksumsOpt;
        if (args.length != 1) {
            System.err.println("Usage: " + GetRemoteChecksums.class.getSimpleName() + " <groupId>:<artifactId>[:<extension>[:<classifier>]]:<version>");
            System.exit(1);
        }
        if (!(checksumsOpt = AetherUtilities.getRemoteChecksums(new MavenArtifact((Artifact)(artifact = new DefaultArtifact(args[0]))))).isPresent()) {
            System.out.println("<checkums not found>");
        } else {
            List<AetherUtilities.Checksum> checksums = checksumsOpt.get();
            for (AetherUtilities.Checksum checksum : checksums) {
                System.out.println("CHECKSUM:\t" + checksum.getAlgorithm() + "\t" + checksum.getChecksum() + "\t" + checksum.getRepository().getUrl());
            }
        }
    }
}

