/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.neo4j.plugins.ahocorasick;

import de.julielab.neo4j.plugins.ahocorasick.ACProperties;
import de.julielab.neo4j.plugins.ahocorasick.ACUtil;
import de.julielab.neo4j.plugins.ahocorasick.property.ACDataBase;
import de.julielab.neo4j.plugins.ahocorasick.property.ACDictionary;
import de.julielab.neo4j.plugins.ahocorasick.property.ACEntry;
import de.julielab.neo4j.plugins.ahocorasick.property.ACGlobalMap;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.index.lucene.unsafe.batchinsert.LuceneBatchInserterIndexProvider;
import org.neo4j.shell.util.json.JSONException;
import org.neo4j.shell.util.json.JSONObject;
import org.neo4j.unsafe.batchinsert.BatchInserter;
import org.neo4j.unsafe.batchinsert.BatchInserterIndex;
import org.neo4j.unsafe.batchinsert.BatchRelationship;

public class ACFactoryBatch {
    public static boolean createDictTree(BatchInserter batchInserter, ACDictionary dict) {
        long rootID = ACUtil.getRootID(batchInserter, dict.name());
        if (rootID == -1L) {
            HashMap<String, Object> propertiesRoot = new HashMap<String, Object>();
            propertiesRoot.put("dict_name", dict.name());
            propertiesRoot.put("nodes_in_Tree", 1);
            propertiesRoot.put("number_of_entries", 0);
            propertiesRoot.put("prepared", false);
            propertiesRoot.put("property_state", 0);
            propertiesRoot.put("property_depth", 0);
            propertiesRoot.put("property_number_Output", 0);
            JSONObject jsonRelMap = new JSONObject();
            propertiesRoot.put("property_relationship", jsonRelMap.toString());
            propertiesRoot.put("property_number_next", 0);
            propertiesRoot.put("modeCreate", dict.getCreateMode());
            propertiesRoot.put("modeSearch", dict.isLocalSearch());
            long id = batchInserter.createNode(propertiesRoot, new Label[]{ACProperties.LabelTypes.DICTIONARY});
            Map propertie = MapUtil.map((Object[])new Object[]{"dict_name", dict.name()});
            LuceneBatchInserterIndexProvider indexProvider = new LuceneBatchInserterIndexProvider(batchInserter);
            BatchInserterIndex dictIndex = indexProvider.nodeIndex("index_dic", MapUtil.stringMap((String[])new String[]{"type", "exact"}));
            dictIndex.add(id, propertie);
            dictIndex.flush();
            indexProvider.shutdown();
            return true;
        }
        return false;
    }

    public static boolean addListToDictTree(ACDataBase dataBase, ACDictionary dict, List<ACEntry> listEntries) throws JSONException, IOException {
        BatchInserter batchInserter = dataBase.startBatchInserter();
        long id = ACUtil.getRootID(batchInserter, dict.name());
        if (id != -1L) {
            Map<String, Object> rootProperties = batchInserter.getNodeProperties(id);
            boolean prepared = (Boolean)rootProperties.get("prepared");
            ACGlobalMap globalMap = null;
            if (dict.getCreateMode() == 2) {
                globalMap = dataBase.getMap(dict.name());
            }
            if (!prepared) {
                for (int i = 0; i < listEntries.size(); ++i) {
                    ACEntry entry = listEntries.get(i);
                    rootProperties = ACFactoryBatch.addEntryToTree(batchInserter, dict, rootProperties, globalMap, id, entry);
                }
                batchInserter.setNodeProperty(id, "nodes_in_Tree", rootProperties.get("nodes_in_Tree"));
                batchInserter.setNodeProperty(id, "number_of_entries", rootProperties.get("number_of_entries"));
                return true;
            }
        }
        return false;
    }

    private static Map<String, Object> addEntryToTree(BatchInserter batchInserter, ACDictionary dict, Map<String, Object> rootProperties, ACGlobalMap globalMap, long rootId, ACEntry entry) throws JSONException {
        String[] toAdd = entry.getTokens();
        long newState = ACUtil.toLong(rootProperties.get("nodes_in_Tree"));
        int j = 0;
        long nodeId = rootId;
        long nodeNextId = ACUtil.getNextNodeCreate(dict, batchInserter, -1L, globalMap, nodeId, toAdd[j]);
        while (nodeNextId != -1L) {
            nodeId = nodeNextId;
            if (++j == toAdd.length) break;
            nodeNextId = ACUtil.getNextNodeCreate(dict, batchInserter, -1L, globalMap, nodeId, toAdd[j]);
        }
        for (int p = j; p < toAdd.length; ++p) {
            HashMap<String, Object> properties = new HashMap<String, Object>();
            JSONObject jsonRelMap = new JSONObject();
            properties.put("property_state", newState);
            properties.put("property_number_Output", 0);
            properties.put("property_number_next", 0);
            properties.put("property_depth", p);
            properties.put("property_relationship", jsonRelMap.toString());
            long newNodeId = batchInserter.createNode(properties, new Label[0]);
            HashMap<String, String> mapRel = new HashMap<String, String>();
            mapRel.put("letter", toAdd[p]);
            batchInserter.createRelationship(nodeId, newNodeId, (RelationshipType)ACProperties.EdgeTypes.NEXT, mapRel);
            Map map = batchInserter.getNodeProperties(nodeId);
            map.put("property_number_next", ACUtil.toLong(map.get("property_number_next")) + 1L);
            if (dict.isLocalCreate()) {
                jsonRelMap = new JSONObject(String.valueOf(map.get("property_relationship")));
                jsonRelMap.putOpt(toAdd[p], (Object)newNodeId);
                map.put("property_relationship", jsonRelMap.toString());
            }
            batchInserter.setNodeProperties(nodeId, map);
            if (dict.isGlobalCreate()) {
                globalMap.addNode(newNodeId);
                globalMap.addRel(nodeId, toAdd[p], newNodeId);
            }
            nodeId = newNodeId;
            ++newState;
        }
        ACFactoryBatch.addOutput(batchInserter, nodeId, entry);
        rootProperties.put("nodes_in_Tree", newState);
        rootProperties.put("number_of_entries", ACUtil.toLong(rootProperties.get("number_of_entries")) + 1L);
        return rootProperties;
    }

    public static boolean prepareDictTreeForSearch(ACDataBase dataBase, ACDictionary dict) throws IOException, JSONException {
        BatchInserter batchInserter = dataBase.startBatchInserter();
        long id = ACUtil.getRootID(batchInserter, dict.name());
        int counter = 0;
        if (id != -1L) {
            Map rootProperties = batchInserter.getNodeProperties(id);
            Boolean prepared = (Boolean)rootProperties.get("prepared");
            if (prepared.booleanValue()) {
                return false;
            }
            System.out.println(rootProperties.get("nodes_in_Tree"));
            ACGlobalMap globalMap = null;
            if (dict.isGlobalCreate()) {
                globalMap = dataBase.getMap(dict.name());
                if (dict.isLocalSearch()) {
                    Map map = batchInserter.getNodeProperties(id);
                    JSONObject jsonRelMap = new JSONObject(globalMap.getRelMap().get(id));
                    map.put("property_relationship", jsonRelMap.toString());
                    batchInserter.setNodeProperties(id, map);
                }
                ArrayDeque<Long> queue = new ArrayDeque<Long>();
                Iterator<String> iter = globalMap.iteratorNextNodes(id);
                while (iter.hasNext()) {
                    long endNode = ACUtil.toLong(globalMap.getNodeID(id, iter.next()));
                    batchInserter.createRelationship(endNode, id, (RelationshipType)ACProperties.EdgeTypes.FAIL, null);
                    queue.add(endNode);
                    globalMap.addRel(endNode, ACProperties.getFailName(), id);
                    Map map = batchInserter.getNodeProperties(endNode);
                    map.put("property_number_next", ACUtil.toLong(map.get("property_number_next")) + 1L);
                    if (dict.isLocalSearch()) {
                        JSONObject jsonRelMap = new JSONObject(globalMap.getRelMap().get(endNode));
                        map.put("property_relationship", jsonRelMap.toString());
                    }
                    batchInserter.setNodeProperties(endNode, map);
                    ++counter;
                }
                while (!queue.isEmpty()) {
                    long node = (Long)queue.pop();
                    iter = globalMap.iteratorNextNodes(node);
                    while (iter.hasNext()) {
                        String typ = iter.next();
                        if (typ.equals(ACProperties.EdgeTypes.FAIL.name())) continue;
                        long endNode = ACUtil.toLong(globalMap.getNodeID(node, typ));
                        queue.add(endNode);
                        long state = globalMap.getNodeID(node, ACProperties.getFailName());
                        long toNode = -1L;
                        while ((toNode = ACUtil.getNextNodeCreate(dict, batchInserter, id, globalMap, state, typ)) == -1L) {
                            state = globalMap.getNodeID(state, ACProperties.getFailName());
                        }
                        batchInserter.createRelationship(endNode, toNode, (RelationshipType)ACProperties.EdgeTypes.FAIL, null);
                        globalMap.addRel(endNode, ACProperties.getFailName(), toNode);
                        Map map = batchInserter.getNodeProperties(endNode);
                        map.put("property_number_next", ACUtil.toLong(map.get("property_number_next")) + 1L);
                        if (dict.isLocalSearch()) {
                            JSONObject jsonRelMap = new JSONObject(globalMap.getRelMap().get(endNode));
                            map.put("property_relationship", jsonRelMap.toString());
                        }
                        batchInserter.setNodeProperties(endNode, map);
                        ACFactoryBatch.unionOutput(batchInserter, endNode, toNode);
                        if (++counter % 100 != 0) continue;
                        System.out.println(counter);
                    }
                }
                dataBase.deleteMap(dict.name());
            } else if (dict.isLocalCreate()) {
                ArrayDeque<Long> queue = new ArrayDeque<Long>();
                for (BatchRelationship rel : batchInserter.getRelationships(id)) {
                    if (rel.getStartNode() != id || rel.getStartNode() == rel.getEndNode()) continue;
                    long endNode = rel.getEndNode();
                    batchInserter.createRelationship(endNode, id, (RelationshipType)ACProperties.EdgeTypes.FAIL, null);
                    queue.add(endNode);
                    Map map = batchInserter.getNodeProperties(endNode);
                    map.put("property_number_next", ACUtil.toLong(map.get("property_number_next")) + 1L);
                    JSONObject jsonRelMap = new JSONObject(String.valueOf(map.get("property_relationship")));
                    jsonRelMap.putOnce(ACProperties.getFailName(), (Object)id);
                    map.put("property_relationship", jsonRelMap.toString());
                    batchInserter.setNodeProperties(endNode, map);
                    ++counter;
                }
                while (!queue.isEmpty()) {
                    long node = (Long)queue.pop();
                    JSONObject ob = new JSONObject(String.valueOf(batchInserter.getNodeProperties(node).get("property_relationship")));
                    for (BatchRelationship rel : batchInserter.getRelationships(node)) {
                        Map mapRel = batchInserter.getRelationshipProperties(rel.getId());
                        String nameRel = (String)mapRel.get("letter");
                        if (rel.getType().name().equals(ACProperties.EdgeTypes.FAIL.name()) || rel.getStartNode() != node || rel.getStartNode() == rel.getEndNode()) continue;
                        long endNode = rel.getEndNode();
                        queue.add(endNode);
                        long state = ACUtil.toLong(ob.get(ACProperties.EdgeTypes.FAIL.name()));
                        long toNode = -1L;
                        while ((toNode = ACUtil.getNextNodeCreate(dict, batchInserter, id, globalMap, state, nameRel)) == -1L) {
                            JSONObject obBetween = new JSONObject(String.valueOf(batchInserter.getNodeProperties(state).get("property_relationship")));
                            state = id;
                            if (!obBetween.has(ACProperties.EdgeTypes.FAIL.name())) continue;
                            state = obBetween.getLong(ACProperties.EdgeTypes.FAIL.name());
                        }
                        batchInserter.createRelationship(endNode, toNode, (RelationshipType)ACProperties.EdgeTypes.FAIL, null);
                        Map map = batchInserter.getNodeProperties(endNode);
                        map.put("property_number_next", ACUtil.toLong(map.get("property_number_next")) + 1L);
                        JSONObject jsonRelMap = new JSONObject(String.valueOf(map.get("property_relationship")));
                        jsonRelMap.putOnce(ACProperties.getFailName(), (Object)toNode);
                        map.put("property_relationship", jsonRelMap.toString());
                        batchInserter.setNodeProperties(endNode, map);
                        ACFactoryBatch.unionOutput(batchInserter, endNode, toNode);
                        if (++counter % 10000 != 0) continue;
                        System.out.println(counter);
                    }
                }
            } else {
                ArrayDeque<Long> queue = new ArrayDeque<Long>();
                for (BatchRelationship rel : batchInserter.getRelationships(id)) {
                    if (rel.getStartNode() != id || rel.getStartNode() == rel.getEndNode()) continue;
                    long endNode = rel.getEndNode();
                    batchInserter.createRelationship(endNode, id, (RelationshipType)ACProperties.EdgeTypes.FAIL, null);
                    queue.add(endNode);
                    Map map = batchInserter.getNodeProperties(endNode);
                    map.put("property_number_next", ACUtil.toLong(map.get("property_number_next")) + 1L);
                    batchInserter.setNodeProperties(endNode, map);
                    ++counter;
                }
                while (!queue.isEmpty()) {
                    long node = (Long)queue.pop();
                    for (BatchRelationship typ : batchInserter.getRelationships(node)) {
                        long endNode = typ.getEndNode();
                        Map mapRel = batchInserter.getRelationshipProperties(typ.getId());
                        String nameRel = (String)mapRel.get("letter");
                        if (typ.getType().name().equals(ACProperties.EdgeTypes.FAIL.name()) || typ.getStartNode() != node || typ.getStartNode() == typ.getEndNode()) continue;
                        queue.add(endNode);
                        long state = 0L;
                        for (BatchRelationship batRel : batchInserter.getRelationships(node)) {
                            if (!batRel.getType().name().equals(ACProperties.getFailName()) || batRel.getStartNode() != node) continue;
                            state = batRel.getEndNode();
                            break;
                        }
                        long toNode = -1L;
                        block12: while ((toNode = ACUtil.getNextNodeCreate(dict, batchInserter, id, globalMap, state, nameRel)) == -1L) {
                            for (BatchRelationship batRel : batchInserter.getRelationships(state)) {
                                if (!batRel.getType().name().equals(ACProperties.getFailName()) || batRel.getStartNode() != state) continue;
                                state = batRel.getEndNode();
                                continue block12;
                            }
                        }
                        batchInserter.createRelationship(endNode, toNode, (RelationshipType)ACProperties.EdgeTypes.FAIL, null);
                        Map map = batchInserter.getNodeProperties(endNode);
                        map.put("property_number_next", ACUtil.toLong(map.get("property_number_next")) + 1L);
                        batchInserter.setNodeProperties(endNode, map);
                        ACFactoryBatch.unionOutput(batchInserter, endNode, toNode);
                        if (++counter % 10000 != 0) continue;
                        System.out.println(counter);
                    }
                }
            }
            batchInserter.setNodeProperty(id, "prepared", (Object)true);
            return true;
        }
        return false;
    }

    private static void addOutput(BatchInserter batchInserter, long nodeId, ACEntry entry) throws JSONException {
        JSONObject jsonOB = new JSONObject();
        jsonOB.put(entry.entryString(), entry.getAllAttributes());
        Map prop = batchInserter.getNodeProperties(nodeId);
        prop.put("property_original", entry.entryString());
        prop.put("property_Output", jsonOB.toString());
        prop.put("property_number_Output", 1);
        batchInserter.setNodeProperties(nodeId, prop);
    }

    private static void unionOutput(BatchInserter batchInserter, long node1, long node2) throws JSONException {
        Map prop2 = batchInserter.getNodeProperties(node2);
        if (ACUtil.toLong(prop2.get("property_number_Output")) == 0L) {
            return;
        }
        Map prop1 = batchInserter.getNodeProperties(node1);
        if (ACUtil.toLong(prop1.get("property_number_Output")) == 0L) {
            prop1.put("property_Output", prop2.get("property_Output"));
            prop1.put("property_number_Output", (Integer)prop2.get("property_number_Output"));
            batchInserter.setNodeProperties(node1, prop1);
            return;
        }
        JSONObject jsonObNode1 = new JSONObject(String.valueOf(prop1.get("property_Output")));
        JSONObject jsonObNode2 = new JSONObject(String.valueOf(prop2.get("property_Output")));
        Iterator keys = jsonObNode2.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (key.startsWith("property_") || jsonObNode1.has(key)) continue;
            jsonObNode1.putOnce(key, jsonObNode2.get(key));
            prop1.put("property_number_Output", (Integer)prop1.get("property_number_Output") + 1);
        }
        prop1.put("property_Output", jsonObNode1.toString());
        batchInserter.setNodeProperties(node1, prop1);
    }
}

