/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.neo4j.plugins.ahocorasick;

import com.google.gson.Gson;
import de.julielab.neo4j.plugins.ahocorasick.ACProperties;
import de.julielab.neo4j.plugins.ahocorasick.ACUtil;
import de.julielab.neo4j.plugins.ahocorasick.property.ACDictionary;
import de.julielab.neo4j.plugins.ahocorasick.property.ACEntry;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Stack;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.server.plugins.Description;
import org.neo4j.server.plugins.Name;
import org.neo4j.server.plugins.Parameter;
import org.neo4j.server.plugins.PluginTarget;
import org.neo4j.server.plugins.ServerPlugin;
import org.neo4j.server.plugins.Source;
import org.neo4j.shell.util.json.JSONException;
import org.neo4j.shell.util.json.JSONObject;

public class ACRefactory
extends ServerPlugin {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Name(value="delete_entry_in_dicttree")
    @Description(value="Delete entry in the DictTree.")
    @PluginTarget(value=GraphDatabaseService.class)
    public static boolean deleteEntryInDictTree(@Source GraphDatabaseService graphDb, @Description(value="ACDictionary as JSONString") @Parameter(name="dict") String dictJSON, @Description(value="Entry to delete") @Parameter(name="entry") String entry) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException, JSONException {
        ACDictionary dict = new ACDictionary(new JSONObject(dictJSON));
        try (Transaction tx = graphDb.beginTx();){
            Node root = ACUtil.getRootNode(graphDb, dict.name());
            Node node = ACUtil.getExactNode(dict, graphDb, root, entry);
            if (node != null) {
                boolean original = true;
                ArrayDeque<Node> queue = new ArrayDeque<Node>();
                queue.add(node);
                ArrayList<Node> failNodes = new ArrayList<Node>();
                while (!queue.isEmpty()) {
                    node = (Node)queue.pop();
                    if (!ACRefactory.isBoundaryNode(graphDb, node, root, entry)) continue;
                    for (Relationship rel : node.getRelationships(Direction.INCOMING)) {
                        if (rel.getType().name().equals(ACProperties.getFailName())) {
                            failNodes.add(rel.getStartNode());
                            ACUtil.updateRemoveNode(dict, rel.getStartNode(), rel.getEndNode(), ACProperties.getFailName());
                        } else {
                            queue.add(rel.getStartNode());
                            ACUtil.updateRemoveNode(dict, rel.getStartNode(), rel.getEndNode(), (String)rel.getProperty("letter"));
                        }
                        ACUtil.decreaseNumberNext(rel.getStartNode());
                        rel.delete();
                    }
                    node.getSingleRelationship((RelationshipType)ACProperties.EdgeTypes.FAIL, Direction.OUTGOING).delete();
                    node.delete();
                    original = false;
                }
                if (!ACRefactory.isBoundaryNode(graphDb, node, root, entry) && original) {
                    Stack<Node> stackNodeFail = new Stack<Node>();
                    stackNodeFail.add(node);
                    while (!stackNodeFail.isEmpty()) {
                        Node relToNodeFail = (Node)stackNodeFail.pop();
                        Iterator iterRelFail = relToNodeFail.getRelationships(Direction.INCOMING, new RelationshipType[]{ACProperties.EdgeTypes.FAIL}).iterator();
                        while (iterRelFail.hasNext()) {
                            stackNodeFail.add(((Relationship)iterRelFail.next()).getStartNode());
                        }
                        ACRefactory.deleteOutput(relToNodeFail, entry);
                    }
                }
                Collections.sort(failNodes, ACUtil.getComperator());
                for (int i = 0; i < failNodes.size(); ++i) {
                    Node nodeFail = (Node)failNodes.get(i);
                    if (nodeFail.hasProperty("property_Output")) {
                        Stack<Node> stackNodeFail = new Stack<Node>();
                        stackNodeFail.add(nodeFail);
                        while (!stackNodeFail.isEmpty()) {
                            Node relToNodeFail = (Node)stackNodeFail.pop();
                            Iterator iterRelFail = relToNodeFail.getRelationships(Direction.INCOMING, new RelationshipType[]{ACProperties.EdgeTypes.FAIL}).iterator();
                            while (iterRelFail.hasNext()) {
                                stackNodeFail.add(((Relationship)iterRelFail.next()).getStartNode());
                            }
                            ACRefactory.deleteOutput(relToNodeFail, entry);
                        }
                    }
                    Iterator iterRelNodeBefore = nodeFail.getRelationships(Direction.INCOMING).iterator();
                    Relationship rela = null;
                    while (iterRelNodeBefore.hasNext()) {
                        rela = (Relationship)iterRelNodeBefore.next();
                        if (rela.getType().name().equals(ACProperties.getFailName())) continue;
                        node = rela.getStartNode();
                        break;
                    }
                    Node state = graphDb.getNodeById(ACUtil.getFailNode(node, root));
                    Node toNode = null;
                    while ((toNode = ACUtil.getNextNodeSearch(dict, graphDb, state, (String)rela.getProperty("letter"))) == null) {
                        state = graphDb.getNodeById(ACUtil.getFailNode(state, root));
                    }
                    nodeFail.createRelationshipTo(toNode, (RelationshipType)ACProperties.EdgeTypes.FAIL);
                    ACUtil.updateAddNode(dict, nodeFail, toNode, ACProperties.getFailName());
                    ACUtil.increaseNumberNext(nodeFail);
                    Stack<Node> stackNodeOutput = new Stack<Node>();
                    stackNodeOutput.add(nodeFail);
                    while (!stackNodeOutput.isEmpty()) {
                        Node relToNodeFail = (Node)stackNodeOutput.pop();
                        Iterator iterRelFail = relToNodeFail.getRelationships(Direction.INCOMING, new RelationshipType[]{ACProperties.EdgeTypes.FAIL}).iterator();
                        while (iterRelFail.hasNext()) {
                            stackNodeOutput.add(((Relationship)iterRelFail.next()).getStartNode());
                        }
                        ACUtil.unionOutput(relToNodeFail, toNode);
                    }
                }
            }
            tx.success();
            boolean bl = node != null;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Name(value="change_attribute_of_entry")
    @Description(value="Change Attributevalues of an entry in a DictTree.")
    @PluginTarget(value=GraphDatabaseService.class)
    public static boolean editEntry(@Source GraphDatabaseService graphDb, @Description(value="ACDictionary as JSONString") @Parameter(name="dict") String dictJSON, @Description(value="Entry to change") @Parameter(name="entry") String entryACJSON) throws JSONException {
        ACDictionary dict = new ACDictionary(new JSONObject(dictJSON));
        ACEntry entry = new ACEntry(new JSONObject(entryACJSON));
        try (Transaction tx = graphDb.beginTx();){
            boolean success = true;
            Node root = ACUtil.getRootNode(graphDb, dict.name());
            if (root != null) {
                Node node = ACUtil.getExactNode(dict, graphDb, root, entry.entryString());
                if (node == null) {
                    tx.success();
                    boolean bl = false;
                    return bl;
                }
                ArrayDeque<Node> queue = new ArrayDeque<Node>();
                queue.add(node);
                while (!queue.isEmpty()) {
                    Node startNode = (Node)queue.pop();
                    JSONObject jsonOb = new JSONObject(String.valueOf(node.getProperty("property_Output")));
                    jsonOb.putOpt(entry.entryString(), (Object)new Gson().toJson(entry.getAllAttributes()));
                    startNode.setProperty("property_Output", (Object)jsonOb.toString());
                    for (Relationship rel : startNode.getRelationships(Direction.INCOMING)) {
                        if (!rel.isType((RelationshipType)ACProperties.EdgeTypes.FAIL)) continue;
                        Node failNode = rel.getStartNode();
                        queue.add(failNode);
                    }
                }
            }
            tx.success();
            boolean bl = success;
            return bl;
        }
    }

    private static void deleteOutput(Node node, String output) throws JSONException {
        JSONObject ob = new JSONObject(String.valueOf(node.getProperty("property_Output")));
        if (ob.has(output)) {
            ob.remove(output);
            node.setProperty("property_Output", (Object)ob.toString());
            node.setProperty("property_number_Output", (Object)((Integer)node.getProperty("property_number_Output") - 1));
        }
        if (node.hasProperty("property_original") && node.getProperty("property_original").equals(output)) {
            node.removeProperty("property_original");
        }
    }

    private static boolean isBoundaryNode(GraphDatabaseService graphDb, Node node, Node root, String entry) {
        int count;
        if (root.equals(node)) {
            return false;
        }
        if (ACUtil.toLong(node.getProperty("property_number_Output")) > 0L && node.hasProperty("property_original") && !node.getProperty("property_original").equals(entry)) {
            return false;
        }
        Iterator iterRel = node.getRelationships(Direction.OUTGOING).iterator();
        for (count = 0; iterRel.hasNext() && count < 2; ++count) {
            iterRel.next();
        }
        boolean prepared = ACUtil.isDictTreePrepared(root);
        if (prepared && count == 1) {
            return true;
        }
        return count == 0;
    }
}

