/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.neo4j.plugins.ahocorasick;

import de.julielab.neo4j.plugins.ahocorasick.ACProperties;
import de.julielab.neo4j.plugins.ahocorasick.Deepth;
import de.julielab.neo4j.plugins.ahocorasick.property.ACDictionary;
import de.julielab.neo4j.plugins.ahocorasick.property.ACEntry;
import de.julielab.neo4j.plugins.ahocorasick.property.ACGlobalMap;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.graphdb.index.IndexManager;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.index.lucene.unsafe.batchinsert.LuceneBatchInserterIndexProvider;
import org.neo4j.shell.util.json.JSONException;
import org.neo4j.shell.util.json.JSONObject;
import org.neo4j.unsafe.batchinsert.BatchInserter;
import org.neo4j.unsafe.batchinsert.BatchInserterIndex;
import org.neo4j.unsafe.batchinsert.BatchRelationship;

public class ACUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long getRootID(BatchInserter batchInserter, String name) {
        LuceneBatchInserterIndexProvider indexProvider = new LuceneBatchInserterIndexProvider(batchInserter);
        BatchInserterIndex dict = indexProvider.nodeIndex("index_dic", MapUtil.stringMap((String[])new String[]{"type", "exact"}));
        try {
            IndexHits hits = dict.get("dict_name", (Object)name);
            if (hits.hasNext()) {
                long l = (Long)hits.getSingle();
                return l;
            }
            long l = -1L;
            return l;
        }
        finally {
            indexProvider.shutdown();
        }
    }

    static Node getRootNode(GraphDatabaseService graphDb, String name) {
        IndexManager manager = graphDb.index();
        Index index = manager.forNodes("index_dic");
        IndexHits hits = index.get("dict_name", (Object)name);
        return (Node)hits.getSingle();
    }

    static Node getNextNodeSearch(ACDictionary dict, GraphDatabaseService graphDb, Node node, String letter) throws JSONException {
        if (dict.isLocalSearch()) {
            JSONObject jsonRelMap = new JSONObject(String.valueOf(node.getProperty("property_relationship")));
            if (jsonRelMap.has(letter)) {
                return graphDb.getNodeById(Long.valueOf(String.valueOf(jsonRelMap.get(letter))).longValue());
            }
            long numberNext = ACUtil.toLong(node.getProperty("property_number_next"));
            if ((long)jsonRelMap.length() != numberNext) {
                for (Relationship rel : node.getRelationships(Direction.OUTGOING)) {
                    if (rel.getStartNode().getId() == rel.getEndNode().getId()) continue;
                    jsonRelMap.putOpt((String)rel.getProperty("letter"), (Object)rel.getEndNode());
                }
                node.setProperty("property_number_next", (Object)jsonRelMap.length());
                node.setProperty("property_relationship", (Object)jsonRelMap.toString());
                return ACUtil.getNextNodeSearch(dict, graphDb, node, letter);
            }
        } else {
            for (Relationship rel : node.getRelationships(Direction.OUTGOING)) {
                if (rel.getType().name().equals(ACProperties.getFailName()) || !rel.getProperty("letter").equals(letter)) continue;
                return rel.getEndNode();
            }
        }
        if (node.hasProperty("dict_name")) {
            return node;
        }
        return null;
    }

    static Node getNextNodeCreate(ACDictionary dict, GraphDatabaseService graphDb, Node root, Node node, String letter) throws JSONException {
        if (dict.getCreateMode() == 0) {
            for (Relationship rel : node.getRelationships(Direction.OUTGOING)) {
                if (rel.getType().name().equals(ACProperties.getFailName()) || !rel.getProperty("letter").equals(letter)) continue;
                return rel.getEndNode();
            }
        } else {
            JSONObject jsonRelMap = new JSONObject(String.valueOf(node.getProperty("property_relationship")));
            if (jsonRelMap.has(letter)) {
                return graphDb.getNodeById(Long.valueOf(String.valueOf(jsonRelMap.get(letter))).longValue());
            }
            long numberNext = ACUtil.toLong(node.getProperty("property_number_next"));
            if ((long)jsonRelMap.length() != numberNext) {
                for (Relationship rel : node.getRelationships(Direction.OUTGOING)) {
                    if (rel.getStartNode().getId() == rel.getEndNode().getId()) continue;
                    jsonRelMap.putOpt((String)rel.getProperty("letter"), (Object)rel.getEndNode());
                }
                node.setProperty("property_number_next", (Object)jsonRelMap.length());
                node.setProperty("property_relationship", (Object)jsonRelMap.toString());
                return ACUtil.getNextNodeCreate(dict, graphDb, root, node, letter);
            }
        }
        if (root != null && node.getId() == root.getId()) {
            return node;
        }
        return null;
    }

    static long getNextNodeCreate(ACDictionary dict, BatchInserter batchInserter, long rootId, ACGlobalMap globalMap, long idNode, String letter) throws JSONException {
        if (globalMap != null) {
            long id = globalMap.getNodeID(idNode, letter);
            if (id > -1L) {
                return id;
            }
            long numberNext = ACUtil.toLong(batchInserter.getNodeProperties(idNode).get("property_number_next"));
            if (numberNext != (long)globalMap.numberOfRel(idNode)) {
                id = -2L;
            }
            if (id == -2L) {
                globalMap.addNode(idNode);
                Iterator iter = batchInserter.getRelationships(idNode).iterator();
                long counter = 0L;
                while (iter.hasNext()) {
                    Map relMap;
                    BatchRelationship rel = (BatchRelationship)iter.next();
                    if (rel.getStartNode() != idNode || !globalMap.addRel(idNode, (String)(relMap = batchInserter.getRelationshipProperties(rel.getId())).get("letter"), rel.getEndNode())) continue;
                    ++counter;
                }
                Map map = batchInserter.getNodeProperties(idNode);
                map.put("property_number_next", counter + numberNext);
                batchInserter.setNodeProperties(idNode, map);
                return ACUtil.getNextNodeCreate(dict, batchInserter, rootId, globalMap, idNode, letter);
            }
        } else if (dict.isLocalCreate()) {
            JSONObject jsonRelMap = new JSONObject(String.valueOf(batchInserter.getNodeProperties(idNode).get("property_relationship")));
            if (jsonRelMap.has(letter)) {
                return Long.valueOf(String.valueOf(jsonRelMap.get(letter)));
            }
            long numberNext = ACUtil.toLong(batchInserter.getNodeProperties(idNode).get("property_number_next"));
            if ((long)jsonRelMap.length() != numberNext) {
                for (BatchRelationship rel : batchInserter.getRelationships(idNode)) {
                    if (rel.getStartNode() != idNode || rel.getStartNode() == rel.getEndNode()) continue;
                    Map relMap = batchInserter.getRelationshipProperties(rel.getId());
                    jsonRelMap.putOpt((String)relMap.get("letter"), (Object)rel.getEndNode());
                }
                Map mapRel = batchInserter.getNodeProperties(idNode);
                mapRel.put("property_relationship", jsonRelMap.toString());
                mapRel.put("property_number_next", jsonRelMap.length());
                batchInserter.setNodeProperties(idNode, mapRel);
                return ACUtil.getNextNodeCreate(dict, batchInserter, rootId, globalMap, idNode, letter);
            }
        } else {
            for (BatchRelationship rel : batchInserter.getRelationships(idNode)) {
                Map relMap;
                if (rel.getType().name().equals(ACProperties.getFailName()) || !(relMap = batchInserter.getRelationshipProperties(rel.getId())).get("letter").equals(letter) || rel.getEndNode() == idNode) continue;
                return rel.getEndNode();
            }
        }
        if (idNode == rootId) {
            return idNode;
        }
        return -1L;
    }

    static Node getExactNode(ACDictionary dict, GraphDatabaseService graphDb, Node root, String entry) throws JSONException {
        Node node = root;
        for (int i = 0; i < entry.length(); ++i) {
            if ((node = ACUtil.getNextNodeCreate(dict, graphDb, null, node, entry.substring(i, i + 1))) != null) continue;
            return null;
        }
        return node;
    }

    static void addOutput(Node node, ACEntry entry) throws JSONException {
        JSONObject jsonOB = new JSONObject();
        jsonOB.put(entry.entryString(), entry.getAllAttributes());
        node.setProperty("property_original", (Object)entry.entryString());
        node.setProperty("property_Output", (Object)jsonOB.toString());
        node.setProperty("property_number_Output", (Object)1);
    }

    static void unionOutput(Node node1, Node node2) throws JSONException {
        if (ACUtil.toLong(node2.getProperty("property_number_Output")) == 0L) {
            return;
        }
        if (ACUtil.toLong(node1.getProperty("property_number_Output")) == 0L) {
            node1.setProperty("property_Output", node2.getProperty("property_Output"));
            node1.setProperty("property_number_Output", (Object)((Integer)node2.getProperty("property_number_Output")));
            return;
        }
        JSONObject jsonObNode1 = new JSONObject(String.valueOf(node1.getProperty("property_Output")));
        JSONObject jsonObNode2 = new JSONObject(String.valueOf(node2.getProperty("property_Output")));
        Iterator keys = jsonObNode2.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (key.startsWith("property_") || jsonObNode1.has(key)) continue;
            jsonObNode1.putOnce(key, jsonObNode2.get(key));
            node1.setProperty("property_number_Output", (Object)((Integer)node1.getProperty("property_number_Output") + 1));
        }
        node1.setProperty("property_Output", (Object)jsonObNode1.toString());
    }

    static void subtractOutput(Node node1, Node node2) throws JSONException {
        if (ACUtil.toLong(node2.getProperty("property_number_Output")) == 0L) {
            return;
        }
        if (ACUtil.toLong(node1.getProperty("property_number_Output")) == 0L) {
            return;
        }
        JSONObject obNode1 = new JSONObject(String.valueOf(node1.getProperty("property_Output")));
        JSONObject obNode2 = new JSONObject(String.valueOf(node2.getProperty("property_Output")));
        Iterator keys = obNode2.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            obNode1.remove(key);
        }
        node1.setProperty("property_number_Output", (Object)((Integer)node1.getProperty("property_number_Output") - (Integer)node2.getProperty("property_number_Output")));
        node1.setProperty("property_Output", (Object)obNode1.toString());
    }

    static boolean isDictTreePrepared(Node root) {
        return Boolean.valueOf(String.valueOf(root.getProperty("prepared")));
    }

    public static long toLong(Object ob) {
        return Long.valueOf(String.valueOf(ob));
    }

    static boolean toBoolean(Object ob) {
        return Boolean.valueOf(String.valueOf(ob));
    }

    static long getFailNode(Node node, Node root) throws JSONException {
        JSONObject ob = new JSONObject(String.valueOf(node.getProperty("property_relationship")));
        if (ob.has(ACProperties.EdgeTypes.FAIL.name())) {
            return ob.getLong(ACProperties.EdgeTypes.FAIL.name());
        }
        return root.getId();
    }

    static void updateAddNode(ACDictionary dict, Node node, Node newNode, String letter) throws JSONException {
        if (dict.getCreateMode() != 0) {
            JSONObject jsonRelMap = new JSONObject(String.valueOf(node.getProperty("property_relationship")));
            jsonRelMap.putOpt(letter, (Object)newNode.getId());
            node.setProperty("property_relationship", (Object)jsonRelMap.toString());
        }
    }

    static void updateRemoveNode(ACDictionary dict, Node node, Node newNode, String letter) throws JSONException {
        if (dict.getCreateMode() != 0) {
            JSONObject jsonRelMap = new JSONObject(String.valueOf(node.getProperty("property_relationship")));
            jsonRelMap.remove(letter);
            node.setProperty("property_relationship", (Object)jsonRelMap.toString());
        }
    }

    static void increaseNumberNext(Node node) {
        node.setProperty("property_number_next", (Object)(ACUtil.toLong(node.getProperty("property_number_next")) + 1L));
    }

    static void decreaseNumberNext(Node node) {
        node.setProperty("property_number_next", (Object)(ACUtil.toLong(node.getProperty("property_number_next")) - 1L));
    }

    static Comparator<Node> getComperator() {
        return new Deepth();
    }
}

