/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.neo4j.plugins.auxiliaries;

import de.julielab.neo4j.plugins.auxiliaries.JSON;
import de.julielab.neo4j.plugins.auxiliaries.JulieNeo4jUtilities;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.shell.util.json.JSONArray;
import org.neo4j.shell.util.json.JSONException;
import org.neo4j.shell.util.json.JSONObject;

public class PropertyUtilities {
    public static void copyJSONObjectToPropertyContainer(JSONObject object, PropertyContainer node) throws JSONException {
        PropertyUtilities.copyJSONObjectToPropertyContainer(object, node, (Set<String>)null);
    }

    public static void copyJSONObjectToPropertyContainer(JSONObject object, PropertyContainer node, String ... exclusions) throws JSONException {
        HashSet<String> exclusionSet = new HashSet<String>();
        for (int i = 0; i < exclusions.length; ++i) {
            String exclusion = exclusions[i];
            exclusionSet.add(exclusion);
        }
        PropertyUtilities.copyJSONObjectToPropertyContainer(object, node, exclusionSet);
    }

    public static void copyJSONObjectToPropertyContainer(JSONObject object, PropertyContainer node, Set<String> exclusions) throws JSONException {
        Iterator keys = object.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (null != exclusions && exclusions.contains(key)) continue;
            Object value = object.get(key);
            if (value.getClass().equals(JSONArray.class)) {
                String[] json2JavaArray = JSON.json2JavaArray((JSONArray)value, new String[0]);
                if (null == json2JavaArray || json2JavaArray.length <= 0) continue;
                node.setProperty(key, (Object)json2JavaArray);
                continue;
            }
            if (value.getClass().equals(JSONObject.class)) {
                throw new IllegalArgumentException("The value for key \"" + key + "\" is a JSONObject. This is not allowed for node properties and thus cannot be set. The JSONObject to copy was: " + object);
            }
            node.setProperty(key, value);
        }
    }

    public static void mergeJSONObjectIntoPropertyContainer(JSONObject object, PropertyContainer node, String ... exclusions) throws JSONException {
        HashSet<String> exclusionSet = new HashSet<String>();
        for (int i = 0; i < exclusions.length; ++i) {
            String exclusion = exclusions[i];
            exclusionSet.add(exclusion);
        }
        PropertyUtilities.mergeJSONObjectIntoPropertyContainer(object, node, exclusionSet);
    }

    public static void mergeJSONObjectIntoPropertyContainer(JSONObject object, PropertyContainer node, Set<String> exclusions) throws JSONException {
        Iterator keys = object.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (null != exclusions && exclusions.contains(key)) continue;
            Object value = object.get(key);
            if (value.getClass().equals(JSONArray.class)) {
                PropertyUtilities.mergeArrayProperty(node, key, JSON.json2JavaArray((JSONArray)value, new Object[0]));
                continue;
            }
            if (value.getClass().equals(JSONObject.class)) {
                throw new IllegalArgumentException("The value for key \"" + key + "\" is a JSONObject. This is not allowed for node properties and thus cannot be set. The JSONObject to copy was: " + object);
            }
            PropertyUtilities.setNonNullNodeProperty(node, key, value);
        }
    }

    public static void mergePropertyContainerIntoPropertyContainer(Node from, Node to, String ... exclusions) {
        HashSet<String> exclusionSet = new HashSet<String>();
        for (int i = 0; i < exclusions.length; ++i) {
            String exclusion = exclusions[i];
            exclusionSet.add(exclusion);
        }
        PropertyUtilities.mergeJSONObjectIntoPropertyContainer(from, to, exclusionSet);
    }

    private static void mergeJSONObjectIntoPropertyContainer(Node from, Node to, Set<String> exclusions) {
        for (String key : from.getPropertyKeys()) {
            if (null != exclusions && exclusions.contains(key)) continue;
            Object value = from.getProperty(key);
            if (value.getClass().isArray()) {
                PropertyUtilities.mergeArrayProperty((PropertyContainer)to, key, (Object[])value);
                continue;
            }
            PropertyUtilities.setNonNullNodeProperty((PropertyContainer)to, key, value);
        }
    }

    public static <T> void mergeArrayProperty(PropertyContainer node, String key, T[] array) {
        try {
            if (null == array || array.length == 0) {
                return;
            }
            LinkedHashSet<Object> set = new LinkedHashSet<Object>();
            for (T o : array) {
                set.add(o);
            }
            if (node.hasProperty(key)) {
                Object storedArray = node.getProperty(key);
                for (int i = 0; i < Array.getLength(storedArray); ++i) {
                    set.add(Array.get(storedArray, i));
                }
            }
            Object[] newArray = (Object[])Array.newInstance(array[0].getClass(), set.size());
            try {
                set.toArray(newArray);
            }
            catch (ArrayStoreException e) {
                Object next = set.iterator().next();
                throw new IllegalArgumentException("Trying to merge array properties of different types (array class: " + newArray.getClass() + " element class: " + next.getClass() + ")");
            }
            node.setProperty(key, (Object)newArray);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception occurred while merging property \"" + key + "\" of property container \"" + node + "\" (value before merging: \"" + (node.hasProperty(key) ? node.getProperty(key) : null) + ")\" with data \"" + Arrays.toString(array) + "\" (object notation: \"" + array + "\").", e);
        }
    }

    public static <T> int addToArrayProperty(PropertyContainer node, String key, T value) {
        return PropertyUtilities.addToArrayProperty(node, key, value, false, false);
    }

    public static <T> int addToArrayProperty(PropertyContainer node, String key, T value, boolean allowDuplicates) {
        return PropertyUtilities.addToArrayProperty(node, key, value, allowDuplicates, false);
    }

    public static <T> int addToArrayProperty(PropertyContainer node, String key, T value, boolean allowDuplicates, boolean allowNullValues) {
        if (!allowNullValues && null == value) {
            return -1;
        }
        Object[] array = null;
        if (node.hasProperty(key)) {
            Object arrayProperty = node.getProperty(key);
            try {
                array = (Object[])arrayProperty;
            }
            catch (ClassCastException e) {
                array = JulieNeo4jUtilities.convertArray(arrayProperty);
            }
        } else {
            Object[] newArray = (Object[])Array.newInstance(value.getClass(), 1);
            newArray[0] = value;
            node.setProperty(key, (Object)newArray);
            return 0;
        }
        boolean valueFound = false;
        if (!allowDuplicates) {
            for (int i = 0; i < array.length; ++i) {
                Object element = array[i];
                if (!element.equals(value)) continue;
                valueFound = true;
                break;
            }
        }
        if (!valueFound || allowDuplicates) {
            Object[] newArray = (Object[])Array.newInstance(value.getClass(), array.length + 1);
            System.arraycopy(array, 0, newArray, 0, array.length);
            newArray[newArray.length - 1] = value;
            node.setProperty(key, (Object)newArray);
            return newArray.length - 1;
        }
        return -1;
    }

    public static void setNonNullNodeProperty(PropertyContainer node, String key, Object value) {
        if (null == value) {
            return;
        }
        if (node.hasProperty(key)) {
            return;
        }
        node.setProperty(key, value);
    }

    public static void setNonNullNodeProperty(PropertyContainer node, String key, Object value, Object defaultValue) {
        if (node.hasProperty(key)) {
            return;
        }
        if (null != value) {
            node.setProperty(key, value);
        } else {
            node.setProperty(key, defaultValue);
        }
    }

    public static Object getNonNullNodeProperty(PropertyContainer node, String key) {
        if (null != node && node.hasProperty(key)) {
            return node.getProperty(key);
        }
        return null;
    }

    public static String getNodePropertiesAsString(PropertyContainer node) {
        ArrayList<String> values = new ArrayList<String>();
        for (String pk : node.getPropertyKeys()) {
            Object p = node.getProperty(pk);
            if (p.getClass().isArray()) {
                values.add(pk + ": " + Arrays.toString(JulieNeo4jUtilities.convertArray(p)));
                continue;
            }
            values.add(pk + ": " + p);
        }
        return StringUtils.join(values, (String)" ; ");
    }

    public static int findFirstValueInArrayProperty(Node term, String key, String value) {
        if (!term.hasProperty(key)) {
            return -1;
        }
        Object property = term.getProperty(key);
        Object[] array = JulieNeo4jUtilities.convertArray(property);
        for (int i = 0; i < array.length; ++i) {
            if (null != array[i] && array[i].equals(value)) {
                return i;
            }
            if (null != array[i] || null != value) continue;
            return i;
        }
        return -1;
    }

    public static boolean hasSamePropertyValue(PropertyContainer term, String key, Object valueToCompare) {
        if (null != valueToCompare && !term.hasProperty(key)) {
            return false;
        }
        Object value = term.getProperty(key);
        return valueToCompare.equals(value);
    }

    public static boolean hasContradictingPropertyValue(PropertyContainer term, String key, Object valueToCompare) {
        if (null == term || null == valueToCompare || !term.hasProperty(key)) {
            return false;
        }
        Object value = term.getProperty(key);
        return !valueToCompare.equals(value);
    }

    public static boolean mergeProperties(PropertyContainer propContainer, Object ... properties) {
        boolean success = true;
        if (null != properties && properties.length > 0) {
            for (int i = 0; i < properties.length; i += 2) {
                String key = (String)properties[i];
                Object value = properties[i + 1];
                boolean passedValueIsArray = value.getClass().isArray();
                if (propContainer.hasProperty(key)) {
                    Object existingValue = propContainer.getProperty(key);
                    boolean existingValueIsArray = existingValue.getClass().isArray();
                    if (!existingValueIsArray && !value.equals(existingValue)) {
                        success = false;
                        continue;
                    }
                    if (existingValueIsArray != passedValueIsArray) {
                        throw new IllegalArgumentException("Trying to merge an array value with a non-array value.");
                    }
                    if (!existingValueIsArray) continue;
                    PropertyUtilities.mergeArrayProperty(propContainer, key, (Object[])value);
                    continue;
                }
                propContainer.setProperty(key, value);
            }
        }
        return success;
    }
}

