/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.neo4j.plugins.test;

import java.io.File;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Random;
import org.junit.Assert;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.index.IndexManager;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.server.rest.repr.ListRepresentation;
import org.neo4j.server.rest.repr.Representation;

public class TestUtilities {
    public static final File GRAPH_DB_DIR;
    public static final File GRAPH_DB_DIR_2;
    private static final Random random;
    private static final String[] symbols;

    public static String randomLetter() {
        return symbols[random.nextInt(symbols.length)];
    }

    public static void deleteEverythingInDB(GraphDatabaseService graphDb) {
        try (Transaction tx = graphDb.beginTx();){
            ResourceIterable nodes = graphDb.getAllNodes();
            for (Node n : nodes) {
                for (Relationship r : n.getRelationships()) {
                    r.delete();
                }
                n.delete();
            }
            tx.success();
        }
        tx = graphDb.beginTx();
        var2_2 = null;
        try {
            ResourceIterator nodeIt = graphDb.getAllNodes().iterator();
            Assert.assertFalse((boolean)nodeIt.hasNext());
            IndexManager indexManager = graphDb.index();
            for (String nodeIndex : indexManager.nodeIndexNames()) {
                indexManager.forNodes(nodeIndex).delete();
            }
            for (String relIndex : indexManager.relationshipIndexNames()) {
                indexManager.forNodes(relIndex).delete();
            }
            for (ConstraintDefinition cd : graphDb.schema().getConstraints()) {
                cd.drop();
            }
            for (IndexDefinition id : graphDb.schema().getIndexes()) {
                id.drop();
            }
            tx.success();
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var2_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    public static <T extends Representation> List<T> getListFromListRepresentation(ListRepresentation listrep) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field responseContent = ListRepresentation.class.getDeclaredField("content");
        responseContent.setAccessible(true);
        List content = (List)responseContent.get(listrep);
        return content;
    }

    public static <T extends Representation> Iterable<T> getIterableFromListRepresentation(ListRepresentation listrep) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field responseContent = ListRepresentation.class.getDeclaredField("content");
        responseContent.setAccessible(true);
        Iterable content = (Iterable)responseContent.get(listrep);
        return content;
    }

    public static GraphDatabaseService getGraphDB() {
        GraphDatabaseService database = new GraphDatabaseFactory().newEmbeddedDatabase(GRAPH_DB_DIR);
        return database;
    }

    public static void printNodeProperties(Node n) {
        for (String k : n.getPropertyKeys()) {
            System.out.println(k + ": " + n.getProperty(k));
        }
    }

    static {
        int idx;
        GRAPH_DB_DIR = new File("src/test/resources/graph.db");
        GRAPH_DB_DIR_2 = new File("src/test/resources/test");
        random = new Random();
        symbols = new String[36];
        for (idx = 0; idx < 10; ++idx) {
            TestUtilities.symbols[idx] = String.valueOf((char)(48 + idx));
        }
        for (idx = 10; idx < 36; ++idx) {
            TestUtilities.symbols[idx] = String.valueOf((char)(97 + idx - 10));
        }
    }
}

