/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import com.google.common.primitives.Booleans;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import de.julielab.neo4j.plugins.auxiliaries.NodeRepresentation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.neo4j.graphdb.Node;
import org.neo4j.server.rest.repr.ListRepresentation;
import org.neo4j.server.rest.repr.MappingRepresentation;
import org.neo4j.server.rest.repr.MappingSerializer;
import org.neo4j.server.rest.repr.Representation;
import org.neo4j.server.rest.repr.RepresentationType;
import org.neo4j.server.rest.repr.ValueRepresentation;

public class RecursiveMappingRepresentation
extends MappingRepresentation {
    private Map<String, Object> map;

    public RecursiveMappingRepresentation(String type, Map<String, Object> map) {
        super(type);
        this.map = map;
    }

    protected RecursiveMappingRepresentation(String type) {
        super(type);
    }

    protected void serialize(MappingSerializer serializer) {
        for (Map.Entry<String, Object> pair : this.map.entrySet()) {
            this.serialize(pair.getKey(), pair.getValue(), serializer);
        }
    }

    public Map<String, Object> getUnderlyingMap() {
        return this.map;
    }

    protected void setUnderlyingMap(Map<String, Object> map) {
        if (null != this.map) {
            throw new IllegalAccessError("The underlying map must only be set once.");
        }
        this.map = map;
    }

    protected void serialize(String key, Object value, MappingSerializer serializer) {
        if (key == null || key.length() == 0 || value == null) {
            return;
        }
        Class<?> valueClass = value.getClass();
        if (Map.class.isAssignableFrom(valueClass)) {
            RecursiveMappingRepresentation matchRep = new RecursiveMappingRepresentation(Representation.MAP, (Map)value);
            serializer.putMapping(key, (MappingRepresentation)matchRep);
        } else if (valueClass.equals(String.class)) {
            serializer.putString(key, (String)value);
        } else if (valueClass.isArray()) {
            Class<?> componentType = valueClass.getComponentType();
            if (componentType.equals(Integer.TYPE)) {
                int[] array = (int[])value;
                serializer.putList(key, RecursiveMappingRepresentation.getIterableRepresentation(Ints.asList((int[])array)));
            } else if (componentType.equals(Long.TYPE)) {
                long[] array = (long[])value;
                serializer.putList(key, RecursiveMappingRepresentation.getIterableRepresentation(Longs.asList((long[])array)));
            } else if (componentType.equals(Double.TYPE)) {
                double[] array = (double[])value;
                serializer.putList(key, RecursiveMappingRepresentation.getIterableRepresentation(Doubles.asList((double[])array)));
            } else if (componentType.equals(Boolean.TYPE)) {
                boolean[] array = (boolean[])value;
                serializer.putList(key, RecursiveMappingRepresentation.getIterableRepresentation(Booleans.asList((boolean[])array)));
            } else {
                Object[] array = (Object[])value;
                serializer.putList(key, RecursiveMappingRepresentation.getIterableRepresentation(Arrays.asList(array)));
            }
        } else if (List.class.isAssignableFrom(valueClass)) {
            serializer.putList(key, RecursiveMappingRepresentation.getIterableRepresentation((Iterable)value));
        } else if (Set.class.isAssignableFrom(valueClass)) {
            serializer.putList(key, RecursiveMappingRepresentation.getIterableRepresentation((Iterable)value));
        } else if (valueClass.equals(Boolean.class)) {
            serializer.putBoolean(key, ((Boolean)value).booleanValue());
        } else if (Number.class.isAssignableFrom(valueClass)) {
            serializer.putNumber(key, (Number)value);
        } else if (Node.class.isAssignableFrom(valueClass)) {
            NodeRepresentation nodeMap = new NodeRepresentation((Node)value);
            serializer.putMapping(key, (MappingRepresentation)nodeMap);
        } else {
            throw new IllegalArgumentException("Encountered " + valueClass + ". This class is currently not supported.");
        }
    }

    public static Representation getObjectRepresentation(Object value) {
        RecursiveMappingRepresentation rep = null;
        Class<?> valueClass = value.getClass();
        if (Map.class.isAssignableFrom(valueClass)) {
            rep = new RecursiveMappingRepresentation(Representation.MAP, (Map)value);
        } else if (valueClass.equals(String.class)) {
            rep = ValueRepresentation.string((String)((String)value));
        } else if (valueClass.isArray()) {
            rep = RecursiveMappingRepresentation.getArrayRepresentation(value);
        } else if (Iterable.class.isAssignableFrom(valueClass)) {
            rep = RecursiveMappingRepresentation.getIterableRepresentation((Iterable)value);
        } else if (valueClass.equals(Boolean.class)) {
            rep = ValueRepresentation.bool((boolean)((Boolean)value));
        } else if (valueClass.equals(String.class)) {
            rep = ValueRepresentation.string((String)((String)value));
        } else if (Number.class.isAssignableFrom(valueClass)) {
            rep = RecursiveMappingRepresentation.getNumberRepresentation((Number)value, valueClass);
        } else if (Node.class.isAssignableFrom(valueClass)) {
            rep = new NodeRepresentation((Node)value);
        } else {
            throw new IllegalArgumentException("Encountered " + valueClass + ". This class is currently not supported.");
        }
        return rep;
    }

    private static ListRepresentation getArrayRepresentation(Object arrayObject) {
        ArrayList<Representation> repList;
        Class<?> arrayClass = arrayObject.getClass();
        if (arrayClass.equals(int[].class)) {
            int[] array = (int[])arrayObject;
            repList = new ArrayList<Representation>();
            for (int i = 0; i < array.length; ++i) {
                repList.add(RecursiveMappingRepresentation.getObjectRepresentation(array[i]));
            }
        } else if (arrayClass.equals(byte[].class)) {
            byte[] array = (byte[])arrayObject;
            repList = new ArrayList();
            for (int i = 0; i < array.length; ++i) {
                repList.add(RecursiveMappingRepresentation.getObjectRepresentation(array[i]));
            }
        } else if (arrayClass.equals(short[].class)) {
            short[] array = (short[])arrayObject;
            repList = new ArrayList();
            for (int i = 0; i < array.length; ++i) {
                repList.add(RecursiveMappingRepresentation.getObjectRepresentation(array[i]));
            }
        } else if (arrayClass.equals(double[].class)) {
            double[] array = (double[])arrayObject;
            repList = new ArrayList();
            for (int i = 0; i < array.length; ++i) {
                repList.add(RecursiveMappingRepresentation.getObjectRepresentation(array[i]));
            }
        } else if (arrayClass.equals(float[].class)) {
            float[] array = (float[])arrayObject;
            repList = new ArrayList();
            for (int i = 0; i < array.length; ++i) {
                repList.add(RecursiveMappingRepresentation.getObjectRepresentation(Float.valueOf(array[i])));
            }
        } else {
            Object[] array = (Object[])arrayObject;
            repList = new ArrayList();
            for (int i = 0; i < array.length; ++i) {
                repList.add(RecursiveMappingRepresentation.getObjectRepresentation(array[i]));
            }
        }
        ListRepresentation rep = new ListRepresentation(RepresentationType.TEMPLATE, repList);
        return rep;
    }

    public static ListRepresentation getIterableRepresentation(Iterable<?> value) {
        ArrayList<Representation> repList = new ArrayList<Representation>();
        Iterable<?> iterable = value;
        for (Object o : iterable) {
            repList.add(RecursiveMappingRepresentation.getObjectRepresentation(o));
        }
        ListRepresentation rep = new ListRepresentation(RepresentationType.TEMPLATE, repList);
        return rep;
    }

    public static <T extends Number> Representation getNumberRepresentation(T value, Class<?> valueClass) {
        ValueRepresentation rep = null;
        if (valueClass.equals(Integer.TYPE) || valueClass.equals(Integer.class)) {
            rep = ValueRepresentation.number((int)((Integer)value));
        } else if (valueClass.equals(Double.TYPE) || valueClass.equals(Double.class)) {
            rep = ValueRepresentation.number((double)((Double)value));
        } else if (valueClass.equals(Long.TYPE) || valueClass.equals(Long.class)) {
            rep = ValueRepresentation.number((long)((Long)value));
        } else if (valueClass.equals(Float.TYPE) || valueClass.equals(Float.class)) {
            rep = ValueRepresentation.number((double)((Float)value).floatValue());
        } else if (valueClass.equals(Short.TYPE) || valueClass.equals(Short.class)) {
            rep = ValueRepresentation.number((int)((Short)value).shortValue());
        } else if (valueClass.equals(Byte.TYPE) || valueClass.equals(Byte.class)) {
            rep = ValueRepresentation.number((int)((Byte)value).byteValue());
        } else {
            throw new IllegalArgumentException("Encountered " + valueClass + ". This class is currently not supported.");
        }
        return rep;
    }
}

