/*
 * Decompiled with CFR 0.152.
 */
package salvo.jesus.graph;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import salvo.jesus.graph.DirectedEdge;
import salvo.jesus.graph.DirectedGraph;
import salvo.jesus.graph.Edge;
import salvo.jesus.graph.GraphAddEdgeEvent;
import salvo.jesus.graph.GraphAddVertexEvent;
import salvo.jesus.graph.GraphImpl;
import salvo.jesus.graph.GraphListener;
import salvo.jesus.graph.GraphRemoveEdgeEvent;
import salvo.jesus.graph.GraphRemoveVertexEvent;
import salvo.jesus.graph.StopAtVisitor;
import salvo.jesus.graph.Vertex;
import salvo.jesus.graph.adaptor.GraphDelegator;

class DirectedGraphWeakImpl
extends GraphDelegator
implements DirectedGraph,
GraphListener {
    private Map vertexDataMap = new HashMap();

    public DirectedGraphWeakImpl(GraphImpl graph) {
        super(graph);
        graph.addListener(this);
    }

    protected DirectedVertexData getVertexData(Vertex v) {
        return (DirectedVertexData)this.vertexDataMap.get(v);
    }

    @Override
    public List getOutgoingEdges(Vertex v) {
        return this.getVertexData(v).getUnmodifiableOutgoingEdges();
    }

    @Override
    public List getIncomingEdges(Vertex v) {
        return this.getVertexData(v).getUnmodifiableIncomingEdges();
    }

    private List getAdjacentVertices(Vertex v, boolean outGoing) {
        ArrayList<Vertex> adjacentVertices = new ArrayList<Vertex>(10);
        List incidentEdges = outGoing ? this.getOutgoingEdges(v) : this.getIncomingEdges(v);
        for (Edge edge : incidentEdges) {
            Vertex oppositeVertex = edge.getOppositeVertex(v);
            adjacentVertices.add(oppositeVertex);
        }
        return Collections.unmodifiableList(adjacentVertices);
    }

    @Override
    public List getOutgoingAdjacentVertices(Vertex v) {
        return this.getAdjacentVertices(v, true);
    }

    @Override
    public List getIncomingAdjacentVertices(Vertex v) {
        return this.getAdjacentVertices(v, false);
    }

    @Override
    public DirectedEdge getEdge(Vertex fromvertex, Vertex tovertex) {
        List outIncidentEdges = this.getOutgoingEdges(fromvertex);
        Iterator iterator = outIncidentEdges.iterator();
        while (iterator.hasNext()) {
            DirectedEdge edge = (DirectedEdge)iterator.next();
            if (edge.getSink() != tovertex) continue;
            iterator = null;
            return edge;
        }
        return null;
    }

    @Override
    public boolean isPath(Vertex fromVertex, Vertex toVertex) {
        StopAtVisitor visitor = new StopAtVisitor(toVertex);
        this.getGraph().getTraversal().traverse(fromVertex, visitor);
        return visitor.wasFound();
    }

    @Override
    public boolean isCycle(Vertex fromVertex) {
        List outedges = this.getOutgoingEdges(fromVertex);
        for (DirectedEdge dedge : outedges) {
            Vertex adjacentVertex = dedge.getOppositeVertex(fromVertex);
            if (!this.isPath(adjacentVertex, fromVertex)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void beforeVertexAdded(GraphAddVertexEvent event) {
    }

    @Override
    public void beforeVertexRemoved(GraphRemoveVertexEvent event) {
    }

    @Override
    public void beforeEdgeAdded(GraphAddEdgeEvent event) throws ClassCastException {
        DirectedEdge dedge = (DirectedEdge)event.getEdge();
    }

    @Override
    public void beforeEdgeRemoved(GraphRemoveEdgeEvent event) {
    }

    @Override
    public void afterVertexAdded(GraphAddVertexEvent event) {
        this.vertexDataMap.put(event.getVertex(), new DirectedVertexData());
    }

    @Override
    public void afterVertexRemoved(GraphRemoveVertexEvent event) {
        this.vertexDataMap.remove(event.getVertex());
    }

    @Override
    public void afterEdgeAdded(GraphAddEdgeEvent event) {
        DirectedEdge dedge = (DirectedEdge)event.getEdge();
        DirectedVertexData vd1 = this.getVertexData(dedge.getSource());
        DirectedVertexData vd2 = this.getVertexData(dedge.getSink());
        vd1.getOutgoingEdges().add(dedge);
        vd2.getIncomingEdges().add(dedge);
    }

    @Override
    public void afterEdgeRemoved(GraphRemoveEdgeEvent event) {
        DirectedEdge dedge = (DirectedEdge)event.getEdge();
        Vertex fromvertex = dedge.getSource();
        Vertex tovertex = dedge.getSink();
        DirectedVertexData vdFrom = this.getVertexData(fromvertex);
        DirectedVertexData vdTo = this.getVertexData(tovertex);
        vdFrom.getOutgoingEdges().remove(dedge);
        vdTo.getIncomingEdges().remove(dedge);
    }

    private class DirectedVertexData
    implements Serializable {
        private ArrayList incomingEdges = new ArrayList();
        private ArrayList outgoingEdges = new ArrayList();
        private List unmodifiableIncomingEdges;
        private List unmodifiableOutgoingEdges;

        DirectedVertexData() {
        }

        final List getIncomingEdges() {
            return this.incomingEdges;
        }

        final List getOutgoingEdges() {
            return this.outgoingEdges;
        }

        public final List getUnmodifiableIncomingEdges() {
            if (this.unmodifiableIncomingEdges == null) {
                this.unmodifiableIncomingEdges = Collections.unmodifiableList(this.incomingEdges);
            }
            return this.unmodifiableIncomingEdges;
        }

        public final List getUnmodifiableOutgoingEdges() {
            if (this.unmodifiableOutgoingEdges == null) {
                this.unmodifiableOutgoingEdges = Collections.unmodifiableList(this.outgoingEdges);
            }
            return this.unmodifiableOutgoingEdges;
        }
    }
}

