/*
 * Decompiled with CFR 0.152.
 */
package salvo.jesus.graph;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import salvo.jesus.graph.DirectedGraph;
import salvo.jesus.graph.Edge;
import salvo.jesus.graph.Graph;
import salvo.jesus.graph.Vertex;

public class GraphUtil {
    public static void mergeInto(Graph gDst, Graph gSrc) {
        Vertex v;
        Iterator vertexIter = gSrc.getVerticesIterator();
        while (vertexIter.hasNext()) {
            v = (Vertex)vertexIter.next();
            GraphUtil.addVertex(gDst, v);
        }
        vertexIter = gSrc.getVerticesIterator();
        while (vertexIter.hasNext()) {
            v = (Vertex)vertexIter.next();
            for (Edge edge : gSrc.getEdges(v)) {
                if (edge.getVertexA() != v) continue;
                GraphUtil.addEdge(gDst, edge);
            }
        }
    }

    public static void addVertex(Graph g, Vertex v) {
        try {
            g.add(v);
        }
        catch (Exception ex) {
            GraphUtil.throwUnexpectedException(ex);
        }
    }

    public static void addEdge(Graph g, Edge e) {
        try {
            g.addEdge(e);
        }
        catch (Exception ex) {
            GraphUtil.throwUnexpectedException(ex);
        }
    }

    public static void addEdge(Graph g, Vertex v1, Vertex v2) {
        try {
            g.addEdge(v1, v2);
        }
        catch (Exception ex) {
            GraphUtil.throwUnexpectedException(ex);
        }
    }

    public static void removeVertex(Graph g, Vertex v) {
        try {
            g.remove(v);
        }
        catch (Exception ex) {
            GraphUtil.throwUnexpectedException(ex);
        }
    }

    public static void removeEdge(Graph g, Edge e) {
        try {
            g.removeEdge(e);
        }
        catch (Exception ex) {
            GraphUtil.throwUnexpectedException(ex);
        }
    }

    private static void throwUnexpectedException(Exception ex) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ex.printStackTrace(pw);
        pw.flush();
        throw new RuntimeException("unexpected graph mutator exception " + ex.getClass().getName() + ": " + ex.getMessage() + "\n" + sw.toString());
    }

    public static void contractVertices(Graph g, Vertex vRemain, Vertex vRemove, EdgeContractionRule rule) {
        if (vRemove == vRemain) {
            return;
        }
        List edgeList = g.getEdges(vRemove);
        if (edgeList == null) {
            edgeList = Collections.EMPTY_LIST;
        }
        for (Edge edge : edgeList) {
            Vertex vB;
            Vertex vA;
            Vertex opposite = edge.getOppositeVertex(vRemove);
            if (opposite == vRemain && (rule == null || !rule.shouldBeSelfLoop(edge))) continue;
            if (opposite == vRemove && rule != null && rule.shouldBeSelfLoop(edge)) {
                opposite = vRemain;
            }
            if (vRemove == edge.getVertexA()) {
                vA = vRemain;
                vB = opposite;
            } else {
                vA = opposite;
                vB = vRemain;
            }
            Edge newEdge = rule != null ? rule.cloneEdge(edge, vA, vB) : g.getGraphFactory().createEdge(vA, vB);
            GraphUtil.addEdge(g, newEdge);
        }
        GraphUtil.removeVertex(g, vRemove);
    }

    public static boolean detectCycles(DirectedGraph graph) {
        Iterator vertexIter = graph.getVerticesIterator();
        while (vertexIter.hasNext()) {
            Vertex v = (Vertex)vertexIter.next();
            if (!graph.isCycle(v)) continue;
            return true;
        }
        return false;
    }

    public static interface EdgeContractionRule {
        public boolean shouldBeSelfLoop(Edge var1);

        public Edge cloneEdge(Edge var1, Vertex var2, Vertex var3);
    }
}

