/*
 * Decompiled with CFR 0.152.
 */
package salvo.jesus.graph;

import salvo.jesus.graph.DirectedEdge;
import salvo.jesus.graph.Edge;
import salvo.jesus.graph.LabeledEdge;
import salvo.jesus.graph.LabeledGraphComponentImpl;
import salvo.jesus.graph.WeightedEdge;

public class LabeledEdgeImpl
extends LabeledGraphComponentImpl
implements LabeledEdge {
    private boolean followVertexLabel = true;
    private Edge edgeBeingLabelled;

    public LabeledEdgeImpl(Edge edge) {
        this.edgeBeingLabelled = edge;
    }

    @Override
    public boolean isFollowVertexLabel() {
        return this.followVertexLabel;
    }

    @Override
    public void setFollowVertexLabel(boolean isFollow) {
        this.followVertexLabel = isFollow;
    }

    @Override
    public String getLabel() {
        if (this.followVertexLabel) {
            String strB;
            String strA;
            if (this.edgeBeingLabelled instanceof DirectedEdge) {
                DirectedEdge dEdge = (DirectedEdge)this.edgeBeingLabelled;
                strA = dEdge.getSource().getLabel();
                strB = dEdge.getSink().getLabel();
            } else {
                strA = this.edgeBeingLabelled.getVertexA().getLabel();
                strB = this.edgeBeingLabelled.getVertexB().getLabel();
            }
            StringBuffer tmpString = new StringBuffer();
            tmpString.append(strA == null ? "<Null vertex>" : strA);
            tmpString.append("-");
            if (this.edgeBeingLabelled instanceof DirectedEdge) {
                tmpString.append(">");
            }
            tmpString.append(strB == null ? "<Null vertex>" : strB);
            if (this.edgeBeingLabelled instanceof WeightedEdge) {
                WeightedEdge wEdge = (WeightedEdge)this.edgeBeingLabelled;
                tmpString.append(" (" + wEdge.getWeight() + ")");
            }
            return tmpString.toString();
        }
        return super.getLabel();
    }

    @Override
    public void setLabel(String label) {
        if (this.followVertexLabel) {
            throw new IllegalStateException("edge label is dynamically derived from vertices' label");
        }
        super.setLabel(label);
    }
}

