/*
 * Decompiled with CFR 0.152.
 */
package salvo.jesus.graph.adaptor;

import java.util.List;
import salvo.jesus.graph.CycleException;
import salvo.jesus.graph.DirectedAcyclicGraph;
import salvo.jesus.graph.DirectedGraph;
import salvo.jesus.graph.Vertex;
import salvo.jesus.graph.adaptor.DirectedGraphDelegator;
import salvo.jesus.graph.algorithm.CycleDetectionAlgorithm;
import salvo.jesus.graph.algorithm.CycleDetectionAlgorithmDFS;
import salvo.jesus.graph.algorithm.TopologicalSorting;
import salvo.jesus.graph.listener.DirectedAcyclicGraphListener;

public class DirectedAcyclicGraphAdaptor
extends DirectedGraphDelegator
implements DirectedAcyclicGraph {
    private TopologicalSorting m_sorter;
    private DirectedAcyclicGraphListener m_listener;

    public DirectedAcyclicGraphAdaptor(DirectedGraph graph) throws CycleException {
        super(graph);
        CycleDetectionAlgorithmDFS cycleDetector = new CycleDetectionAlgorithmDFS(graph);
        if (((CycleDetectionAlgorithm)cycleDetector).detectCycles()) {
            throw new CycleException();
        }
        this.m_listener = new DirectedAcyclicGraphListener(this);
        this.m_sorter = new TopologicalSorting(this);
    }

    public void destroy() {
        this.removeListener(this.m_listener);
    }

    @Override
    public List getRoot() {
        return this.m_listener.getRoot();
    }

    @Override
    public List topologicalSort() {
        return this.m_sorter.traverse();
    }

    @Override
    public List reverseTopologicalSort() {
        return this.m_sorter.reverseTraverse();
    }

    @Override
    public List topologicalSort(Vertex startat) {
        return this.m_sorter.traverse(startat);
    }

    @Override
    public List reverseTopologicalSort(Vertex startat) {
        return this.m_sorter.reverseTraverse(startat);
    }
}

