/*
 * Decompiled with CFR 0.152.
 */
package salvo.jesus.graph.algorithm;

import java.util.Iterator;
import salvo.jesus.graph.DirectedEdge;
import salvo.jesus.graph.DirectedGraph;
import salvo.jesus.graph.Edge;
import salvo.jesus.graph.Graph;
import salvo.jesus.graph.Vertex;
import salvo.jesus.graph.algorithm.CycleDetectionAlgorithm;

public class CycleDetectionAlgorithmDFS
extends CycleDetectionAlgorithm {
    public CycleDetectionAlgorithmDFS(Graph graph) {
        super(graph);
        if (!(graph instanceof DirectedGraph)) {
            throw new IllegalArgumentException("cycle detection in undirected graphs not yet implemented");
        }
    }

    @Override
    public void findCycleSubgraph(Graph subgraph) throws Exception {
        for (Edge e : this.m_graph.getEdgeSet()) {
            if (!this.detectCycles(e)) continue;
            subgraph.addEdge(e);
        }
    }

    @Override
    public void findCycleSubgraph(Graph subgraph, Vertex v) throws Exception {
        DirectedGraph directedGraph = (DirectedGraph)this.m_graph;
        for (DirectedEdge e : this.m_graph.getEdgeSet()) {
            if (!directedGraph.isPath(e.getSink(), v) || !directedGraph.isPath(v, e.getSource())) continue;
            subgraph.addEdge(e);
        }
    }

    @Override
    public void findCycleSubgraph(Graph subgraph, Edge e) throws Exception {
        DirectedEdge d1 = (DirectedEdge)e;
        DirectedGraph directedGraph = (DirectedGraph)this.m_graph;
        for (DirectedEdge d2 : this.m_graph.getEdgeSet()) {
            if (!directedGraph.isPath(d1.getSink(), d2.getSource()) || !directedGraph.isPath(d2.getSink(), d1.getSource())) continue;
            subgraph.addEdge(d2);
        }
    }

    @Override
    public boolean detectCycles() {
        Iterator vertexIter = this.m_graph.getVerticesIterator();
        while (vertexIter.hasNext()) {
            Vertex v = (Vertex)vertexIter.next();
            if (!this.detectCycles(v)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean detectCycles(Vertex v) {
        return ((DirectedGraph)this.m_graph).isCycle(v);
    }

    @Override
    public boolean detectCycles(Edge e) {
        DirectedEdge directedEdge = (DirectedEdge)e;
        return ((DirectedGraph)this.m_graph).isPath(directedEdge.getSink(), directedEdge.getSource());
    }
}

