/*
 * Decompiled with CFR 0.152.
 */
package salvo.jesus.graph.algorithm;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import salvo.jesus.graph.Edge;
import salvo.jesus.graph.Graph;
import salvo.jesus.graph.GraphImpl;
import salvo.jesus.graph.Path;
import salvo.jesus.graph.PathImpl;
import salvo.jesus.graph.Vertex;
import salvo.jesus.graph.algorithm.NoEulerCircleException;

public class EulerCircleFinder {
    private static final EulerCircleFinder s_Singleton = new EulerCircleFinder();
    private Graph m_Graph;

    private static EulerCircleFinder getSingletonInstance() {
        return s_Singleton;
    }

    private EulerCircleFinder() {
    }

    private void setGraph(Graph g) {
        if (g.getVerticesCount() == 0) {
            throw new IllegalArgumentException("Graph has no vertices");
        }
        try {
            this.m_Graph = EulerCircleFinder.clone(g);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Exception while creating copy of the Graph");
        }
    }

    private Graph getGraph() {
        return this.m_Graph;
    }

    private static void addCircle(List targetCircle, List newCircle) {
        if (newCircle.size() == 0 || newCircle.get(0) != newCircle.get(newCircle.size() - 1)) {
            throw new IllegalArgumentException();
        }
        int position = targetCircle.indexOf(newCircle.get(0));
        targetCircle.remove(position);
        targetCircle.addAll(position, newCircle);
    }

    private void removeEdges(List edgesToRemove) throws Exception {
        Iterator it = edgesToRemove.iterator();
        while (it.hasNext()) {
            this.getGraph().removeEdge((Edge)it.next());
        }
        Set lostVertices = this.getGraph().getVertices(0);
        Iterator it2 = lostVertices.iterator();
        while (it2.hasNext()) {
            this.getGraph().remove((Vertex)it2.next());
        }
    }

    private Edge findUnusedEdge(Vertex v, List usedEdges) {
        List vertexEdges = this.getGraph().getEdges(v);
        vertexEdges.removeAll(usedEdges);
        if (vertexEdges.size() > 0) {
            return (Edge)vertexEdges.get(0);
        }
        return null;
    }

    public static Path find(Graph g) {
        EulerCircleFinder.getSingletonInstance().setGraph(g);
        try {
            List eulerCirlce = EulerCircleFinder.getSingletonInstance().findEulerCircle((Vertex)EulerCircleFinder.getSingletonInstance().getGraph().getVerticesIterator().next());
            PathImpl eulerPath = new PathImpl();
            Iterator it = eulerCirlce.iterator();
            while (it.hasNext()) {
                try {
                    eulerPath.add((Vertex)it.next());
                }
                catch (Exception e) {
                    System.err.println("Could not create Path-Object. Path vertices are: " + eulerCirlce);
                    System.err.println("Original Exception was");
                    e.printStackTrace();
                }
            }
            return eulerPath;
        }
        catch (NoEulerCircleException nece) {
            return null;
        }
    }

    private List findEulerCircle(Vertex startVertex) throws NoEulerCircleException {
        switch (this.getGraph().getVerticesCount()) {
            case 0: {
                throw new RuntimeException("Error in finding algorithm");
            }
            case 1: {
                return Arrays.asList(startVertex);
            }
        }
        Vertex currentVertex = startVertex;
        LinkedList<Edge> visitedEdges = new LinkedList<Edge>();
        LinkedList<Vertex> visitedVertices = new LinkedList<Vertex>();
        visitedVertices.add(startVertex);
        do {
            Edge unusedEdge;
            if ((unusedEdge = this.findUnusedEdge(currentVertex, visitedEdges)) == null) {
                throw new NoEulerCircleException();
            }
            currentVertex = unusedEdge.getOppositeVertex(currentVertex);
            visitedEdges.add(unusedEdge);
            visitedVertices.add(currentVertex);
        } while (startVertex != currentVertex);
        try {
            this.removeEdges(visitedEdges);
        }
        catch (Exception e) {
            throw new RuntimeException("Error in finding algorithm");
        }
        LinkedList primaryCircle = new LinkedList(visitedVertices);
        for (Vertex v : primaryCircle) {
            if (!this.getGraph().cloneVertices().contains(v)) continue;
            EulerCircleFinder.addCircle(visitedVertices, this.findEulerCircle(v));
        }
        return visitedVertices;
    }

    public static Graph clone(Graph g) throws Exception {
        Vertex v;
        GraphImpl clone = new GraphImpl();
        Iterator vertexIt = g.getVerticesIterator();
        while (vertexIt.hasNext()) {
            v = (Vertex)vertexIt.next();
            clone.add(v);
        }
        vertexIt = clone.getVerticesIterator();
        while (vertexIt.hasNext()) {
            v = (Vertex)vertexIt.next();
            List edges = g.getEdges(v);
            for (Edge e : edges) {
                if (e.getVertexA() != v) continue;
                clone.addEdge(e);
            }
        }
        return clone;
    }
}

