/*
 * Decompiled with CFR 0.152.
 */
package salvo.jesus.graph.algorithm;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import salvo.jesus.graph.Edge;
import salvo.jesus.graph.Graph;
import salvo.jesus.graph.GraphComponent;
import salvo.jesus.graph.Vertex;

public abstract class GraphContractionAlgorithm {
    private Graph m_graph;
    private Map m_contractionMap;

    protected GraphContractionAlgorithm(Graph graph) {
        this.m_graph = graph;
        this.m_contractionMap = new HashMap();
    }

    public Graph getGraph() {
        return this.m_graph;
    }

    public void contractVertexPair(Vertex vRemain, Vertex vRemove) throws Exception {
        if ((vRemove = this.getContractionVertex(vRemove)) == (vRemain = this.getContractionVertex(vRemain))) {
            return;
        }
        List edgeList = this.m_graph.getEdges(vRemove);
        if (edgeList == null) {
            edgeList = Collections.EMPTY_LIST;
        }
        for (Edge edge : edgeList) {
            Vertex opposite = edge.getOppositeVertex(vRemove);
            if (opposite == vRemain && !this.shouldBeSelfLoop(edge)) continue;
            if (opposite == vRemove && this.shouldBeSelfLoop(edge)) {
                opposite = vRemain;
            }
            Edge newEdge = vRemove == edge.getVertexA() ? this.copyEdge(edge, vRemain, opposite) : this.copyEdge(edge, opposite, vRemain);
            this.m_contractionMap.put(edge, newEdge);
        }
        this.m_graph.remove(vRemove);
        this.m_contractionMap.put(vRemove, vRemain);
    }

    public void contractVertices(Collection vertices) throws Exception {
        Iterator iter = vertices.iterator();
        if (!iter.hasNext()) {
            return;
        }
        Vertex vRemain = (Vertex)iter.next();
        while (iter.hasNext()) {
            Vertex vRemove = (Vertex)iter.next();
            this.contractVertexPair(vRemain, vRemove);
        }
    }

    public void contractEdges(Collection edges) throws Exception {
        for (Edge edge : edges) {
            this.contractVertexPair(edge.getVertexA(), edge.getVertexB());
        }
    }

    public Vertex getContractionVertex(Vertex v) {
        return (Vertex)this.getContractionResult(v);
    }

    public Edge getContractionEdge(Edge edge) {
        return (Edge)this.getContractionResult(edge);
    }

    public GraphComponent getContractionResult(GraphComponent c) {
        GraphComponent c2 = (GraphComponent)this.m_contractionMap.get(c);
        if (c2 == null) {
            return c;
        }
        GraphComponent c3 = this.getContractionResult(c2);
        if (c3 != c2) {
            this.m_contractionMap.put(c, c3);
        }
        return c3;
    }

    protected abstract boolean shouldBeSelfLoop(Edge var1);

    protected abstract Edge copyEdge(Edge var1, Vertex var2, Vertex var3) throws Exception;
}

