/*
 * Decompiled with CFR 0.152.
 */
package salvo.jesus.graph.algorithm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import salvo.jesus.graph.GraphImpl;
import salvo.jesus.graph.Vertex;
import salvo.jesus.graph.WeightedEdge;
import salvo.jesus.graph.WeightedGraph;
import salvo.jesus.graph.WeightedGraphImpl;
import salvo.jesus.graph.algorithm.MinimumSpanningTreeAlgorithm;

public class MinimumSpanningTreeKruskalAlgorithm
extends MinimumSpanningTreeAlgorithm {
    public MinimumSpanningTreeKruskalAlgorithm(WeightedGraph wgraph) {
        super(wgraph);
    }

    @Override
    public WeightedGraph minimumSpanningTree() {
        HashSet<WeightedEdge> allEdges = new HashSet<WeightedEdge>();
        WeightedGraphImpl spanningtree = new WeightedGraphImpl();
        GraphImpl spanningtestgraph = new GraphImpl();
        ArrayList<Vertex> addedvertices = new ArrayList<Vertex>(10);
        Iterator iterator = this.wgraph.getVerticesIterator();
        while (iterator.hasNext()) {
            List incidentEdges = this.wgraph.getEdges((Vertex)iterator.next());
            Iterator edgeiterator = incidentEdges.iterator();
            while (edgeiterator.hasNext()) {
                allEdges.add((WeightedEdge)edgeiterator.next());
            }
        }
        ArrayList listEdges = new ArrayList(allEdges);
        Collections.sort(listEdges, new Comparator(){

            public int compare(Object obj1, Object obj2) {
                WeightedEdge edge1 = (WeightedEdge)obj1;
                WeightedEdge edge2 = (WeightedEdge)obj2;
                if (edge1.getWeight() < edge2.getWeight()) {
                    return -1;
                }
                if (edge1.getWeight() > edge2.getWeight()) {
                    return 1;
                }
                return 0;
            }

            @Override
            public boolean equals(Object obj) {
                return obj.equals(this);
            }
        });
        for (WeightedEdge edge : listEdges) {
            Vertex v1 = edge.getVertexA();
            Vertex v2 = edge.getVertexB();
            try {
                if (!addedvertices.contains(v1)) {
                    spanningtestgraph.add(v1);
                    addedvertices.add(v1);
                }
                if (!addedvertices.contains(v2)) {
                    spanningtestgraph.add(v2);
                    addedvertices.add(v2);
                }
                if (spanningtestgraph.isConnected(v1, v2)) continue;
                spanningtestgraph.addEdge(v1, v2);
                spanningtree.addEdge(edge);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        spanningtestgraph = null;
        return spanningtree;
    }
}

