/*
 * Decompiled with CFR 0.152.
 */
package salvo.jesus.graph.algorithm;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import salvo.jesus.graph.Vertex;
import salvo.jesus.graph.WeightedEdge;
import salvo.jesus.graph.WeightedGraph;
import salvo.jesus.graph.WeightedGraphImpl;
import salvo.jesus.graph.algorithm.FringeObject;
import salvo.jesus.graph.algorithm.HeapNodeObjectComparator;
import salvo.jesus.graph.algorithm.ShortestPathAlgorithm;
import salvo.jesus.util.Heap;
import salvo.jesus.util.HeapNode;
import salvo.jesus.util.HeapNodeComparator;

public class ShortestPathDijkstraAlgorithm
extends ShortestPathAlgorithm {
    private List visited = new ArrayList(10);
    private Heap fringe;
    private WeightedGraph shortestpathtree;
    private HeapNodeComparator comparator;

    public ShortestPathDijkstraAlgorithm(WeightedGraph wgraph, HeapNodeComparator comparator) {
        super(wgraph);
        this.comparator = comparator;
        this.fringe = new Heap(new HeapNodeComparator(1));
    }

    @Override
    public WeightedGraph shortestPath(Vertex from) {
        this.shortestpathtree = new WeightedGraphImpl();
        this.fringe.insert(new HeapNode(new FringeObject(from, null), 0.0));
        while (!this.fringe.isEmpty()) {
            this.moveToVisited();
        }
        this.visited.clear();
        this.fringe.clear();
        return this.shortestpathtree;
    }

    private void moveToVisited() {
        HeapNode prioritynode = this.fringe.remove();
        FringeObject fringeobject = (FringeObject)prioritynode.getObject();
        Vertex priorityvertex = fringeobject.vertex;
        this.visited.add(priorityvertex);
        if (fringeobject.edge != null) {
            try {
                this.shortestpathtree.addEdge(fringeobject.edge);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.moveAdjacentVerticesToFringe(prioritynode);
    }

    private void moveAdjacentVerticesToFringe(HeapNode prioritynode) {
        Vertex priorityvertex = ((FringeObject)prioritynode.getObject()).vertex;
        List incidentedges = this.wgraph.getEdges(priorityvertex);
        double priority = prioritynode.getPriority();
        Iterator iterator = incidentedges.iterator();
        HeapNodeObjectComparator heapnodeobjectcomparator = new HeapNodeObjectComparator();
        while (iterator.hasNext()) {
            double fringepriority;
            WeightedEdge incidentedge = (WeightedEdge)iterator.next();
            Vertex adjacentvertex = incidentedge.getOppositeVertex(priorityvertex);
            if (this.visited.contains(adjacentvertex)) continue;
            HeapNode heapnode = this.fringe.contains(adjacentvertex, heapnodeobjectcomparator);
            if (heapnode == null) {
                fringepriority = priority + incidentedge.getWeight();
                heapnode = new HeapNode(new FringeObject(adjacentvertex, incidentedge), fringepriority);
                this.fringe.insert(heapnode);
                continue;
            }
            fringepriority = priority + incidentedge.getWeight();
            if (this.comparator.compare(new HeapNode(adjacentvertex, fringepriority), heapnode) >= 0) continue;
            this.fringe.setPriority(heapnode, fringepriority);
            FringeObject fobject = (FringeObject)heapnode.getObject();
            fobject.edge = incidentedge;
        }
    }
}

