/*
 * Decompiled with CFR 0.152.
 */
package salvo.jesus.graph.java.awt.geom;

import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class SerializablePathIterator
implements PathIterator,
Serializable {
    private transient PathIterator pIterator;
    private static final int SEG_END = -1;

    public SerializablePathIterator(PathIterator pIterator) {
        this.pIterator = pIterator;
    }

    @Override
    public int getWindingRule() {
        return this.pIterator.getWindingRule();
    }

    @Override
    public boolean isDone() {
        return this.pIterator.isDone();
    }

    @Override
    public void next() {
        this.pIterator.next();
    }

    @Override
    public int currentSegment(float[] segment) {
        return this.pIterator.currentSegment(segment);
    }

    @Override
    public int currentSegment(double[] segment) {
        return this.pIterator.currentSegment(segment);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        SerializablePathIterator iterator = new SerializablePathIterator(this.pIterator);
        float[] segment = new float[6];
        out.defaultWriteObject();
        out.writeInt(iterator.getWindingRule());
        while (!iterator.isDone()) {
            int segmentType = iterator.currentSegment(segment);
            out.writeInt(segmentType);
            switch (segmentType) {
                case 0: {
                    out.writeFloat(segment[0]);
                    out.writeFloat(segment[1]);
                    break;
                }
                case 1: {
                    out.writeFloat(segment[0]);
                    out.writeFloat(segment[1]);
                    break;
                }
                case 2: {
                    out.writeFloat(segment[0]);
                    out.writeFloat(segment[1]);
                    out.writeFloat(segment[2]);
                    out.writeFloat(segment[3]);
                    break;
                }
                case 3: {
                    out.writeFloat(segment[0]);
                    out.writeFloat(segment[1]);
                    out.writeFloat(segment[2]);
                    out.writeFloat(segment[3]);
                    out.writeFloat(segment[4]);
                    out.writeFloat(segment[5]);
                    break;
                }
            }
            iterator.next();
        }
        out.writeInt(-1);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        GeneralPath gPath = new GeneralPath();
        in.defaultReadObject();
        gPath.setWindingRule(in.readInt());
        int segmentType = in.readInt();
        while (segmentType != -1) {
            switch (segmentType) {
                case 0: {
                    gPath.moveTo(in.readFloat(), in.readFloat());
                    break;
                }
                case 1: {
                    gPath.lineTo(in.readFloat(), in.readFloat());
                    break;
                }
                case 2: {
                    gPath.quadTo(in.readFloat(), in.readFloat(), in.readFloat(), in.readFloat());
                    break;
                }
                case 3: {
                    gPath.curveTo(in.readFloat(), in.readFloat(), in.readFloat(), in.readFloat(), in.readFloat(), in.readFloat());
                    break;
                }
            }
            segmentType = in.readInt();
        }
        this.pIterator = gPath.getPathIterator(new AffineTransform());
    }
}

