/*
 * Decompiled with CFR 0.152.
 */
package salvo.jesus.graph.javax.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.geom.GeneralPath;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JViewport;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import salvo.jesus.graph.javax.swing.GeneralPathPanel;

public class GeneralPathPanelList
extends JPanel
implements ListSelectionListener {
    private GeneralPathPanel pathPanel;
    private JScrollPane pathPanelScroller;
    private JList segmentList;
    private JScrollPane listScroller;
    private JSplitPane splitter;

    public GeneralPathPanelList(GeneralPath gPath, Color outlineColor) {
        this.setLayout(new BorderLayout());
        this.pathPanel = new GeneralPathPanel(gPath, outlineColor);
        this.pathPanelScroller = new JScrollPane(this.pathPanel);
        JViewport viewport = new JViewport();
        viewport.setView(this.pathPanel);
        this.pathPanelScroller.setViewport(viewport);
        this.pathPanelScroller.setVerticalScrollBarPolicy(20);
        this.pathPanelScroller.setHorizontalScrollBarPolicy(30);
        this.pathPanelScroller.setMinimumSize(new Dimension(320, 120));
        this.pathPanel.setScrollPane(this.pathPanelScroller);
        this.segmentList = new JList(this.pathPanel.getSegmentVector());
        this.segmentList.setSelectionMode(0);
        this.segmentList.addListSelectionListener(this);
        this.listScroller = new JScrollPane(this.segmentList);
        this.listScroller.setPreferredSize(new Dimension(130, 120));
        this.splitter = new JSplitPane(1, this.listScroller, this.pathPanelScroller);
        this.splitter.setOneTouchExpandable(true);
        this.splitter.setPreferredSize(new Dimension(440, 120));
        this.add((Component)this.splitter, "Center");
        this.setVisible(true);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.pathPanel.setSelectedSegment(this.segmentList.getSelectedIndex());
        this.pathPanel.revalidate();
        this.pathPanel.repaint();
    }

    public void setGeneralPath(GeneralPath newGPath) {
        this.pathPanel.setGeneralPath(newGPath);
        this.segmentList.setListData(this.pathPanel.getSegmentVector());
    }

    public void setOutlineColor(Color newOutlineColor) {
        this.pathPanel.setOutlineColor(newOutlineColor);
    }
}

