/*
 * Decompiled with CFR 0.152.
 */
package salvo.jesus.graph.listener;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import salvo.jesus.graph.GraphAddEdgeEvent;
import salvo.jesus.graph.GraphAddVertexEvent;
import salvo.jesus.graph.GraphRemoveEdgeEvent;
import salvo.jesus.graph.GraphRemoveVertexEvent;
import salvo.jesus.graph.IllegalPathException;
import salvo.jesus.graph.NullVisitor;
import salvo.jesus.graph.Path;
import salvo.jesus.graph.Vertex;
import salvo.jesus.graph.Visitor;
import salvo.jesus.graph.algorithm.GraphTraversal;
import salvo.jesus.graph.listener.AbstractPathListener;
import salvo.jesus.graph.listener.NullGraphListener;

public class PathListener
extends NullGraphListener
implements AbstractPathListener {
    private List m_vertexList;
    private Path m_path;

    public PathListener(Path path) {
        this.m_path = path;
        this.m_path.addListener(this);
        this.m_vertexList = new ArrayList();
        if (this.m_path.getVerticesCount() > 0) {
            this.m_vertexList.addAll(this.m_path.traverse(this.m_path.getFirstVertex()));
        }
    }

    @Override
    public Vertex getFirstVertex() {
        if (this.m_vertexList.isEmpty()) {
            return null;
        }
        return (Vertex)this.m_vertexList.get(0);
    }

    @Override
    public Vertex getLastVertex() {
        if (this.m_vertexList.isEmpty()) {
            return null;
        }
        return (Vertex)this.m_vertexList.get(this.m_vertexList.size() - 1);
    }

    @Override
    public void afterVertexAdded(GraphAddVertexEvent event) {
        if (this.m_vertexList.isEmpty()) {
            this.m_vertexList.add(event.getVertex());
        }
    }

    @Override
    public void afterVertexRemoved(GraphRemoveVertexEvent event) {
        this.m_vertexList.remove(this.m_vertexList.size() - 1);
    }

    @Override
    public void beforeEdgeAdded(GraphAddEdgeEvent event) throws Exception {
        Vertex lastVertex = this.getLastVertex();
        Vertex vA = event.getEdge().getVertexA();
        if (lastVertex != null && lastVertex != vA) {
            throw new IllegalPathException("edge is not contiguous");
        }
    }

    @Override
    public void afterEdgeAdded(GraphAddEdgeEvent event) {
        this.m_vertexList.add(event.getEdge().getVertexB());
    }

    @Override
    public void beforeEdgeRemoved(GraphRemoveEdgeEvent event) throws Exception {
        if (event.getVertex() == null) {
            throw new IllegalPathException("edges cannot be removed");
        }
        if (event.getVertex() != this.getLastVertex()) {
            throw new IllegalPathException("only last vertex can be removed");
        }
        if (this.m_path.getDegree(this.getLastVertex()) > 1) {
            throw new IllegalPathException("crossing vertex cannot be removed");
        }
    }

    public GraphTraversal getTraversal() {
        return new PathTraversal(this.m_path);
    }

    public class PathTraversal
    extends GraphTraversal {
        PathTraversal(Path p_path) {
            super(p_path);
        }

        @Override
        public int traverse(Vertex startat, List visited, Visitor visitor) {
            int i = PathListener.this.m_vertexList.indexOf(startat);
            if (i == -1) {
                throw new NoSuchElementException();
            }
            ListIterator iter = PathListener.this.m_vertexList.listIterator(i);
            while (iter.hasNext()) {
                Vertex v = (Vertex)iter.next();
                visited.add(v);
                if (visitor.visit(v)) continue;
                return -1;
            }
            return 1;
        }

        @Override
        public List traverse(Vertex startat) {
            return this.traverse(startat, new NullVisitor());
        }

        @Override
        public List traverse(Vertex startat, Visitor visitor) {
            ArrayList visited = new ArrayList();
            this.traverse(startat, visited, visitor);
            return visited;
        }
    }
}

