/*
 * Decompiled with CFR 0.152.
 */
package salvo.jesus.graph.listener;

import java.util.NoSuchElementException;
import salvo.jesus.graph.CycleException;
import salvo.jesus.graph.Edge;
import salvo.jesus.graph.GraphAddEdgeEvent;
import salvo.jesus.graph.GraphAddVertexEvent;
import salvo.jesus.graph.GraphRemoveEdgeEvent;
import salvo.jesus.graph.GraphRemoveVertexEvent;
import salvo.jesus.graph.IllegalPathException;
import salvo.jesus.graph.SimplePath;
import salvo.jesus.graph.Vertex;
import salvo.jesus.graph.listener.AbstractPathListener;
import salvo.jesus.graph.listener.NullGraphListener;

public class SimplePathListener
extends NullGraphListener
implements AbstractPathListener {
    private SimplePath m_simplePath;
    private Vertex m_first;
    private Vertex m_last;

    public SimplePathListener(SimplePath simplePath) {
        this.m_simplePath = simplePath;
        if (this.m_simplePath.getVerticesCount() > 0) {
            this.m_first = this.m_simplePath.getFirstVertex();
            this.m_last = this.m_simplePath.getLastVertex();
        }
        this.m_simplePath.addListener(this);
    }

    @Override
    public Vertex getFirstVertex() {
        return this.m_first;
    }

    @Override
    public Vertex getLastVertex() {
        return this.m_last;
    }

    protected SimplePath getPath() {
        return this.m_simplePath;
    }

    public void remove() throws Exception {
        if (this.m_last == null) {
            throw new NoSuchElementException();
        }
        this.m_simplePath.remove(this.m_last);
    }

    @Override
    public void beforeVertexAdded(GraphAddVertexEvent event) throws Exception {
        if (this.m_first == null) {
            return;
        }
        if (event.getEdge() == null) {
            throw new IllegalPathException("adding Vertex would violate path contiguity");
        }
    }

    @Override
    public void afterVertexAdded(GraphAddVertexEvent event) {
        if (this.m_first == null) {
            this.m_first = this.m_last = event.getVertex();
        }
    }

    @Override
    public void afterVertexRemoved(GraphRemoveVertexEvent event) {
        if (event.getVertex() == this.m_first) {
            this.m_first = null;
            this.m_last = null;
        }
    }

    @Override
    public void beforeEdgeAdded(GraphAddEdgeEvent event) throws Exception {
        if (this.m_simplePath.getVerticesCount() == 0) {
            return;
        }
        if (event.isAddingVertexA() && event.isAddingVertexB()) {
            throw new IllegalPathException("Isolated edge cannot be added to path");
        }
        if (!event.isAddingVertexA() && !event.isAddingVertexB()) {
            throw new CycleException();
        }
        int degree = event.isAddingVertexA() ? this.m_simplePath.getDegree(event.getEdge().getVertexB()) : this.m_simplePath.getDegree(event.getEdge().getVertexA());
        if (degree > 1) {
            throw new IllegalPathException("Edge being added violates path linearity");
        }
    }

    @Override
    public void afterEdgeAdded(GraphAddEdgeEvent event) {
        Edge edge = event.getEdge();
        if (this.m_first == this.m_last) {
            this.m_last = edge.getOppositeVertex(this.m_first);
        } else {
            Vertex vA = event.getEdge().getVertexA();
            Vertex vB = event.getEdge().getVertexB();
            if (vA == this.m_first) {
                this.m_first = vB;
            } else if (vA == this.m_last) {
                this.m_last = vB;
            } else if (vB == this.m_first) {
                this.m_first = vA;
            } else if (vB == this.m_last) {
                this.m_last = vA;
            } else {
                throw new IllegalStateException("Edge being added violates path linearity");
            }
        }
    }

    protected boolean isEndpoint(Vertex v) {
        return v == this.m_first || v == this.m_last;
    }

    @Override
    public void beforeEdgeRemoved(GraphRemoveEdgeEvent event) throws Exception {
        if (!this.isEndpoint(event.getVertex())) {
            throw new IllegalPathException("removing Edge would violate path contiguity");
        }
    }

    @Override
    public void afterEdgeRemoved(GraphRemoveEdgeEvent event) {
        Edge edge = event.getEdge();
        if (event.getVertex() == this.m_first) {
            this.m_first = edge.getOppositeVertex(this.m_first);
        } else if (event.getVertex() == this.m_last) {
            this.m_last = edge.getOppositeVertex(this.m_last);
        } else {
            throw new IllegalStateException("removing Edge would violate path contiguity");
        }
    }
}

