/*
 * Decompiled with CFR 0.152.
 */
package salvo.jesus.graph.listener;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import salvo.jesus.graph.CycleException;
import salvo.jesus.graph.Edge;
import salvo.jesus.graph.EmptyTreeException;
import salvo.jesus.graph.GraphAddEdgeEvent;
import salvo.jesus.graph.GraphAddVertexEvent;
import salvo.jesus.graph.GraphException;
import salvo.jesus.graph.GraphRemoveEdgeEvent;
import salvo.jesus.graph.GraphRemoveVertexEvent;
import salvo.jesus.graph.IllegalTreeException;
import salvo.jesus.graph.NoSuchVertexException;
import salvo.jesus.graph.NullVisitor;
import salvo.jesus.graph.StopAtVisitor;
import salvo.jesus.graph.Tree;
import salvo.jesus.graph.Vertex;
import salvo.jesus.graph.algorithm.DepthFirstGraphTraversal;
import salvo.jesus.graph.algorithm.GraphTraversal;
import salvo.jesus.graph.listener.NullGraphListener;

public class TreeListener
extends NullGraphListener {
    private Tree m_tree;
    private Vertex m_rootVertex;

    public TreeListener(Tree tree) {
        this.m_tree = tree;
        this.m_tree.addListener(this);
    }

    @Override
    public void beforeVertexAdded(GraphAddVertexEvent event) throws Exception {
        if (this.m_tree.getVerticesCount() == 0) {
            return;
        }
        if (event.getEdge() == null) {
            throw new IllegalTreeException("Isolated vertex cannot be added to existing tree");
        }
    }

    @Override
    public void afterVertexAdded(GraphAddVertexEvent event) {
        if (this.m_rootVertex == null) {
            this.m_rootVertex = event.getVertex();
        }
    }

    @Override
    public void beforeVertexRemoved(GraphRemoveVertexEvent event) throws Exception {
        if (!this.m_tree.isLeaf(event.getVertex())) {
            throw new IllegalTreeException();
        }
    }

    @Override
    public void afterVertexRemoved(GraphRemoveVertexEvent event) {
        if (event.getVertex() == this.m_rootVertex) {
            this.m_rootVertex = null;
        }
    }

    @Override
    public void beforeEdgeAdded(GraphAddEdgeEvent event) throws Exception {
        if (this.m_tree.getVerticesCount() == 0) {
            return;
        }
        Edge edge = event.getEdge();
        if (event.isAddingVertexA() && event.isAddingVertexB()) {
            throw new IllegalTreeException("Isolated edge cannot be added to existing tree");
        }
        if (!event.isAddingVertexA() && !event.isAddingVertexB()) {
            throw new CycleException();
        }
    }

    @Override
    public void beforeEdgeRemoved(GraphRemoveEdgeEvent event) throws Exception {
        if (event.getVertex() == null) {
            throw new IllegalTreeException("removing Edge would disconnect tree");
        }
        if (this.m_tree.getDegree(event.getVertex()) > 1) {
            throw new IllegalTreeException("removing Vertex would disconnect tree");
        }
    }

    public void setRoot(Vertex rootVertex) throws GraphException {
        if (!this.m_tree.getVertexSet().contains(rootVertex)) {
            throw new NoSuchVertexException();
        }
        this.m_rootVertex = rootVertex;
    }

    public Vertex getRoot() {
        return this.m_rootVertex;
    }

    public boolean isLeaf(Vertex vertex) throws GraphException {
        if (this.m_rootVertex == null) {
            throw new EmptyTreeException();
        }
        return this.m_tree.getRoot() != vertex && this.m_tree.getDegree(vertex) < 2 || this.m_tree.getRoot() == vertex && this.m_tree.getChildren(vertex).size() == 0;
    }

    public Vertex getParent(Vertex vertex) throws GraphException {
        int size;
        if (this.m_rootVertex == null) {
            throw new EmptyTreeException();
        }
        ArrayList visited = new ArrayList(10);
        DepthFirstGraphTraversal traversal = new DepthFirstGraphTraversal(this.m_tree);
        Vertex parent = null;
        List adjacentVertices = this.m_tree.getAdjacentVertices(vertex);
        ((GraphTraversal)traversal).traverse(this.m_rootVertex, visited, new StopAtVisitor(vertex));
        for (int i = size = visited.size(); i > 0; --i) {
            parent = (Vertex)visited.get(i - 1);
            if (!adjacentVertices.contains(parent)) continue;
            return parent;
        }
        return null;
    }

    public List getChildren(Vertex vertex) throws GraphException {
        if (this.m_rootVertex == null) {
            throw new EmptyTreeException();
        }
        ArrayList children = new ArrayList(this.m_tree.getAdjacentVertices(vertex));
        children.remove(this.getParent(vertex));
        return children;
    }

    public Tree getSubTree(Vertex subTreeRootVertex) throws Exception {
        Edge currentEdge;
        if (this.m_rootVertex == null) {
            throw new EmptyTreeException();
        }
        Vertex parent = this.getParent(subTreeRootVertex);
        ArrayList<Vertex> visited = new ArrayList<Vertex>(10);
        DepthFirstGraphTraversal traversal = new DepthFirstGraphTraversal(this.m_tree);
        visited.add(parent);
        ((GraphTraversal)traversal).traverse(subTreeRootVertex, visited, new NullVisitor());
        visited.remove(parent);
        Edge edgeToParent = null;
        ArrayList incidentEdges = this.m_tree.getEdges(subTreeRootVertex);
        for (int i = 0; i < incidentEdges.size(); ++i) {
            currentEdge = (Edge)incidentEdges.get(i);
            if (currentEdge.getVertexA() != parent && currentEdge.getVertexB() != parent) continue;
            edgeToParent = currentEdge;
        }
        Tree subTree = this.m_tree.createTree();
        for (int i = 0; i < visited.size(); ++i) {
            Vertex currentVertex = (Vertex)visited.get(i);
            subTree.add(currentVertex);
            incidentEdges = new ArrayList(this.m_tree.getEdges(currentVertex));
            if (currentVertex == subTreeRootVertex && edgeToParent != null) {
                incidentEdges.remove(edgeToParent);
            }
            for (int j = 0; j < incidentEdges.size(); ++j) {
                currentEdge = (Edge)incidentEdges.get(j);
                subTree.addEdge(currentEdge);
            }
        }
        return subTree;
    }

    public int getDepth(Vertex node) throws GraphException {
        if (!this.m_tree.getVertexSet().contains(node)) {
            throw new NoSuchVertexException();
        }
        Vertex parent = this.getParent(node);
        int depth = 1;
        while (parent != null) {
            parent = this.getParent(parent);
            ++depth;
        }
        return depth;
    }

    public List getLeaves() {
        Iterator iterator = this.m_tree.getVerticesIterator();
        ArrayList<Vertex> leaves = new ArrayList<Vertex>(10);
        while (iterator.hasNext()) {
            Vertex currentVertex = (Vertex)iterator.next();
            if ((this.m_tree.getRoot() != currentVertex || this.m_tree.getVerticesCount() != 1) && (this.m_tree.getRoot() == currentVertex || this.m_tree.getVerticesCount() <= 1 || this.m_tree.getDegree(currentVertex) > 1)) continue;
            leaves.add(currentVertex);
        }
        return leaves;
    }

    public int getHeight() {
        List leaves = this.getLeaves();
        int size = leaves.size();
        int maxHeight = 0;
        int currentVertexHeight = 0;
        for (int i = 0; i < size; ++i) {
            try {
                currentVertexHeight = this.getDepth((Vertex)leaves.get(i));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            maxHeight = Math.max(currentVertexHeight, maxHeight);
        }
        leaves = null;
        return maxHeight;
    }
}

