/*
 * Decompiled with CFR 0.152.
 */
package salvo.jesus.graph.visual;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import salvo.jesus.graph.Graph;
import salvo.jesus.graph.visual.ChangeStateEvent;
import salvo.jesus.graph.visual.GraphPanelNormalState;
import salvo.jesus.graph.visual.GraphPanelState;
import salvo.jesus.graph.visual.GraphScrollPane;
import salvo.jesus.graph.visual.GraphToolBar;
import salvo.jesus.graph.visual.VisualGraph;
import salvo.jesus.graph.visual.layout.GraphLayoutManager;

public class GraphEditor
extends JPanel {
    BorderLayout borderlayout;
    GraphToolBar toolbar;
    GraphScrollPane graphscrollpane;
    JSplitPane splitpane = new JSplitPane(1);

    public GraphEditor() {
        this(new GraphPanelNormalState());
    }

    public GraphEditor(GraphPanelState gps) {
        this(new GraphScrollPane(gps));
    }

    public GraphEditor(GraphScrollPane graphscrollpane) {
        this.graphscrollpane = graphscrollpane;
        this.borderlayout = new BorderLayout();
        this.toolbar = new GraphToolBar(this);
        this.doGraphEditorLayout();
    }

    public GraphEditor(VisualGraph vgraph) {
        this(new GraphScrollPane(vgraph));
    }

    public GraphEditor(Graph graph) {
        this(new VisualGraph(graph));
    }

    public GraphEditor(GraphPanelState gps, VisualGraph vgraph) {
        this(new GraphScrollPane(gps, vgraph));
    }

    public GraphEditor(GraphPanelState gps, Graph g) {
        this(gps, new VisualGraph(g));
    }

    private void doGraphEditorLayout() {
        this.splitpane.setRightComponent(this.graphscrollpane);
        this.splitpane.setOneTouchExpandable(true);
        this.setLayout(this.borderlayout);
        this.add((Component)this.toolbar, "North");
        this.add(this.splitpane);
    }

    public void setLeftPanel(Component component) {
        this.splitpane.setLeftComponent(component);
    }

    public Graph getGraph() {
        return this.graphscrollpane.getVisualGraph().getGraph();
    }

    public VisualGraph getVisualGraph() {
        return this.graphscrollpane.getVisualGraph();
    }

    public void setVisualGraph(VisualGraph vg) {
        this.graphscrollpane.setVisualGraph(vg);
    }

    public void setGraph(Graph graph) {
        this.graphscrollpane.getVisualGraph().setGraph(graph);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
    }

    public void setGraphLayoutManager(GraphLayoutManager layoutmanager) {
        this.graphscrollpane.setGraphLayoutManager(layoutmanager);
    }

    public GraphPanelState processChangeStateEvent(ChangeStateEvent cse) {
        return this.graphscrollpane.processChangeStateEvent(cse);
    }
}

