/*
 * Decompiled with CFR 0.152.
 */
package salvo.jesus.graph.visual;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JPanel;
import salvo.jesus.graph.Graph;
import salvo.jesus.graph.visual.ChangeStateEvent;
import salvo.jesus.graph.visual.GraphPanelEdgeState;
import salvo.jesus.graph.visual.GraphPanelNormalState;
import salvo.jesus.graph.visual.GraphPanelState;
import salvo.jesus.graph.visual.GraphPanelVertexState;
import salvo.jesus.graph.visual.GraphScrollPane;
import salvo.jesus.graph.visual.VisualGraph;
import salvo.jesus.graph.visual.layout.GraphLayoutManager;

public class GraphPanel
extends JPanel
implements MouseListener,
MouseMotionListener,
KeyListener {
    GraphScrollPane gpcontainer;
    VisualGraph vgraph;
    GraphPanelState state;

    GraphPanel() {
        this(new GraphPanelNormalState(), new VisualGraph());
    }

    GraphPanel(VisualGraph vgraph) {
        this(new GraphPanelNormalState(), vgraph);
    }

    GraphPanel(GraphPanelState gps) {
        this(gps, new VisualGraph());
    }

    GraphPanel(GraphPanelState gps, VisualGraph vgraph) {
        this.state = gps;
        gps.setGraphPanel(this);
        this.vgraph = vgraph;
        vgraph.addContainer(this);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setNormalMode();
        this.setBackground(Color.white);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void setVisualGraph(VisualGraph vg, GraphScrollPane gp) {
        if (this.vgraph != null) {
            this.vgraph.removeContainer(this);
        }
        this.vgraph = vg;
        this.vgraph.addContainer(this);
        this.gpcontainer = gp;
        this.repaint();
    }

    public void setGraph(Graph g, GraphScrollPane gp) {
        VisualGraph vg = new VisualGraph();
        vg.setGraph(g);
        this.setVisualGraph(vg, gp);
    }

    public VisualGraph getVisualGraph() {
        return this.vgraph;
    }

    public void setNormalMode() {
        this.state = this.state.recommendState(new ChangeStateEvent(this, new GraphPanelNormalState(this)));
    }

    public void setVertexMode() {
        this.state = this.state.recommendState(new ChangeStateEvent(this, new GraphPanelVertexState(this)));
    }

    public void setEdgeMode() {
        this.state = this.state.recommendState(new ChangeStateEvent(this, new GraphPanelEdgeState(this)));
    }

    public void setGraphLayoutManager(GraphLayoutManager layoutmanager) {
        this.vgraph.setGraphLayoutManager(layoutmanager);
    }

    @Override
    public void paintComponent(Graphics g) {
        Dimension vgraphsize = this.vgraph.getMaxSize();
        int width = vgraphsize.getWidth() > this.gpcontainer.getSize().getWidth() ? (int)vgraphsize.getWidth() : (int)this.gpcontainer.getSize().getWidth();
        int height = vgraphsize.getHeight() > this.gpcontainer.getSize().getHeight() ? (int)vgraphsize.getHeight() : (int)this.gpcontainer.getSize().getHeight();
        this.setSize(width, height);
        this.setPreferredSize(new Dimension(width, height));
        this.revalidate();
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        this.state.paint(g2d);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.state = this.state.mouseDragged(e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.state = this.state.mousePressed(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.state = this.state.mouseReleased(e);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.state = this.state.mouseEntered(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.state = this.state.mouseExited(e);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.state = this.state.mouseClicked(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.state = this.state.mouseMoved(e);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.state = this.state.keyPressed(e);
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.state = this.state.keyReleased(e);
    }

    @Override
    public void keyTyped(KeyEvent e) {
        this.state = this.state.keyTyped(e);
    }

    protected void finalize() {
        this.vgraph.removeContainer(this);
    }

    public GraphPanelState processChangeStateEvent(ChangeStateEvent cse) {
        this.state = this.state.recommendState(cse);
        return this.state;
    }
}

