/*
 * Decompiled with CFR 0.152.
 */
package salvo.jesus.graph.visual;

import java.net.URL;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JRadioButton;
import javax.swing.JToolBar;
import org.apache.log4j.Category;
import salvo.jesus.graph.visual.GraphEditor;
import salvo.jesus.graph.visual.OpenButtonListener;
import salvo.jesus.graph.visual.SaveButtonListener;
import salvo.jesus.graph.visual.ToolBarEdgeButtonListener;
import salvo.jesus.graph.visual.ToolBarLayoutButtonListener;
import salvo.jesus.graph.visual.ToolBarNormalButtonListener;
import salvo.jesus.graph.visual.ToolBarPrintButtonListener;
import salvo.jesus.graph.visual.ToolBarVertexButtonListener;

class GraphToolBar
extends JToolBar {
    GraphEditor editor;
    ButtonGroup moderadiogroup;
    JRadioButton selectradiobutton;
    JRadioButton vertexradiobutton;
    JRadioButton edgeradiobutton;
    JButton layoutbutton;
    JButton printButton;
    JButton openButton;
    JButton saveButton;
    static Category logger = Category.getInstance((String)GraphToolBar.class.getName());

    GraphToolBar(GraphEditor editor) {
        this.editor = editor;
        this.moderadiogroup = new ButtonGroup();
        this.openButton = new JButton(this.getImageIcon("images/Zvaiofu041.gif"));
        this.openButton.setToolTipText("Open");
        this.openButton.setVerticalTextPosition(3);
        this.openButton.setHorizontalTextPosition(0);
        this.openButton.setContentAreaFilled(false);
        this.openButton.setBorderPainted(true);
        this.openButton.addActionListener(new OpenButtonListener(this.editor));
        this.add(this.openButton);
        this.saveButton = new JButton(this.getImageIcon("images/Zvaiofu006.gif"));
        this.saveButton.setToolTipText("Save");
        this.saveButton.setVerticalTextPosition(3);
        this.saveButton.setHorizontalTextPosition(0);
        this.saveButton.setContentAreaFilled(false);
        this.saveButton.setBorderPainted(true);
        this.saveButton.addActionListener(new SaveButtonListener(this.editor));
        this.add(this.saveButton);
        this.addSeparator();
        this.addSeparator();
        this.selectradiobutton = new JRadioButton(this.getImageIcon("images/pointer.gif"));
        this.selectradiobutton.setToolTipText("Select");
        this.selectradiobutton.setSelectedIcon(this.getImageIcon("images/selected_pointer.gif"));
        this.selectradiobutton.setVerticalTextPosition(3);
        this.selectradiobutton.setHorizontalTextPosition(0);
        this.selectradiobutton.setSelected(true);
        this.moderadiogroup.add(this.selectradiobutton);
        this.add(this.selectradiobutton);
        this.selectradiobutton.addActionListener(new ToolBarNormalButtonListener(this.editor));
        this.vertexradiobutton = new JRadioButton(this.getImageIcon("images/rectangle.gif"));
        this.vertexradiobutton.setToolTipText("Vertex");
        this.vertexradiobutton.setSelectedIcon(this.getImageIcon("images/selected_rectangle.gif"));
        this.vertexradiobutton.setVerticalTextPosition(3);
        this.vertexradiobutton.setHorizontalTextPosition(0);
        this.moderadiogroup.add(this.vertexradiobutton);
        this.add(this.vertexradiobutton);
        this.vertexradiobutton.addActionListener(new ToolBarVertexButtonListener(this.editor));
        this.edgeradiobutton = new JRadioButton(this.getImageIcon("images/line.gif"));
        this.edgeradiobutton.setToolTipText("Edge");
        this.edgeradiobutton.setSelectedIcon(this.getImageIcon("images/selected_line.gif"));
        this.edgeradiobutton.setVerticalTextPosition(3);
        this.edgeradiobutton.setHorizontalTextPosition(0);
        this.moderadiogroup.add(this.edgeradiobutton);
        this.add(this.edgeradiobutton);
        this.edgeradiobutton.addActionListener(new ToolBarEdgeButtonListener(this.editor));
        this.addSeparator();
        this.addSeparator();
        this.layoutbutton = new JButton(this.getImageIcon("images/layout.gif"));
        this.layoutbutton.setToolTipText("Layout");
        this.layoutbutton.setPressedIcon(this.getImageIcon("images/selected_layout.gif"));
        this.layoutbutton.setVerticalTextPosition(3);
        this.layoutbutton.setHorizontalTextPosition(0);
        this.layoutbutton.setContentAreaFilled(false);
        this.layoutbutton.setBorderPainted(false);
        this.layoutbutton.addActionListener(new ToolBarLayoutButtonListener(this.editor));
        this.add(this.layoutbutton);
        this.addSeparator();
        this.addSeparator();
        this.printButton = new JButton(this.getImageIcon("images/printer.jpg"));
        this.printButton.setToolTipText("Print");
        this.printButton.setPressedIcon(this.getImageIcon("images/selected_printer.jpg"));
        this.printButton.setVerticalTextPosition(3);
        this.printButton.setHorizontalTextPosition(0);
        this.printButton.setContentAreaFilled(false);
        this.printButton.setBorderPainted(false);
        this.printButton.addActionListener(new ToolBarPrintButtonListener(this.editor));
        this.add(this.printButton);
        this.setFloatable(true);
    }

    private ImageIcon getImageIcon(String imagefilename) {
        ImageIcon imgicon = null;
        try {
            logger.debug((Object)("Loading imgicon " + imagefilename));
            URL imageURL = this.getClass().getResource(imagefilename);
            imgicon = new ImageIcon(imageURL);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.warn((Object)("Unable to obtain image " + imagefilename));
        }
        return imgicon;
    }
}

