/*
 * Decompiled with CFR 0.152.
 */
package salvo.jesus.graph.visual;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileReader;
import javax.swing.JFileChooser;
import salvo.jesus.graph.visual.GraphEditor;
import salvo.jesus.graph.visual.GraphToolBar;
import salvo.jesus.graph.visual.VisualGraph;
import salvo.jesus.graph.visual.XMLFileFilter;
import salvo.jesus.graph.xml.XGMMLContentHandler;
import salvo.jesus.graph.xml.XMLToGraphHandler;
import salvo.jesus.graph.xml.XMLToGraphReader;

class OpenButtonListener
implements ActionListener {
    GraphEditor editor;
    File file;
    FileReader reader;
    XMLToGraphHandler xmlHandler;
    XMLToGraphReader xmlReader;

    public OpenButtonListener(GraphEditor editor) {
        this.editor = editor;
    }

    @Override
    public void actionPerformed(ActionEvent actionevent) {
        JFileChooser chooser = new JFileChooser();
        XMLFileFilter filter = new XMLFileFilter();
        chooser.setFileFilter(filter);
        int returnVal = chooser.showOpenDialog(this.editor);
        if (returnVal != 0) {
            return;
        }
        this.file = chooser.getSelectedFile();
        try {
            this.reader = new FileReader(this.file);
            this.xmlHandler = new XGMMLContentHandler();
            this.xmlReader = new XMLToGraphReader(this.reader, this.xmlHandler);
            this.xmlReader.parse();
            VisualGraph vGraph = this.xmlHandler.getVisualGraph();
            this.editor.setVisualGraph(vGraph);
            this.editor.repaint();
        }
        catch (Exception ex) {
            GraphToolBar.logger.error((Object)ex);
        }
    }
}

